/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="A representation of where a transaction took place.  Use this field to pass in structured location information you may have about your transactions. Providing location data is optional but can increase result quality. If you have unstructured location information, it may be appended to the `description` field.")
public class ClientProvidedTransactionLocation {
    public static final String SERIALIZED_NAME_COUNTRY = "country";
    @SerializedName(value="country")
    private String country;
    public static final String SERIALIZED_NAME_REGION = "region";
    @SerializedName(value="region")
    private String region;
    public static final String SERIALIZED_NAME_CITY = "city";
    @SerializedName(value="city")
    private String city;
    public static final String SERIALIZED_NAME_ADDRESS = "address";
    @SerializedName(value="address")
    private String address;
    public static final String SERIALIZED_NAME_POSTAL_CODE = "postal_code";
    @SerializedName(value="postal_code")
    private String postalCode;

    public ClientProvidedTransactionLocation country(String country) {
        this.country = country;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The country where the transaction occurred.")
    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public ClientProvidedTransactionLocation region(String region) {
        this.region = region;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The region or state where the transaction occurred.")
    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public ClientProvidedTransactionLocation city(String city) {
        this.city = city;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The city where the transaction occurred.")
    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public ClientProvidedTransactionLocation address(String address) {
        this.address = address;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The street address where the transaction occurred.")
    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public ClientProvidedTransactionLocation postalCode(String postalCode) {
        this.postalCode = postalCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The postal code where the transaction occurred.")
    public String getPostalCode() {
        return this.postalCode;
    }

    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientProvidedTransactionLocation clientProvidedTransactionLocation = (ClientProvidedTransactionLocation)o;
        return Objects.equals(this.country, clientProvidedTransactionLocation.country) && Objects.equals(this.region, clientProvidedTransactionLocation.region) && Objects.equals(this.city, clientProvidedTransactionLocation.city) && Objects.equals(this.address, clientProvidedTransactionLocation.address) && Objects.equals(this.postalCode, clientProvidedTransactionLocation.postalCode);
    }

    public int hashCode() {
        return Objects.hash(this.country, this.region, this.city, this.address, this.postalCode);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ClientProvidedTransactionLocation {\n");
        sb.append("    country: ").append(this.toIndentedString(this.country)).append("\n");
        sb.append("    region: ").append(this.toIndentedString(this.region)).append("\n");
        sb.append("    city: ").append(this.toIndentedString(this.city)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    postalCode: ").append(this.toIndentedString(this.postalCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

