/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.ScopesNullable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Describes the connected application for a particular end user.")
public class ConnectedApplication {
    public static final String SERIALIZED_NAME_APPLICATION_ID = "application_id";
    @SerializedName(value="application_id")
    private String applicationId;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_DISPLAY_NAME = "display_name";
    @SerializedName(value="display_name")
    private String displayName;
    public static final String SERIALIZED_NAME_LOGO_URL = "logo_url";
    @SerializedName(value="logo_url")
    private String logoUrl;
    public static final String SERIALIZED_NAME_APPLICATION_URL = "application_url";
    @SerializedName(value="application_url")
    private String applicationUrl;
    public static final String SERIALIZED_NAME_REASON_FOR_ACCESS = "reason_for_access";
    @SerializedName(value="reason_for_access")
    private String reasonForAccess;
    public static final String SERIALIZED_NAME_CREATED_AT = "created_at";
    @SerializedName(value="created_at")
    private OffsetDateTime createdAt;
    public static final String SERIALIZED_NAME_SCOPES = "scopes";
    @SerializedName(value="scopes")
    private ScopesNullable scopes;

    public ConnectedApplication applicationId(String applicationId) {
        this.applicationId = applicationId;
        return this;
    }

    @ApiModelProperty(required=true, value="This field will map to the application ID that is returned from /item/application/list, or provided to the institution in an oauth redirect.")
    public String getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public ConnectedApplication name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="The name of the application")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ConnectedApplication displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A human-readable name of the application for display purposes")
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public ConnectedApplication logoUrl(String logoUrl) {
        this.logoUrl = logoUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A URL that links to the application logo image.")
    public String getLogoUrl() {
        return this.logoUrl;
    }

    public void setLogoUrl(String logoUrl) {
        this.logoUrl = logoUrl;
    }

    public ConnectedApplication applicationUrl(String applicationUrl) {
        this.applicationUrl = applicationUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The URL for the application's website")
    public String getApplicationUrl() {
        return this.applicationUrl;
    }

    public void setApplicationUrl(String applicationUrl) {
        this.applicationUrl = applicationUrl;
    }

    public ConnectedApplication reasonForAccess(String reasonForAccess) {
        this.reasonForAccess = reasonForAccess;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A string provided by the connected app stating why they use their respective enabled products.")
    public String getReasonForAccess() {
        return this.reasonForAccess;
    }

    public void setReasonForAccess(String reasonForAccess) {
        this.reasonForAccess = reasonForAccess;
    }

    public ConnectedApplication createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @ApiModelProperty(required=true, value="The date this application was linked in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) (YYYY-MM-DD) format in UTC.")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public ConnectedApplication scopes(ScopesNullable scopes) {
        this.scopes = scopes;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public ScopesNullable getScopes() {
        return this.scopes;
    }

    public void setScopes(ScopesNullable scopes) {
        this.scopes = scopes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConnectedApplication connectedApplication = (ConnectedApplication)o;
        return Objects.equals(this.applicationId, connectedApplication.applicationId) && Objects.equals(this.name, connectedApplication.name) && Objects.equals(this.displayName, connectedApplication.displayName) && Objects.equals(this.logoUrl, connectedApplication.logoUrl) && Objects.equals(this.applicationUrl, connectedApplication.applicationUrl) && Objects.equals(this.reasonForAccess, connectedApplication.reasonForAccess) && Objects.equals(this.createdAt, connectedApplication.createdAt) && Objects.equals(this.scopes, connectedApplication.scopes);
    }

    public int hashCode() {
        return Objects.hash(this.applicationId, this.name, this.displayName, this.logoUrl, this.applicationUrl, this.reasonForAccess, this.createdAt, this.scopes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ConnectedApplication {\n");
        sb.append("    applicationId: ").append(this.toIndentedString(this.applicationId)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    logoUrl: ").append(this.toIndentedString(this.logoUrl)).append("\n");
        sb.append("    applicationUrl: ").append(this.toIndentedString(this.applicationUrl)).append("\n");
        sb.append("    reasonForAccess: ").append(this.toIndentedString(this.reasonForAccess)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    scopes: ").append(this.toIndentedString(this.scopes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

