/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.AddressData;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="This object defines the user identity data collected for consumer report purposes. This field is required if you are planning on using the user token with Plaid Check products.")
public class ConsumerReportUserIdentity {
    public static final String SERIALIZED_NAME_FIRST_NAME = "first_name";
    @SerializedName(value="first_name")
    private String firstName;
    public static final String SERIALIZED_NAME_LAST_NAME = "last_name";
    @SerializedName(value="last_name")
    private String lastName;
    public static final String SERIALIZED_NAME_PHONE_NUMBERS = "phone_numbers";
    @SerializedName(value="phone_numbers")
    private List<String> phoneNumbers = new ArrayList<String>();
    public static final String SERIALIZED_NAME_EMAILS = "emails";
    @SerializedName(value="emails")
    private List<String> emails = new ArrayList<String>();
    public static final String SERIALIZED_NAME_PRIMARY_ADDRESS = "primary_address";
    @SerializedName(value="primary_address")
    private AddressData primaryAddress;

    public ConsumerReportUserIdentity firstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    @ApiModelProperty(required=true, value="The user's first name")
    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public ConsumerReportUserIdentity lastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    @ApiModelProperty(required=true, value="The user's last name")
    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public ConsumerReportUserIdentity phoneNumbers(List<String> phoneNumbers) {
        this.phoneNumbers = phoneNumbers;
        return this;
    }

    public ConsumerReportUserIdentity addPhoneNumbersItem(String phoneNumbersItem) {
        this.phoneNumbers.add(phoneNumbersItem);
        return this;
    }

    @ApiModelProperty(required=true, value="The user's phone numbers. The format of phone number will be validated and for better normalization, it is expected to be in E.164 format +{countrycode}{number}, for example `+14151234567`.")
    public List<String> getPhoneNumbers() {
        return this.phoneNumbers;
    }

    public void setPhoneNumbers(List<String> phoneNumbers) {
        this.phoneNumbers = phoneNumbers;
    }

    public ConsumerReportUserIdentity emails(List<String> emails) {
        this.emails = emails;
        return this;
    }

    public ConsumerReportUserIdentity addEmailsItem(String emailsItem) {
        this.emails.add(emailsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="The user's emails")
    public List<String> getEmails() {
        return this.emails;
    }

    public void setEmails(List<String> emails) {
        this.emails = emails;
    }

    public ConsumerReportUserIdentity primaryAddress(AddressData primaryAddress) {
        this.primaryAddress = primaryAddress;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public AddressData getPrimaryAddress() {
        return this.primaryAddress;
    }

    public void setPrimaryAddress(AddressData primaryAddress) {
        this.primaryAddress = primaryAddress;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConsumerReportUserIdentity consumerReportUserIdentity = (ConsumerReportUserIdentity)o;
        return Objects.equals(this.firstName, consumerReportUserIdentity.firstName) && Objects.equals(this.lastName, consumerReportUserIdentity.lastName) && Objects.equals(this.phoneNumbers, consumerReportUserIdentity.phoneNumbers) && Objects.equals(this.emails, consumerReportUserIdentity.emails) && Objects.equals(this.primaryAddress, consumerReportUserIdentity.primaryAddress);
    }

    public int hashCode() {
        return Objects.hash(this.firstName, this.lastName, this.phoneNumbers, this.emails, this.primaryAddress);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ConsumerReportUserIdentity {\n");
        sb.append("    firstName: ").append(this.toIndentedString(this.firstName)).append("\n");
        sb.append("    lastName: ").append(this.toIndentedString(this.lastName)).append("\n");
        sb.append("    phoneNumbers: ").append(this.toIndentedString(this.phoneNumbers)).append("\n");
        sb.append("    emails: ").append(this.toIndentedString(this.emails)).append("\n");
        sb.append("    primaryAddress: ").append(this.toIndentedString(this.primaryAddress)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

