/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.CraBankIncomeItem;
import com.plaid.client.model.CraBankIncomeSummary;
import com.plaid.client.model.CraBankIncomeWarning;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The report of the Bank Income data for an end user.")
public class CraBankIncome {
    public static final String SERIALIZED_NAME_BANK_INCOME_ID = "bank_income_id";
    @SerializedName(value="bank_income_id")
    private String bankIncomeId;
    public static final String SERIALIZED_NAME_GENERATED_TIME = "generated_time";
    @SerializedName(value="generated_time")
    private OffsetDateTime generatedTime;
    public static final String SERIALIZED_NAME_DAYS_REQUESTED = "days_requested";
    @SerializedName(value="days_requested")
    private Integer daysRequested;
    public static final String SERIALIZED_NAME_ITEMS = "items";
    @SerializedName(value="items")
    private List<CraBankIncomeItem> items = null;
    public static final String SERIALIZED_NAME_BANK_INCOME_SUMMARY = "bank_income_summary";
    @SerializedName(value="bank_income_summary")
    private CraBankIncomeSummary bankIncomeSummary;
    public static final String SERIALIZED_NAME_WARNINGS = "warnings";
    @SerializedName(value="warnings")
    private List<CraBankIncomeWarning> warnings = null;

    public CraBankIncome bankIncomeId(String bankIncomeId) {
        this.bankIncomeId = bankIncomeId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The unique identifier associated with the Bank Income Report.")
    public String getBankIncomeId() {
        return this.bankIncomeId;
    }

    public void setBankIncomeId(String bankIncomeId) {
        this.bankIncomeId = bankIncomeId;
    }

    public CraBankIncome generatedTime(OffsetDateTime generatedTime) {
        this.generatedTime = generatedTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The time when the Bank Income Report was generated.")
    public OffsetDateTime getGeneratedTime() {
        return this.generatedTime;
    }

    public void setGeneratedTime(OffsetDateTime generatedTime) {
        this.generatedTime = generatedTime;
    }

    public CraBankIncome daysRequested(Integer daysRequested) {
        this.daysRequested = daysRequested;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of days requested by the customer for the Bank Income Report.")
    public Integer getDaysRequested() {
        return this.daysRequested;
    }

    public void setDaysRequested(Integer daysRequested) {
        this.daysRequested = daysRequested;
    }

    public CraBankIncome items(List<CraBankIncomeItem> items) {
        this.items = items;
        return this;
    }

    public CraBankIncome addItemsItem(CraBankIncomeItem itemsItem) {
        if (this.items == null) {
            this.items = new ArrayList<CraBankIncomeItem>();
        }
        this.items.add(itemsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The list of Items in the report along with the associated metadata about the Item.")
    public List<CraBankIncomeItem> getItems() {
        return this.items;
    }

    public void setItems(List<CraBankIncomeItem> items) {
        this.items = items;
    }

    public CraBankIncome bankIncomeSummary(CraBankIncomeSummary bankIncomeSummary) {
        this.bankIncomeSummary = bankIncomeSummary;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public CraBankIncomeSummary getBankIncomeSummary() {
        return this.bankIncomeSummary;
    }

    public void setBankIncomeSummary(CraBankIncomeSummary bankIncomeSummary) {
        this.bankIncomeSummary = bankIncomeSummary;
    }

    public CraBankIncome warnings(List<CraBankIncomeWarning> warnings) {
        this.warnings = warnings;
        return this;
    }

    public CraBankIncome addWarningsItem(CraBankIncomeWarning warningsItem) {
        if (this.warnings == null) {
            this.warnings = new ArrayList<CraBankIncomeWarning>();
        }
        this.warnings.add(warningsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If data from the Bank Income report was unable to be retrieved, the warnings will contain information about the error that caused the data to be incomplete.")
    public List<CraBankIncomeWarning> getWarnings() {
        return this.warnings;
    }

    public void setWarnings(List<CraBankIncomeWarning> warnings) {
        this.warnings = warnings;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CraBankIncome craBankIncome = (CraBankIncome)o;
        return Objects.equals(this.bankIncomeId, craBankIncome.bankIncomeId) && Objects.equals(this.generatedTime, craBankIncome.generatedTime) && Objects.equals(this.daysRequested, craBankIncome.daysRequested) && Objects.equals(this.items, craBankIncome.items) && Objects.equals(this.bankIncomeSummary, craBankIncome.bankIncomeSummary) && Objects.equals(this.warnings, craBankIncome.warnings);
    }

    public int hashCode() {
        return Objects.hash(this.bankIncomeId, this.generatedTime, this.daysRequested, this.items, this.bankIncomeSummary, this.warnings);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CraBankIncome {\n");
        sb.append("    bankIncomeId: ").append(this.toIndentedString(this.bankIncomeId)).append("\n");
        sb.append("    generatedTime: ").append(this.toIndentedString(this.generatedTime)).append("\n");
        sb.append("    daysRequested: ").append(this.toIndentedString(this.daysRequested)).append("\n");
        sb.append("    items: ").append(this.toIndentedString(this.items)).append("\n");
        sb.append("    bankIncomeSummary: ").append(this.toIndentedString(this.bankIncomeSummary)).append("\n");
        sb.append("    warnings: ").append(this.toIndentedString(this.warnings)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

