/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.CreditBankIncomeAccountType;
import com.plaid.client.model.DepositoryAccountSubtype;
import com.plaid.client.model.Owner;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The Item's bank accounts that have the selected data.")
public class CraBankIncomeAccount {
    public static final String SERIALIZED_NAME_ACCOUNT_ID = "account_id";
    @SerializedName(value="account_id")
    private String accountId;
    public static final String SERIALIZED_NAME_MASK = "mask";
    @SerializedName(value="mask")
    private String mask;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_OFFICIAL_NAME = "official_name";
    @SerializedName(value="official_name")
    private String officialName;
    public static final String SERIALIZED_NAME_SUBTYPE = "subtype";
    @SerializedName(value="subtype")
    private DepositoryAccountSubtype subtype;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private CreditBankIncomeAccountType type;
    public static final String SERIALIZED_NAME_OWNERS = "owners";
    @SerializedName(value="owners")
    private List<Owner> owners = new ArrayList<Owner>();

    public CraBankIncomeAccount accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Plaid\u2019s unique identifier for the account. This value will not change unless Plaid can't reconcile the account with the data returned by the financial institution. This may occur, for example, when the name of the account changes. If this happens a new `account_id` will be assigned to the account.  If an account with a specific `account_id` disappears instead of changing, the account is likely closed. Closed accounts are not returned by the Plaid API.  Like all Plaid identifiers, the `account_id` is case sensitive.")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public CraBankIncomeAccount mask(String mask) {
        this.mask = mask;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The last 2-4 alphanumeric characters of an account's official account number. Note that the mask may be non-unique between an Item's accounts, and it may also not match the mask that the bank displays to the user.")
    public String getMask() {
        return this.mask;
    }

    public void setMask(String mask) {
        this.mask = mask;
    }

    public CraBankIncomeAccount name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="The name of the bank account.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CraBankIncomeAccount officialName(String officialName) {
        this.officialName = officialName;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The official name of the bank account.")
    public String getOfficialName() {
        return this.officialName;
    }

    public void setOfficialName(String officialName) {
        this.officialName = officialName;
    }

    public CraBankIncomeAccount subtype(DepositoryAccountSubtype subtype) {
        this.subtype = subtype;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public DepositoryAccountSubtype getSubtype() {
        return this.subtype;
    }

    public void setSubtype(DepositoryAccountSubtype subtype) {
        this.subtype = subtype;
    }

    public CraBankIncomeAccount type(CreditBankIncomeAccountType type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public CreditBankIncomeAccountType getType() {
        return this.type;
    }

    public void setType(CreditBankIncomeAccountType type) {
        this.type = type;
    }

    public CraBankIncomeAccount owners(List<Owner> owners) {
        this.owners = owners;
        return this;
    }

    public CraBankIncomeAccount addOwnersItem(Owner ownersItem) {
        this.owners.add(ownersItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Data returned by the financial institution about the account owner or owners. Identity information is optional, so field may return an empty array.")
    public List<Owner> getOwners() {
        return this.owners;
    }

    public void setOwners(List<Owner> owners) {
        this.owners = owners;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CraBankIncomeAccount craBankIncomeAccount = (CraBankIncomeAccount)o;
        return Objects.equals(this.accountId, craBankIncomeAccount.accountId) && Objects.equals(this.mask, craBankIncomeAccount.mask) && Objects.equals(this.name, craBankIncomeAccount.name) && Objects.equals(this.officialName, craBankIncomeAccount.officialName) && Objects.equals((Object)this.subtype, (Object)craBankIncomeAccount.subtype) && Objects.equals((Object)this.type, (Object)craBankIncomeAccount.type) && Objects.equals(this.owners, craBankIncomeAccount.owners);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountId, this.mask, this.name, this.officialName, this.subtype, this.type, this.owners});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CraBankIncomeAccount {\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    mask: ").append(this.toIndentedString(this.mask)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    officialName: ").append(this.toIndentedString(this.officialName)).append("\n");
        sb.append("    subtype: ").append(this.toIndentedString((Object)this.subtype)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    owners: ").append(this.toIndentedString(this.owners)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

