/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.CraBankIncomeTransaction;
import com.plaid.client.model.CreditAmountWithCurrency;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The end user's monthly summary for the income source(s).")
public class CraBankIncomeHistoricalSummary {
    public static final String SERIALIZED_NAME_TOTAL_AMOUNTS = "total_amounts";
    @SerializedName(value="total_amounts")
    private List<CreditAmountWithCurrency> totalAmounts = null;
    public static final String SERIALIZED_NAME_START_DATE = "start_date";
    @SerializedName(value="start_date")
    private LocalDate startDate;
    public static final String SERIALIZED_NAME_END_DATE = "end_date";
    @SerializedName(value="end_date")
    private LocalDate endDate;
    public static final String SERIALIZED_NAME_TRANSACTIONS = "transactions";
    @SerializedName(value="transactions")
    private List<CraBankIncomeTransaction> transactions = null;

    public CraBankIncomeHistoricalSummary totalAmounts(List<CreditAmountWithCurrency> totalAmounts) {
        this.totalAmounts = totalAmounts;
        return this;
    }

    public CraBankIncomeHistoricalSummary addTotalAmountsItem(CreditAmountWithCurrency totalAmountsItem) {
        if (this.totalAmounts == null) {
            this.totalAmounts = new ArrayList<CreditAmountWithCurrency>();
        }
        this.totalAmounts.add(totalAmountsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Total amount of earnings for the income source(s) of the user for the month in the summary. This can contain multiple amounts, with each amount denominated in one unique currency.")
    public List<CreditAmountWithCurrency> getTotalAmounts() {
        return this.totalAmounts;
    }

    public void setTotalAmounts(List<CreditAmountWithCurrency> totalAmounts) {
        this.totalAmounts = totalAmounts;
    }

    public CraBankIncomeHistoricalSummary startDate(LocalDate startDate) {
        this.startDate = startDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The start date of the period covered in this monthly summary. This date will be the first day of the month, unless the month being covered is a partial month because it is the first month included in the summary and the date range being requested does not begin with the first day of the month. The date will be returned in an ISO 8601 format (YYYY-MM-DD).")
    public LocalDate getStartDate() {
        return this.startDate;
    }

    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    public CraBankIncomeHistoricalSummary endDate(LocalDate endDate) {
        this.endDate = endDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The end date of the period included in this monthly summary. This date will be the last day of the month, unless the month being covered is a partial month because it is the last month included in the summary and the date range being requested does not end with the last day of the month. The date will be returned in an ISO 8601 format (YYYY-MM-DD).")
    public LocalDate getEndDate() {
        return this.endDate;
    }

    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    public CraBankIncomeHistoricalSummary transactions(List<CraBankIncomeTransaction> transactions) {
        this.transactions = transactions;
        return this;
    }

    public CraBankIncomeHistoricalSummary addTransactionsItem(CraBankIncomeTransaction transactionsItem) {
        if (this.transactions == null) {
            this.transactions = new ArrayList<CraBankIncomeTransaction>();
        }
        this.transactions.add(transactionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public List<CraBankIncomeTransaction> getTransactions() {
        return this.transactions;
    }

    public void setTransactions(List<CraBankIncomeTransaction> transactions) {
        this.transactions = transactions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CraBankIncomeHistoricalSummary craBankIncomeHistoricalSummary = (CraBankIncomeHistoricalSummary)o;
        return Objects.equals(this.totalAmounts, craBankIncomeHistoricalSummary.totalAmounts) && Objects.equals(this.startDate, craBankIncomeHistoricalSummary.startDate) && Objects.equals(this.endDate, craBankIncomeHistoricalSummary.endDate) && Objects.equals(this.transactions, craBankIncomeHistoricalSummary.transactions);
    }

    public int hashCode() {
        return Objects.hash(this.totalAmounts, this.startDate, this.endDate, this.transactions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CraBankIncomeHistoricalSummary {\n");
        sb.append("    totalAmounts: ").append(this.toIndentedString(this.totalAmounts)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    transactions: ").append(this.toIndentedString(this.transactions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

