/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.CraBankIncomeAccount;
import com.plaid.client.model.CraBankIncomeSource;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The details and metadata for an end user's Item.")
public class CraBankIncomeItem {
    public static final String SERIALIZED_NAME_ITEM_ID = "item_id";
    @SerializedName(value="item_id")
    private String itemId;
    public static final String SERIALIZED_NAME_BANK_INCOME_ACCOUNTS = "bank_income_accounts";
    @SerializedName(value="bank_income_accounts")
    private List<CraBankIncomeAccount> bankIncomeAccounts = new ArrayList<CraBankIncomeAccount>();
    public static final String SERIALIZED_NAME_BANK_INCOME_SOURCES = "bank_income_sources";
    @SerializedName(value="bank_income_sources")
    private List<CraBankIncomeSource> bankIncomeSources = new ArrayList<CraBankIncomeSource>();
    public static final String SERIALIZED_NAME_LAST_UPDATED_TIME = "last_updated_time";
    @SerializedName(value="last_updated_time")
    private OffsetDateTime lastUpdatedTime;
    public static final String SERIALIZED_NAME_INSTITUTION_ID = "institution_id";
    @SerializedName(value="institution_id")
    private String institutionId;
    public static final String SERIALIZED_NAME_INSTITUTION_NAME = "institution_name";
    @SerializedName(value="institution_name")
    private String institutionName;

    public CraBankIncomeItem itemId(String itemId) {
        this.itemId = itemId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The `item_id` of the Item associated with this webhook, warning, or error")
    public String getItemId() {
        return this.itemId;
    }

    public void setItemId(String itemId) {
        this.itemId = itemId;
    }

    public CraBankIncomeItem bankIncomeAccounts(List<CraBankIncomeAccount> bankIncomeAccounts) {
        this.bankIncomeAccounts = bankIncomeAccounts;
        return this;
    }

    public CraBankIncomeItem addBankIncomeAccountsItem(CraBankIncomeAccount bankIncomeAccountsItem) {
        this.bankIncomeAccounts.add(bankIncomeAccountsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="The Item's accounts that have Bank Income data.")
    public List<CraBankIncomeAccount> getBankIncomeAccounts() {
        return this.bankIncomeAccounts;
    }

    public void setBankIncomeAccounts(List<CraBankIncomeAccount> bankIncomeAccounts) {
        this.bankIncomeAccounts = bankIncomeAccounts;
    }

    public CraBankIncomeItem bankIncomeSources(List<CraBankIncomeSource> bankIncomeSources) {
        this.bankIncomeSources = bankIncomeSources;
        return this;
    }

    public CraBankIncomeItem addBankIncomeSourcesItem(CraBankIncomeSource bankIncomeSourcesItem) {
        this.bankIncomeSources.add(bankIncomeSourcesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="The income sources for this Item. Each entry in the array is a single income source.")
    public List<CraBankIncomeSource> getBankIncomeSources() {
        return this.bankIncomeSources;
    }

    public void setBankIncomeSources(List<CraBankIncomeSource> bankIncomeSources) {
        this.bankIncomeSources = bankIncomeSources;
    }

    public CraBankIncomeItem lastUpdatedTime(OffsetDateTime lastUpdatedTime) {
        this.lastUpdatedTime = lastUpdatedTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The time when this Item's data was last retrieved from the financial institution.")
    public OffsetDateTime getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public void setLastUpdatedTime(OffsetDateTime lastUpdatedTime) {
        this.lastUpdatedTime = lastUpdatedTime;
    }

    public CraBankIncomeItem institutionId(String institutionId) {
        this.institutionId = institutionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The unique identifier of the institution associated with the Item.")
    public String getInstitutionId() {
        return this.institutionId;
    }

    public void setInstitutionId(String institutionId) {
        this.institutionId = institutionId;
    }

    public CraBankIncomeItem institutionName(String institutionName) {
        this.institutionName = institutionName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The name of the institution associated with the Item.")
    public String getInstitutionName() {
        return this.institutionName;
    }

    public void setInstitutionName(String institutionName) {
        this.institutionName = institutionName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CraBankIncomeItem craBankIncomeItem = (CraBankIncomeItem)o;
        return Objects.equals(this.itemId, craBankIncomeItem.itemId) && Objects.equals(this.bankIncomeAccounts, craBankIncomeItem.bankIncomeAccounts) && Objects.equals(this.bankIncomeSources, craBankIncomeItem.bankIncomeSources) && Objects.equals(this.lastUpdatedTime, craBankIncomeItem.lastUpdatedTime) && Objects.equals(this.institutionId, craBankIncomeItem.institutionId) && Objects.equals(this.institutionName, craBankIncomeItem.institutionName);
    }

    public int hashCode() {
        return Objects.hash(this.itemId, this.bankIncomeAccounts, this.bankIncomeSources, this.lastUpdatedTime, this.institutionId, this.institutionName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CraBankIncomeItem {\n");
        sb.append("    itemId: ").append(this.toIndentedString(this.itemId)).append("\n");
        sb.append("    bankIncomeAccounts: ").append(this.toIndentedString(this.bankIncomeAccounts)).append("\n");
        sb.append("    bankIncomeSources: ").append(this.toIndentedString(this.bankIncomeSources)).append("\n");
        sb.append("    lastUpdatedTime: ").append(this.toIndentedString(this.lastUpdatedTime)).append("\n");
        sb.append("    institutionId: ").append(this.toIndentedString(this.institutionId)).append("\n");
        sb.append("    institutionName: ").append(this.toIndentedString(this.institutionName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

