/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.CraBankIncomeEmployer;
import com.plaid.client.model.CraBankIncomeHistoricalSummary;
import com.plaid.client.model.CraPredictionInterval;
import com.plaid.client.model.CreditBankIncomeCategory;
import com.plaid.client.model.CreditBankIncomePayFrequency;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Detailed information for the income source.")
public class CraBankIncomeSource {
    public static final String SERIALIZED_NAME_ACCOUNT_ID = "account_id";
    @SerializedName(value="account_id")
    private String accountId;
    public static final String SERIALIZED_NAME_INCOME_SOURCE_ID = "income_source_id";
    @SerializedName(value="income_source_id")
    private String incomeSourceId;
    public static final String SERIALIZED_NAME_INCOME_DESCRIPTION = "income_description";
    @SerializedName(value="income_description")
    private String incomeDescription;
    public static final String SERIALIZED_NAME_INCOME_CATEGORY = "income_category";
    @SerializedName(value="income_category")
    private CreditBankIncomeCategory incomeCategory;
    public static final String SERIALIZED_NAME_START_DATE = "start_date";
    @SerializedName(value="start_date")
    private LocalDate startDate;
    public static final String SERIALIZED_NAME_END_DATE = "end_date";
    @SerializedName(value="end_date")
    private LocalDate endDate;
    public static final String SERIALIZED_NAME_PAY_FREQUENCY = "pay_frequency";
    @SerializedName(value="pay_frequency")
    private CreditBankIncomePayFrequency payFrequency;
    public static final String SERIALIZED_NAME_TOTAL_AMOUNT = "total_amount";
    @SerializedName(value="total_amount")
    private Double totalAmount;
    public static final String SERIALIZED_NAME_ISO_CURRENCY_CODE = "iso_currency_code";
    @SerializedName(value="iso_currency_code")
    private String isoCurrencyCode;
    public static final String SERIALIZED_NAME_UNOFFICIAL_CURRENCY_CODE = "unofficial_currency_code";
    @SerializedName(value="unofficial_currency_code")
    private String unofficialCurrencyCode;
    public static final String SERIALIZED_NAME_TRANSACTION_COUNT = "transaction_count";
    @SerializedName(value="transaction_count")
    private Integer transactionCount;
    public static final String SERIALIZED_NAME_NEXT_PAYMENT_DATE = "next_payment_date";
    @SerializedName(value="next_payment_date")
    private LocalDate nextPaymentDate;
    public static final String SERIALIZED_NAME_HISTORICAL_AVERAGE_MONTHLY_GROSS_INCOME = "historical_average_monthly_gross_income";
    @SerializedName(value="historical_average_monthly_gross_income")
    private Double historicalAverageMonthlyGrossIncome;
    public static final String SERIALIZED_NAME_HISTORICAL_AVERAGE_MONTHLY_INCOME = "historical_average_monthly_income";
    @SerializedName(value="historical_average_monthly_income")
    private Double historicalAverageMonthlyIncome;
    public static final String SERIALIZED_NAME_FORECASTED_AVERAGE_MONTHLY_INCOME = "forecasted_average_monthly_income";
    @SerializedName(value="forecasted_average_monthly_income")
    private Double forecastedAverageMonthlyIncome;
    public static final String SERIALIZED_NAME_FORECASTED_AVERAGE_MONTHLY_INCOME_PREDICTION_INTERVALS = "forecasted_average_monthly_income_prediction_intervals";
    @SerializedName(value="forecasted_average_monthly_income_prediction_intervals")
    private List<CraPredictionInterval> forecastedAverageMonthlyIncomePredictionIntervals = new ArrayList<CraPredictionInterval>();
    public static final String SERIALIZED_NAME_EMPLOYER = "employer";
    @SerializedName(value="employer")
    private CraBankIncomeEmployer employer;
    public static final String SERIALIZED_NAME_HISTORICAL_SUMMARY = "historical_summary";
    @SerializedName(value="historical_summary")
    private List<CraBankIncomeHistoricalSummary> historicalSummary = null;

    public CraBankIncomeSource accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The account ID with which this income source is associated.")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public CraBankIncomeSource incomeSourceId(String incomeSourceId) {
        this.incomeSourceId = incomeSourceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A unique identifier for an income source.")
    public String getIncomeSourceId() {
        return this.incomeSourceId;
    }

    public void setIncomeSourceId(String incomeSourceId) {
        this.incomeSourceId = incomeSourceId;
    }

    public CraBankIncomeSource incomeDescription(String incomeDescription) {
        this.incomeDescription = incomeDescription;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The most common name or original description for the underlying income transactions.")
    public String getIncomeDescription() {
        return this.incomeDescription;
    }

    public void setIncomeDescription(String incomeDescription) {
        this.incomeDescription = incomeDescription;
    }

    public CraBankIncomeSource incomeCategory(CreditBankIncomeCategory incomeCategory) {
        this.incomeCategory = incomeCategory;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public CreditBankIncomeCategory getIncomeCategory() {
        return this.incomeCategory;
    }

    public void setIncomeCategory(CreditBankIncomeCategory incomeCategory) {
        this.incomeCategory = incomeCategory;
    }

    public CraBankIncomeSource startDate(LocalDate startDate) {
        this.startDate = startDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Minimum of all dates within the specific income sources in the user's bank account for days requested by the client. The date will be returned in an ISO 8601 format (YYYY-MM-DD).")
    public LocalDate getStartDate() {
        return this.startDate;
    }

    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    public CraBankIncomeSource endDate(LocalDate endDate) {
        this.endDate = endDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Maximum of all dates within the specific income sources in the user\u2019s bank account for days requested by the client. The date will be returned in an ISO 8601 format (YYYY-MM-DD).")
    public LocalDate getEndDate() {
        return this.endDate;
    }

    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    public CraBankIncomeSource payFrequency(CreditBankIncomePayFrequency payFrequency) {
        this.payFrequency = payFrequency;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public CreditBankIncomePayFrequency getPayFrequency() {
        return this.payFrequency;
    }

    public void setPayFrequency(CreditBankIncomePayFrequency payFrequency) {
        this.payFrequency = payFrequency;
    }

    public CraBankIncomeSource totalAmount(Double totalAmount) {
        this.totalAmount = totalAmount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Total amount of earnings in the user\u2019s bank account for the specific income source for days requested by the client.")
    public Double getTotalAmount() {
        return this.totalAmount;
    }

    public void setTotalAmount(Double totalAmount) {
        this.totalAmount = totalAmount;
    }

    public CraBankIncomeSource isoCurrencyCode(String isoCurrencyCode) {
        this.isoCurrencyCode = isoCurrencyCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The ISO 4217 currency code of the amount or balance.")
    public String getIsoCurrencyCode() {
        return this.isoCurrencyCode;
    }

    public void setIsoCurrencyCode(String isoCurrencyCode) {
        this.isoCurrencyCode = isoCurrencyCode;
    }

    public CraBankIncomeSource unofficialCurrencyCode(String unofficialCurrencyCode) {
        this.unofficialCurrencyCode = unofficialCurrencyCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The unofficial currency code associated with the amount or balance. Always `null` if `iso_currency_code` is non-null. Unofficial currency codes are used for currencies that do not have official ISO currency codes, such as cryptocurrencies and the currencies of certain countries.")
    public String getUnofficialCurrencyCode() {
        return this.unofficialCurrencyCode;
    }

    public void setUnofficialCurrencyCode(String unofficialCurrencyCode) {
        this.unofficialCurrencyCode = unofficialCurrencyCode;
    }

    public CraBankIncomeSource transactionCount(Integer transactionCount) {
        this.transactionCount = transactionCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Number of transactions for the income source within the start and end date.")
    public Integer getTransactionCount() {
        return this.transactionCount;
    }

    public void setTransactionCount(Integer transactionCount) {
        this.transactionCount = transactionCount;
    }

    public CraBankIncomeSource nextPaymentDate(LocalDate nextPaymentDate) {
        this.nextPaymentDate = nextPaymentDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The expected date of the end user\u2019s next paycheck for the income source. The date will be returned in an ISO 8601 format (YYYY-MM-DD).")
    public LocalDate getNextPaymentDate() {
        return this.nextPaymentDate;
    }

    public void setNextPaymentDate(LocalDate nextPaymentDate) {
        this.nextPaymentDate = nextPaymentDate;
    }

    public CraBankIncomeSource historicalAverageMonthlyGrossIncome(Double historicalAverageMonthlyGrossIncome) {
        this.historicalAverageMonthlyGrossIncome = historicalAverageMonthlyGrossIncome;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An estimate of the average gross monthly income based on the historical net amount and income category for the income source(s).")
    public Double getHistoricalAverageMonthlyGrossIncome() {
        return this.historicalAverageMonthlyGrossIncome;
    }

    public void setHistoricalAverageMonthlyGrossIncome(Double historicalAverageMonthlyGrossIncome) {
        this.historicalAverageMonthlyGrossIncome = historicalAverageMonthlyGrossIncome;
    }

    public CraBankIncomeSource historicalAverageMonthlyIncome(Double historicalAverageMonthlyIncome) {
        this.historicalAverageMonthlyIncome = historicalAverageMonthlyIncome;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The average monthly net income amount estimated based on the historical data for the income source(s).")
    public Double getHistoricalAverageMonthlyIncome() {
        return this.historicalAverageMonthlyIncome;
    }

    public void setHistoricalAverageMonthlyIncome(Double historicalAverageMonthlyIncome) {
        this.historicalAverageMonthlyIncome = historicalAverageMonthlyIncome;
    }

    public CraBankIncomeSource forecastedAverageMonthlyIncome(Double forecastedAverageMonthlyIncome) {
        this.forecastedAverageMonthlyIncome = forecastedAverageMonthlyIncome;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The predicted average monthly net income amount for the income source(s).")
    public Double getForecastedAverageMonthlyIncome() {
        return this.forecastedAverageMonthlyIncome;
    }

    public void setForecastedAverageMonthlyIncome(Double forecastedAverageMonthlyIncome) {
        this.forecastedAverageMonthlyIncome = forecastedAverageMonthlyIncome;
    }

    public CraBankIncomeSource forecastedAverageMonthlyIncomePredictionIntervals(List<CraPredictionInterval> forecastedAverageMonthlyIncomePredictionIntervals) {
        this.forecastedAverageMonthlyIncomePredictionIntervals = forecastedAverageMonthlyIncomePredictionIntervals;
        return this;
    }

    public CraBankIncomeSource addForecastedAverageMonthlyIncomePredictionIntervalsItem(CraPredictionInterval forecastedAverageMonthlyIncomePredictionIntervalsItem) {
        this.forecastedAverageMonthlyIncomePredictionIntervals.add(forecastedAverageMonthlyIncomePredictionIntervalsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="The prediction interval(s) for the forecasted average monthly income.")
    public List<CraPredictionInterval> getForecastedAverageMonthlyIncomePredictionIntervals() {
        return this.forecastedAverageMonthlyIncomePredictionIntervals;
    }

    public void setForecastedAverageMonthlyIncomePredictionIntervals(List<CraPredictionInterval> forecastedAverageMonthlyIncomePredictionIntervals) {
        this.forecastedAverageMonthlyIncomePredictionIntervals = forecastedAverageMonthlyIncomePredictionIntervals;
    }

    public CraBankIncomeSource employer(CraBankIncomeEmployer employer) {
        this.employer = employer;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public CraBankIncomeEmployer getEmployer() {
        return this.employer;
    }

    public void setEmployer(CraBankIncomeEmployer employer) {
        this.employer = employer;
    }

    public CraBankIncomeSource historicalSummary(List<CraBankIncomeHistoricalSummary> historicalSummary) {
        this.historicalSummary = historicalSummary;
        return this;
    }

    public CraBankIncomeSource addHistoricalSummaryItem(CraBankIncomeHistoricalSummary historicalSummaryItem) {
        if (this.historicalSummary == null) {
            this.historicalSummary = new ArrayList<CraBankIncomeHistoricalSummary>();
        }
        this.historicalSummary.add(historicalSummaryItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public List<CraBankIncomeHistoricalSummary> getHistoricalSummary() {
        return this.historicalSummary;
    }

    public void setHistoricalSummary(List<CraBankIncomeHistoricalSummary> historicalSummary) {
        this.historicalSummary = historicalSummary;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CraBankIncomeSource craBankIncomeSource = (CraBankIncomeSource)o;
        return Objects.equals(this.accountId, craBankIncomeSource.accountId) && Objects.equals(this.incomeSourceId, craBankIncomeSource.incomeSourceId) && Objects.equals(this.incomeDescription, craBankIncomeSource.incomeDescription) && Objects.equals((Object)this.incomeCategory, (Object)craBankIncomeSource.incomeCategory) && Objects.equals(this.startDate, craBankIncomeSource.startDate) && Objects.equals(this.endDate, craBankIncomeSource.endDate) && Objects.equals((Object)this.payFrequency, (Object)craBankIncomeSource.payFrequency) && Objects.equals(this.totalAmount, craBankIncomeSource.totalAmount) && Objects.equals(this.isoCurrencyCode, craBankIncomeSource.isoCurrencyCode) && Objects.equals(this.unofficialCurrencyCode, craBankIncomeSource.unofficialCurrencyCode) && Objects.equals(this.transactionCount, craBankIncomeSource.transactionCount) && Objects.equals(this.nextPaymentDate, craBankIncomeSource.nextPaymentDate) && Objects.equals(this.historicalAverageMonthlyGrossIncome, craBankIncomeSource.historicalAverageMonthlyGrossIncome) && Objects.equals(this.historicalAverageMonthlyIncome, craBankIncomeSource.historicalAverageMonthlyIncome) && Objects.equals(this.forecastedAverageMonthlyIncome, craBankIncomeSource.forecastedAverageMonthlyIncome) && Objects.equals(this.forecastedAverageMonthlyIncomePredictionIntervals, craBankIncomeSource.forecastedAverageMonthlyIncomePredictionIntervals) && Objects.equals(this.employer, craBankIncomeSource.employer) && Objects.equals(this.historicalSummary, craBankIncomeSource.historicalSummary);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountId, this.incomeSourceId, this.incomeDescription, this.incomeCategory, this.startDate, this.endDate, this.payFrequency, this.totalAmount, this.isoCurrencyCode, this.unofficialCurrencyCode, this.transactionCount, this.nextPaymentDate, this.historicalAverageMonthlyGrossIncome, this.historicalAverageMonthlyIncome, this.forecastedAverageMonthlyIncome, this.forecastedAverageMonthlyIncomePredictionIntervals, this.employer, this.historicalSummary});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CraBankIncomeSource {\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    incomeSourceId: ").append(this.toIndentedString(this.incomeSourceId)).append("\n");
        sb.append("    incomeDescription: ").append(this.toIndentedString(this.incomeDescription)).append("\n");
        sb.append("    incomeCategory: ").append(this.toIndentedString((Object)this.incomeCategory)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    payFrequency: ").append(this.toIndentedString((Object)this.payFrequency)).append("\n");
        sb.append("    totalAmount: ").append(this.toIndentedString(this.totalAmount)).append("\n");
        sb.append("    isoCurrencyCode: ").append(this.toIndentedString(this.isoCurrencyCode)).append("\n");
        sb.append("    unofficialCurrencyCode: ").append(this.toIndentedString(this.unofficialCurrencyCode)).append("\n");
        sb.append("    transactionCount: ").append(this.toIndentedString(this.transactionCount)).append("\n");
        sb.append("    nextPaymentDate: ").append(this.toIndentedString(this.nextPaymentDate)).append("\n");
        sb.append("    historicalAverageMonthlyGrossIncome: ").append(this.toIndentedString(this.historicalAverageMonthlyGrossIncome)).append("\n");
        sb.append("    historicalAverageMonthlyIncome: ").append(this.toIndentedString(this.historicalAverageMonthlyIncome)).append("\n");
        sb.append("    forecastedAverageMonthlyIncome: ").append(this.toIndentedString(this.forecastedAverageMonthlyIncome)).append("\n");
        sb.append("    forecastedAverageMonthlyIncomePredictionIntervals: ").append(this.toIndentedString(this.forecastedAverageMonthlyIncomePredictionIntervals)).append("\n");
        sb.append("    employer: ").append(this.toIndentedString(this.employer)).append("\n");
        sb.append("    historicalSummary: ").append(this.toIndentedString(this.historicalSummary)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

