/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.CraBankIncomeHistoricalSummary;
import com.plaid.client.model.CreditAmountWithCurrency;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Summary for bank income across all income sources and items (max history of 730 days).")
public class CraBankIncomeSummary {
    public static final String SERIALIZED_NAME_TOTAL_AMOUNTS = "total_amounts";
    @SerializedName(value="total_amounts")
    private List<CreditAmountWithCurrency> totalAmounts = null;
    public static final String SERIALIZED_NAME_START_DATE = "start_date";
    @SerializedName(value="start_date")
    private LocalDate startDate;
    public static final String SERIALIZED_NAME_END_DATE = "end_date";
    @SerializedName(value="end_date")
    private LocalDate endDate;
    public static final String SERIALIZED_NAME_INCOME_SOURCES_COUNT = "income_sources_count";
    @SerializedName(value="income_sources_count")
    private Integer incomeSourcesCount;
    public static final String SERIALIZED_NAME_INCOME_CATEGORIES_COUNT = "income_categories_count";
    @SerializedName(value="income_categories_count")
    private Integer incomeCategoriesCount;
    public static final String SERIALIZED_NAME_INCOME_TRANSACTIONS_COUNT = "income_transactions_count";
    @SerializedName(value="income_transactions_count")
    private Integer incomeTransactionsCount;
    public static final String SERIALIZED_NAME_HISTORICAL_AVERAGE_MONTHLY_GROSS_INCOME = "historical_average_monthly_gross_income";
    @SerializedName(value="historical_average_monthly_gross_income")
    private List<CreditAmountWithCurrency> historicalAverageMonthlyGrossIncome = null;
    public static final String SERIALIZED_NAME_HISTORICAL_AVERAGE_MONTHLY_INCOME = "historical_average_monthly_income";
    @SerializedName(value="historical_average_monthly_income")
    private List<CreditAmountWithCurrency> historicalAverageMonthlyIncome = null;
    public static final String SERIALIZED_NAME_FORECASTED_AVERAGE_MONTHLY_INCOME = "forecasted_average_monthly_income";
    @SerializedName(value="forecasted_average_monthly_income")
    private List<CreditAmountWithCurrency> forecastedAverageMonthlyIncome = null;
    public static final String SERIALIZED_NAME_HISTORICAL_ANNUAL_GROSS_INCOME = "historical_annual_gross_income";
    @SerializedName(value="historical_annual_gross_income")
    private List<CreditAmountWithCurrency> historicalAnnualGrossIncome = null;
    public static final String SERIALIZED_NAME_HISTORICAL_ANNUAL_INCOME = "historical_annual_income";
    @SerializedName(value="historical_annual_income")
    private List<CreditAmountWithCurrency> historicalAnnualIncome = null;
    public static final String SERIALIZED_NAME_FORECASTED_ANNUAL_INCOME = "forecasted_annual_income";
    @SerializedName(value="forecasted_annual_income")
    private List<CreditAmountWithCurrency> forecastedAnnualIncome = null;
    public static final String SERIALIZED_NAME_HISTORICAL_SUMMARY = "historical_summary";
    @SerializedName(value="historical_summary")
    private List<CraBankIncomeHistoricalSummary> historicalSummary = null;

    public CraBankIncomeSummary totalAmounts(List<CreditAmountWithCurrency> totalAmounts) {
        this.totalAmounts = totalAmounts;
        return this;
    }

    public CraBankIncomeSummary addTotalAmountsItem(CreditAmountWithCurrency totalAmountsItem) {
        if (this.totalAmounts == null) {
            this.totalAmounts = new ArrayList<CreditAmountWithCurrency>();
        }
        this.totalAmounts.add(totalAmountsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Total amount of earnings across all the income sources in the end user's Items for the days requested by the client. This can contain multiple amounts, with each amount denominated in one unique currency.")
    public List<CreditAmountWithCurrency> getTotalAmounts() {
        return this.totalAmounts;
    }

    public void setTotalAmounts(List<CreditAmountWithCurrency> totalAmounts) {
        this.totalAmounts = totalAmounts;
    }

    public CraBankIncomeSummary startDate(LocalDate startDate) {
        this.startDate = startDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The earliest date within the days requested in which all income sources identified by Plaid appear in a user's account. The date will be returned in an ISO 8601 format (YYYY-MM-DD).")
    public LocalDate getStartDate() {
        return this.startDate;
    }

    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    public CraBankIncomeSummary endDate(LocalDate endDate) {
        this.endDate = endDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The latest date in which all income sources identified by Plaid appear in the user's account. The date will be returned in an ISO 8601 format (YYYY-MM-DD).")
    public LocalDate getEndDate() {
        return this.endDate;
    }

    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    public CraBankIncomeSummary incomeSourcesCount(Integer incomeSourcesCount) {
        this.incomeSourcesCount = incomeSourcesCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Number of income sources per end user.")
    public Integer getIncomeSourcesCount() {
        return this.incomeSourcesCount;
    }

    public void setIncomeSourcesCount(Integer incomeSourcesCount) {
        this.incomeSourcesCount = incomeSourcesCount;
    }

    public CraBankIncomeSummary incomeCategoriesCount(Integer incomeCategoriesCount) {
        this.incomeCategoriesCount = incomeCategoriesCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Number of income categories per end user.")
    public Integer getIncomeCategoriesCount() {
        return this.incomeCategoriesCount;
    }

    public void setIncomeCategoriesCount(Integer incomeCategoriesCount) {
        this.incomeCategoriesCount = incomeCategoriesCount;
    }

    public CraBankIncomeSummary incomeTransactionsCount(Integer incomeTransactionsCount) {
        this.incomeTransactionsCount = incomeTransactionsCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Number of income transactions per end user.")
    public Integer getIncomeTransactionsCount() {
        return this.incomeTransactionsCount;
    }

    public void setIncomeTransactionsCount(Integer incomeTransactionsCount) {
        this.incomeTransactionsCount = incomeTransactionsCount;
    }

    public CraBankIncomeSummary historicalAverageMonthlyGrossIncome(List<CreditAmountWithCurrency> historicalAverageMonthlyGrossIncome) {
        this.historicalAverageMonthlyGrossIncome = historicalAverageMonthlyGrossIncome;
        return this;
    }

    public CraBankIncomeSummary addHistoricalAverageMonthlyGrossIncomeItem(CreditAmountWithCurrency historicalAverageMonthlyGrossIncomeItem) {
        if (this.historicalAverageMonthlyGrossIncome == null) {
            this.historicalAverageMonthlyGrossIncome = new ArrayList<CreditAmountWithCurrency>();
        }
        this.historicalAverageMonthlyGrossIncome.add(historicalAverageMonthlyGrossIncomeItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An estimate of the average gross monthly income based on the historical net amount and income category for the income source(s).")
    public List<CreditAmountWithCurrency> getHistoricalAverageMonthlyGrossIncome() {
        return this.historicalAverageMonthlyGrossIncome;
    }

    public void setHistoricalAverageMonthlyGrossIncome(List<CreditAmountWithCurrency> historicalAverageMonthlyGrossIncome) {
        this.historicalAverageMonthlyGrossIncome = historicalAverageMonthlyGrossIncome;
    }

    public CraBankIncomeSummary historicalAverageMonthlyIncome(List<CreditAmountWithCurrency> historicalAverageMonthlyIncome) {
        this.historicalAverageMonthlyIncome = historicalAverageMonthlyIncome;
        return this;
    }

    public CraBankIncomeSummary addHistoricalAverageMonthlyIncomeItem(CreditAmountWithCurrency historicalAverageMonthlyIncomeItem) {
        if (this.historicalAverageMonthlyIncome == null) {
            this.historicalAverageMonthlyIncome = new ArrayList<CreditAmountWithCurrency>();
        }
        this.historicalAverageMonthlyIncome.add(historicalAverageMonthlyIncomeItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The average monthly income amount estimated based on the historical data for the income source(s).")
    public List<CreditAmountWithCurrency> getHistoricalAverageMonthlyIncome() {
        return this.historicalAverageMonthlyIncome;
    }

    public void setHistoricalAverageMonthlyIncome(List<CreditAmountWithCurrency> historicalAverageMonthlyIncome) {
        this.historicalAverageMonthlyIncome = historicalAverageMonthlyIncome;
    }

    public CraBankIncomeSummary forecastedAverageMonthlyIncome(List<CreditAmountWithCurrency> forecastedAverageMonthlyIncome) {
        this.forecastedAverageMonthlyIncome = forecastedAverageMonthlyIncome;
        return this;
    }

    public CraBankIncomeSummary addForecastedAverageMonthlyIncomeItem(CreditAmountWithCurrency forecastedAverageMonthlyIncomeItem) {
        if (this.forecastedAverageMonthlyIncome == null) {
            this.forecastedAverageMonthlyIncome = new ArrayList<CreditAmountWithCurrency>();
        }
        this.forecastedAverageMonthlyIncome.add(forecastedAverageMonthlyIncomeItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The predicted average monthly income amount for the income source(s).")
    public List<CreditAmountWithCurrency> getForecastedAverageMonthlyIncome() {
        return this.forecastedAverageMonthlyIncome;
    }

    public void setForecastedAverageMonthlyIncome(List<CreditAmountWithCurrency> forecastedAverageMonthlyIncome) {
        this.forecastedAverageMonthlyIncome = forecastedAverageMonthlyIncome;
    }

    public CraBankIncomeSummary historicalAnnualGrossIncome(List<CreditAmountWithCurrency> historicalAnnualGrossIncome) {
        this.historicalAnnualGrossIncome = historicalAnnualGrossIncome;
        return this;
    }

    public CraBankIncomeSummary addHistoricalAnnualGrossIncomeItem(CreditAmountWithCurrency historicalAnnualGrossIncomeItem) {
        if (this.historicalAnnualGrossIncome == null) {
            this.historicalAnnualGrossIncome = new ArrayList<CreditAmountWithCurrency>();
        }
        this.historicalAnnualGrossIncome.add(historicalAnnualGrossIncomeItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An estimate of the annual gross income based on the historical net amount and income category for the income source(s).")
    public List<CreditAmountWithCurrency> getHistoricalAnnualGrossIncome() {
        return this.historicalAnnualGrossIncome;
    }

    public void setHistoricalAnnualGrossIncome(List<CreditAmountWithCurrency> historicalAnnualGrossIncome) {
        this.historicalAnnualGrossIncome = historicalAnnualGrossIncome;
    }

    public CraBankIncomeSummary historicalAnnualIncome(List<CreditAmountWithCurrency> historicalAnnualIncome) {
        this.historicalAnnualIncome = historicalAnnualIncome;
        return this;
    }

    public CraBankIncomeSummary addHistoricalAnnualIncomeItem(CreditAmountWithCurrency historicalAnnualIncomeItem) {
        if (this.historicalAnnualIncome == null) {
            this.historicalAnnualIncome = new ArrayList<CreditAmountWithCurrency>();
        }
        this.historicalAnnualIncome.add(historicalAnnualIncomeItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The annual income amount estimated based on the historical data for the income source(s).")
    public List<CreditAmountWithCurrency> getHistoricalAnnualIncome() {
        return this.historicalAnnualIncome;
    }

    public void setHistoricalAnnualIncome(List<CreditAmountWithCurrency> historicalAnnualIncome) {
        this.historicalAnnualIncome = historicalAnnualIncome;
    }

    public CraBankIncomeSummary forecastedAnnualIncome(List<CreditAmountWithCurrency> forecastedAnnualIncome) {
        this.forecastedAnnualIncome = forecastedAnnualIncome;
        return this;
    }

    public CraBankIncomeSummary addForecastedAnnualIncomeItem(CreditAmountWithCurrency forecastedAnnualIncomeItem) {
        if (this.forecastedAnnualIncome == null) {
            this.forecastedAnnualIncome = new ArrayList<CreditAmountWithCurrency>();
        }
        this.forecastedAnnualIncome.add(forecastedAnnualIncomeItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The predicted average annual income amount for the income source(s).")
    public List<CreditAmountWithCurrency> getForecastedAnnualIncome() {
        return this.forecastedAnnualIncome;
    }

    public void setForecastedAnnualIncome(List<CreditAmountWithCurrency> forecastedAnnualIncome) {
        this.forecastedAnnualIncome = forecastedAnnualIncome;
    }

    public CraBankIncomeSummary historicalSummary(List<CraBankIncomeHistoricalSummary> historicalSummary) {
        this.historicalSummary = historicalSummary;
        return this;
    }

    public CraBankIncomeSummary addHistoricalSummaryItem(CraBankIncomeHistoricalSummary historicalSummaryItem) {
        if (this.historicalSummary == null) {
            this.historicalSummary = new ArrayList<CraBankIncomeHistoricalSummary>();
        }
        this.historicalSummary.add(historicalSummaryItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public List<CraBankIncomeHistoricalSummary> getHistoricalSummary() {
        return this.historicalSummary;
    }

    public void setHistoricalSummary(List<CraBankIncomeHistoricalSummary> historicalSummary) {
        this.historicalSummary = historicalSummary;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CraBankIncomeSummary craBankIncomeSummary = (CraBankIncomeSummary)o;
        return Objects.equals(this.totalAmounts, craBankIncomeSummary.totalAmounts) && Objects.equals(this.startDate, craBankIncomeSummary.startDate) && Objects.equals(this.endDate, craBankIncomeSummary.endDate) && Objects.equals(this.incomeSourcesCount, craBankIncomeSummary.incomeSourcesCount) && Objects.equals(this.incomeCategoriesCount, craBankIncomeSummary.incomeCategoriesCount) && Objects.equals(this.incomeTransactionsCount, craBankIncomeSummary.incomeTransactionsCount) && Objects.equals(this.historicalAverageMonthlyGrossIncome, craBankIncomeSummary.historicalAverageMonthlyGrossIncome) && Objects.equals(this.historicalAverageMonthlyIncome, craBankIncomeSummary.historicalAverageMonthlyIncome) && Objects.equals(this.forecastedAverageMonthlyIncome, craBankIncomeSummary.forecastedAverageMonthlyIncome) && Objects.equals(this.historicalAnnualGrossIncome, craBankIncomeSummary.historicalAnnualGrossIncome) && Objects.equals(this.historicalAnnualIncome, craBankIncomeSummary.historicalAnnualIncome) && Objects.equals(this.forecastedAnnualIncome, craBankIncomeSummary.forecastedAnnualIncome) && Objects.equals(this.historicalSummary, craBankIncomeSummary.historicalSummary);
    }

    public int hashCode() {
        return Objects.hash(this.totalAmounts, this.startDate, this.endDate, this.incomeSourcesCount, this.incomeCategoriesCount, this.incomeTransactionsCount, this.historicalAverageMonthlyGrossIncome, this.historicalAverageMonthlyIncome, this.forecastedAverageMonthlyIncome, this.historicalAnnualGrossIncome, this.historicalAnnualIncome, this.forecastedAnnualIncome, this.historicalSummary);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CraBankIncomeSummary {\n");
        sb.append("    totalAmounts: ").append(this.toIndentedString(this.totalAmounts)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    incomeSourcesCount: ").append(this.toIndentedString(this.incomeSourcesCount)).append("\n");
        sb.append("    incomeCategoriesCount: ").append(this.toIndentedString(this.incomeCategoriesCount)).append("\n");
        sb.append("    incomeTransactionsCount: ").append(this.toIndentedString(this.incomeTransactionsCount)).append("\n");
        sb.append("    historicalAverageMonthlyGrossIncome: ").append(this.toIndentedString(this.historicalAverageMonthlyGrossIncome)).append("\n");
        sb.append("    historicalAverageMonthlyIncome: ").append(this.toIndentedString(this.historicalAverageMonthlyIncome)).append("\n");
        sb.append("    forecastedAverageMonthlyIncome: ").append(this.toIndentedString(this.forecastedAverageMonthlyIncome)).append("\n");
        sb.append("    historicalAnnualGrossIncome: ").append(this.toIndentedString(this.historicalAnnualGrossIncome)).append("\n");
        sb.append("    historicalAnnualIncome: ").append(this.toIndentedString(this.historicalAnnualIncome)).append("\n");
        sb.append("    forecastedAnnualIncome: ").append(this.toIndentedString(this.forecastedAnnualIncome)).append("\n");
        sb.append("    historicalSummary: ").append(this.toIndentedString(this.historicalSummary)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

