/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.CraBankIncomeBonusType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The transactions data for the end user's income source(s).")
public class CraBankIncomeTransaction {
    public static final String SERIALIZED_NAME_TRANSACTION_ID = "transaction_id";
    @SerializedName(value="transaction_id")
    private String transactionId;
    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(value="amount")
    private Double amount;
    public static final String SERIALIZED_NAME_DATE = "date";
    @SerializedName(value="date")
    private LocalDate date;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_ORIGINAL_DESCRIPTION = "original_description";
    @SerializedName(value="original_description")
    private String originalDescription;
    public static final String SERIALIZED_NAME_PENDING = "pending";
    @SerializedName(value="pending")
    private Boolean pending;
    public static final String SERIALIZED_NAME_CHECK_NUMBER = "check_number";
    @SerializedName(value="check_number")
    private String checkNumber;
    public static final String SERIALIZED_NAME_ISO_CURRENCY_CODE = "iso_currency_code";
    @SerializedName(value="iso_currency_code")
    private String isoCurrencyCode;
    public static final String SERIALIZED_NAME_UNOFFICIAL_CURRENCY_CODE = "unofficial_currency_code";
    @SerializedName(value="unofficial_currency_code")
    private String unofficialCurrencyCode;
    public static final String SERIALIZED_NAME_BONUS_TYPE = "bonus_type";
    @SerializedName(value="bonus_type")
    private CraBankIncomeBonusType bonusType;

    public CraBankIncomeTransaction transactionId(String transactionId) {
        this.transactionId = transactionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The unique ID of the transaction. Like all Plaid identifiers, the `transaction_id` is case sensitive.")
    public String getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public CraBankIncomeTransaction amount(Double amount) {
        this.amount = amount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The settled value of the transaction, denominated in the transaction's currency as stated in `iso_currency_code` or `unofficial_currency_code`. Positive values when money moves out of the account; negative values when money moves in. For example, credit card purchases are positive; credit card payment, direct deposits, and refunds are negative.")
    public Double getAmount() {
        return this.amount;
    }

    public void setAmount(Double amount) {
        this.amount = amount;
    }

    public CraBankIncomeTransaction date(LocalDate date) {
        this.date = date;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="For pending transactions, the date that the transaction occurred; for posted transactions, the date that the transaction posted. Both dates are returned in an ISO 8601 format (YYYY-MM-DD).")
    public LocalDate getDate() {
        return this.date;
    }

    public void setDate(LocalDate date) {
        this.date = date;
    }

    public CraBankIncomeTransaction name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The merchant name or transaction description.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CraBankIncomeTransaction originalDescription(String originalDescription) {
        this.originalDescription = originalDescription;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The string returned by the financial institution to describe the transaction.")
    public String getOriginalDescription() {
        return this.originalDescription;
    }

    public void setOriginalDescription(String originalDescription) {
        this.originalDescription = originalDescription;
    }

    public CraBankIncomeTransaction pending(Boolean pending) {
        this.pending = pending;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="When true, identifies the transaction as pending or unsettled. Pending transaction details (name, type, amount, category ID) may change before they are settled.")
    public Boolean getPending() {
        return this.pending;
    }

    public void setPending(Boolean pending) {
        this.pending = pending;
    }

    public CraBankIncomeTransaction checkNumber(String checkNumber) {
        this.checkNumber = checkNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The check number of the transaction. This field is only populated for check transactions.")
    public String getCheckNumber() {
        return this.checkNumber;
    }

    public void setCheckNumber(String checkNumber) {
        this.checkNumber = checkNumber;
    }

    public CraBankIncomeTransaction isoCurrencyCode(String isoCurrencyCode) {
        this.isoCurrencyCode = isoCurrencyCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The ISO 4217 currency code of the amount or balance.")
    public String getIsoCurrencyCode() {
        return this.isoCurrencyCode;
    }

    public void setIsoCurrencyCode(String isoCurrencyCode) {
        this.isoCurrencyCode = isoCurrencyCode;
    }

    public CraBankIncomeTransaction unofficialCurrencyCode(String unofficialCurrencyCode) {
        this.unofficialCurrencyCode = unofficialCurrencyCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The unofficial currency code associated with the amount or balance. Always `null` if `iso_currency_code` is non-null. Unofficial currency codes are used for currencies that do not have official ISO currency codes, such as cryptocurrencies and the currencies of certain countries.")
    public String getUnofficialCurrencyCode() {
        return this.unofficialCurrencyCode;
    }

    public void setUnofficialCurrencyCode(String unofficialCurrencyCode) {
        this.unofficialCurrencyCode = unofficialCurrencyCode;
    }

    public CraBankIncomeTransaction bonusType(CraBankIncomeBonusType bonusType) {
        this.bonusType = bonusType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public CraBankIncomeBonusType getBonusType() {
        return this.bonusType;
    }

    public void setBonusType(CraBankIncomeBonusType bonusType) {
        this.bonusType = bonusType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CraBankIncomeTransaction craBankIncomeTransaction = (CraBankIncomeTransaction)o;
        return Objects.equals(this.transactionId, craBankIncomeTransaction.transactionId) && Objects.equals(this.amount, craBankIncomeTransaction.amount) && Objects.equals(this.date, craBankIncomeTransaction.date) && Objects.equals(this.name, craBankIncomeTransaction.name) && Objects.equals(this.originalDescription, craBankIncomeTransaction.originalDescription) && Objects.equals(this.pending, craBankIncomeTransaction.pending) && Objects.equals(this.checkNumber, craBankIncomeTransaction.checkNumber) && Objects.equals(this.isoCurrencyCode, craBankIncomeTransaction.isoCurrencyCode) && Objects.equals(this.unofficialCurrencyCode, craBankIncomeTransaction.unofficialCurrencyCode) && Objects.equals((Object)this.bonusType, (Object)craBankIncomeTransaction.bonusType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.transactionId, this.amount, this.date, this.name, this.originalDescription, this.pending, this.checkNumber, this.isoCurrencyCode, this.unofficialCurrencyCode, this.bonusType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CraBankIncomeTransaction {\n");
        sb.append("    transactionId: ").append(this.toIndentedString(this.transactionId)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    date: ").append(this.toIndentedString(this.date)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    originalDescription: ").append(this.toIndentedString(this.originalDescription)).append("\n");
        sb.append("    pending: ").append(this.toIndentedString(this.pending)).append("\n");
        sb.append("    checkNumber: ").append(this.toIndentedString(this.checkNumber)).append("\n");
        sb.append("    isoCurrencyCode: ").append(this.toIndentedString(this.isoCurrencyCode)).append("\n");
        sb.append("    unofficialCurrencyCode: ").append(this.toIndentedString(this.unofficialCurrencyCode)).append("\n");
        sb.append("    bonusType: ").append(this.toIndentedString((Object)this.bonusType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

