/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="BaseReportGetRequest defines the request schema for `/cra/check_report/base_report/get`")
public class CraCheckReportBaseReportGetRequest {
    public static final String SERIALIZED_NAME_CLIENT_ID = "client_id";
    @SerializedName(value="client_id")
    private String clientId;
    public static final String SERIALIZED_NAME_SECRET = "secret";
    @SerializedName(value="secret")
    private String secret;
    public static final String SERIALIZED_NAME_USER_TOKEN = "user_token";
    @SerializedName(value="user_token")
    private String userToken;
    public static final String SERIALIZED_NAME_ITEM_IDS = "item_ids";
    @SerializedName(value="item_ids")
    private List<String> itemIds = null;

    public CraCheckReportBaseReportGetRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public CraCheckReportBaseReportGetRequest secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public CraCheckReportBaseReportGetRequest userToken(String userToken) {
        this.userToken = userToken;
        return this;
    }

    @ApiModelProperty(required=true, value="The user token associated with the User data is being requested for.")
    public String getUserToken() {
        return this.userToken;
    }

    public void setUserToken(String userToken) {
        this.userToken = userToken;
    }

    public CraCheckReportBaseReportGetRequest itemIds(List<String> itemIds) {
        this.itemIds = itemIds;
        return this;
    }

    public CraCheckReportBaseReportGetRequest addItemIdsItem(String itemIdsItem) {
        if (this.itemIds == null) {
            this.itemIds = new ArrayList<String>();
        }
        this.itemIds.add(itemIdsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The item IDs to include in the Base Report. If not provided, all items associated with the user will be included.")
    public List<String> getItemIds() {
        return this.itemIds;
    }

    public void setItemIds(List<String> itemIds) {
        this.itemIds = itemIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CraCheckReportBaseReportGetRequest craCheckReportBaseReportGetRequest = (CraCheckReportBaseReportGetRequest)o;
        return Objects.equals(this.clientId, craCheckReportBaseReportGetRequest.clientId) && Objects.equals(this.secret, craCheckReportBaseReportGetRequest.secret) && Objects.equals(this.userToken, craCheckReportBaseReportGetRequest.userToken) && Objects.equals(this.itemIds, craCheckReportBaseReportGetRequest.itemIds);
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.secret, this.userToken, this.itemIds);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CraCheckReportBaseReportGetRequest {\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    userToken: ").append(this.toIndentedString(this.userToken)).append("\n");
        sb.append("    itemIds: ").append(this.toIndentedString(this.itemIds)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

