/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.ConsumerReportPermissiblePurpose;
import com.plaid.client.model.CraCheckReportProduct;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="CraCheckReportCreateRequest defines the request schema for `/cra/check_report/create`.")
public class CraCheckReportCreateRequest {
    public static final String SERIALIZED_NAME_CLIENT_ID = "client_id";
    @SerializedName(value="client_id")
    private String clientId;
    public static final String SERIALIZED_NAME_SECRET = "secret";
    @SerializedName(value="secret")
    private String secret;
    public static final String SERIALIZED_NAME_USER_TOKEN = "user_token";
    @SerializedName(value="user_token")
    private String userToken;
    public static final String SERIALIZED_NAME_WEBHOOK = "webhook";
    @SerializedName(value="webhook")
    private String webhook;
    public static final String SERIALIZED_NAME_DAYS_REQUESTED = "days_requested";
    @SerializedName(value="days_requested")
    private Integer daysRequested;
    public static final String SERIALIZED_NAME_PRODUCTS = "products";
    @SerializedName(value="products")
    private List<CraCheckReportProduct> products = null;
    public static final String SERIALIZED_NAME_CONSUMER_REPORT_PERMISSIBLE_PURPOSE = "consumer_report_permissible_purpose";
    @SerializedName(value="consumer_report_permissible_purpose")
    private ConsumerReportPermissiblePurpose consumerReportPermissiblePurpose;

    public CraCheckReportCreateRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public CraCheckReportCreateRequest secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public CraCheckReportCreateRequest userToken(String userToken) {
        this.userToken = userToken;
        return this;
    }

    @ApiModelProperty(required=true, value="The user token associated with the User data is being requested for.")
    public String getUserToken() {
        return this.userToken;
    }

    public void setUserToken(String userToken) {
        this.userToken = userToken;
    }

    public CraCheckReportCreateRequest webhook(String webhook) {
        this.webhook = webhook;
        return this;
    }

    @ApiModelProperty(required=true, value="The destination URL to which webhooks will be sent ")
    public String getWebhook() {
        return this.webhook;
    }

    public void setWebhook(String webhook) {
        this.webhook = webhook;
    }

    public CraCheckReportCreateRequest daysRequested(Integer daysRequested) {
        this.daysRequested = daysRequested;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of days of data to request for the report")
    public Integer getDaysRequested() {
        return this.daysRequested;
    }

    public void setDaysRequested(Integer daysRequested) {
        this.daysRequested = daysRequested;
    }

    public CraCheckReportCreateRequest products(List<CraCheckReportProduct> products) {
        this.products = products;
        return this;
    }

    public CraCheckReportCreateRequest addProductsItem(CraCheckReportProduct productsItem) {
        if (this.products == null) {
            this.products = new ArrayList<CraCheckReportProduct>();
        }
        this.products.add(productsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Products that will be retrieved in this report. This configuration will determine what data types to fetch from the user's financial institution. If omitted, the data types needed to support all products will be fetched.")
    public List<CraCheckReportProduct> getProducts() {
        return this.products;
    }

    public void setProducts(List<CraCheckReportProduct> products) {
        this.products = products;
    }

    public CraCheckReportCreateRequest consumerReportPermissiblePurpose(ConsumerReportPermissiblePurpose consumerReportPermissiblePurpose) {
        this.consumerReportPermissiblePurpose = consumerReportPermissiblePurpose;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public ConsumerReportPermissiblePurpose getConsumerReportPermissiblePurpose() {
        return this.consumerReportPermissiblePurpose;
    }

    public void setConsumerReportPermissiblePurpose(ConsumerReportPermissiblePurpose consumerReportPermissiblePurpose) {
        this.consumerReportPermissiblePurpose = consumerReportPermissiblePurpose;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CraCheckReportCreateRequest craCheckReportCreateRequest = (CraCheckReportCreateRequest)o;
        return Objects.equals(this.clientId, craCheckReportCreateRequest.clientId) && Objects.equals(this.secret, craCheckReportCreateRequest.secret) && Objects.equals(this.userToken, craCheckReportCreateRequest.userToken) && Objects.equals(this.webhook, craCheckReportCreateRequest.webhook) && Objects.equals(this.daysRequested, craCheckReportCreateRequest.daysRequested) && Objects.equals(this.products, craCheckReportCreateRequest.products) && Objects.equals((Object)this.consumerReportPermissiblePurpose, (Object)craCheckReportCreateRequest.consumerReportPermissiblePurpose);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.clientId, this.secret, this.userToken, this.webhook, this.daysRequested, this.products, this.consumerReportPermissiblePurpose});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CraCheckReportCreateRequest {\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    userToken: ").append(this.toIndentedString(this.userToken)).append("\n");
        sb.append("    webhook: ").append(this.toIndentedString(this.webhook)).append("\n");
        sb.append("    daysRequested: ").append(this.toIndentedString(this.daysRequested)).append("\n");
        sb.append("    products: ").append(this.toIndentedString(this.products)).append("\n");
        sb.append("    consumerReportPermissiblePurpose: ").append(this.toIndentedString((Object)this.consumerReportPermissiblePurpose)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

