/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.WebhookEnvironmentValues;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Fired when products for the Check Report are ready to be retrieved")
public class CraCheckReportReadyWebhook {
    public static final String SERIALIZED_NAME_WEBHOOK_TYPE = "webhook_type";
    @SerializedName(value="webhook_type")
    private String webhookType;
    public static final String SERIALIZED_NAME_WEBHOOK_CODE = "webhook_code";
    @SerializedName(value="webhook_code")
    private String webhookCode;
    public static final String SERIALIZED_NAME_USER_ID = "user_id";
    @SerializedName(value="user_id")
    private String userId;
    public static final String SERIALIZED_NAME_ITEM_IDS = "item_ids";
    @SerializedName(value="item_ids")
    private List<String> itemIds = null;
    public static final String SERIALIZED_NAME_ENVIRONMENT = "environment";
    @SerializedName(value="environment")
    private WebhookEnvironmentValues environment;

    public CraCheckReportReadyWebhook webhookType(String webhookType) {
        this.webhookType = webhookType;
        return this;
    }

    @ApiModelProperty(required=true, value="`CHECK_REPORT`")
    public String getWebhookType() {
        return this.webhookType;
    }

    public void setWebhookType(String webhookType) {
        this.webhookType = webhookType;
    }

    public CraCheckReportReadyWebhook webhookCode(String webhookCode) {
        this.webhookCode = webhookCode;
        return this;
    }

    @ApiModelProperty(required=true, value="`CHECK_REPORT_READY`")
    public String getWebhookCode() {
        return this.webhookCode;
    }

    public void setWebhookCode(String webhookCode) {
        this.webhookCode = webhookCode;
    }

    public CraCheckReportReadyWebhook userId(String userId) {
        this.userId = userId;
        return this;
    }

    @ApiModelProperty(required=true, value="The `user_id` corresponding to the user the webhook has fired for.")
    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public CraCheckReportReadyWebhook itemIds(List<String> itemIds) {
        this.itemIds = itemIds;
        return this;
    }

    public CraCheckReportReadyWebhook addItemIdsItem(String itemIdsItem) {
        if (this.itemIds == null) {
            this.itemIds = new ArrayList<String>();
        }
        this.itemIds.add(itemIdsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A list of `item_ids` that is included in the Check Report.")
    public List<String> getItemIds() {
        return this.itemIds;
    }

    public void setItemIds(List<String> itemIds) {
        this.itemIds = itemIds;
    }

    public CraCheckReportReadyWebhook environment(WebhookEnvironmentValues environment) {
        this.environment = environment;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public WebhookEnvironmentValues getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(WebhookEnvironmentValues environment) {
        this.environment = environment;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CraCheckReportReadyWebhook craCheckReportReadyWebhook = (CraCheckReportReadyWebhook)o;
        return Objects.equals(this.webhookType, craCheckReportReadyWebhook.webhookType) && Objects.equals(this.webhookCode, craCheckReportReadyWebhook.webhookCode) && Objects.equals(this.userId, craCheckReportReadyWebhook.userId) && Objects.equals(this.itemIds, craCheckReportReadyWebhook.itemIds) && Objects.equals((Object)this.environment, (Object)craCheckReportReadyWebhook.environment);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.webhookType, this.webhookCode, this.userId, this.itemIds, this.environment});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CraCheckReportReadyWebhook {\n");
        sb.append("    webhookType: ").append(this.toIndentedString(this.webhookType)).append("\n");
        sb.append("    webhookCode: ").append(this.toIndentedString(this.webhookCode)).append("\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("    itemIds: ").append(this.toIndentedString(this.itemIds)).append("\n");
        sb.append("    environment: ").append(this.toIndentedString((Object)this.environment)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

