/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.CraLoanApplicationDecision;
import com.plaid.client.model.CraLoanType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Contains loan application data.")
public class CraLoanApplication {
    public static final String SERIALIZED_NAME_USER_TOKEN = "user_token";
    @SerializedName(value="user_token")
    private String userToken;
    public static final String SERIALIZED_NAME_APPLICATION_ID = "application_id";
    @SerializedName(value="application_id")
    private String applicationId;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private CraLoanType type;
    public static final String SERIALIZED_NAME_DECISION = "decision";
    @SerializedName(value="decision")
    private CraLoanApplicationDecision decision;
    public static final String SERIALIZED_NAME_APPLICATION_DATE = "application_date";
    @SerializedName(value="application_date")
    private LocalDate applicationDate;
    public static final String SERIALIZED_NAME_DECISION_DATE = "decision_date";
    @SerializedName(value="decision_date")
    private LocalDate decisionDate;

    public CraLoanApplication userToken(String userToken) {
        this.userToken = userToken;
        return this;
    }

    @ApiModelProperty(required=true, value="The user token for the user associated with the loan.")
    public String getUserToken() {
        return this.userToken;
    }

    public void setUserToken(String userToken) {
        this.userToken = userToken;
    }

    public CraLoanApplication applicationId(String applicationId) {
        this.applicationId = applicationId;
        return this;
    }

    @ApiModelProperty(required=true, value="A unique identifier for the loan application.  Personally identifiable information, such as an email address or phone number, should not be used in the `application_id`.")
    public String getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public CraLoanApplication type(CraLoanType type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public CraLoanType getType() {
        return this.type;
    }

    public void setType(CraLoanType type) {
        this.type = type;
    }

    public CraLoanApplication decision(CraLoanApplicationDecision decision) {
        this.decision = decision;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public CraLoanApplicationDecision getDecision() {
        return this.decision;
    }

    public void setDecision(CraLoanApplicationDecision decision) {
        this.decision = decision;
    }

    public CraLoanApplication applicationDate(LocalDate applicationDate) {
        this.applicationDate = applicationDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The date the user applied for the loan. The date should be in ISO 8601 format (YYYY-MM-DD).")
    public LocalDate getApplicationDate() {
        return this.applicationDate;
    }

    public void setApplicationDate(LocalDate applicationDate) {
        this.applicationDate = applicationDate;
    }

    public CraLoanApplication decisionDate(LocalDate decisionDate) {
        this.decisionDate = decisionDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The date when the loan application's decision was made. The date should be in ISO 8601 format (YYYY-MM-DD).")
    public LocalDate getDecisionDate() {
        return this.decisionDate;
    }

    public void setDecisionDate(LocalDate decisionDate) {
        this.decisionDate = decisionDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CraLoanApplication craLoanApplication = (CraLoanApplication)o;
        return Objects.equals(this.userToken, craLoanApplication.userToken) && Objects.equals(this.applicationId, craLoanApplication.applicationId) && Objects.equals((Object)this.type, (Object)craLoanApplication.type) && Objects.equals((Object)this.decision, (Object)craLoanApplication.decision) && Objects.equals(this.applicationDate, craLoanApplication.applicationDate) && Objects.equals(this.decisionDate, craLoanApplication.decisionDate);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.userToken, this.applicationId, this.type, this.decision, this.applicationDate, this.decisionDate});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CraLoanApplication {\n");
        sb.append("    userToken: ").append(this.toIndentedString(this.userToken)).append("\n");
        sb.append("    applicationId: ").append(this.toIndentedString(this.applicationId)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    decision: ").append(this.toIndentedString((Object)this.decision)).append("\n");
        sb.append("    applicationDate: ").append(this.toIndentedString(this.applicationDate)).append("\n");
        sb.append("    decisionDate: ").append(this.toIndentedString(this.decisionDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

