/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Contains the payment information for a loan payment period.")
public class CraLoanPaymentHistory {
    public static final String SERIALIZED_NAME_PERIOD = "period";
    @SerializedName(value="period")
    private Integer period;
    public static final String SERIALIZED_NAME_DUE_DATE = "due_date";
    @SerializedName(value="due_date")
    private LocalDate dueDate;
    public static final String SERIALIZED_NAME_DAYS_PAST_DUE = "days_past_due";
    @SerializedName(value="days_past_due")
    private Integer daysPastDue;
    public static final String SERIALIZED_NAME_AMOUNT_PAST_DUE = "amount_past_due";
    @SerializedName(value="amount_past_due")
    private Double amountPastDue;
    public static final String SERIALIZED_NAME_BALANCE_REMAINING = "balance_remaining";
    @SerializedName(value="balance_remaining")
    private Double balanceRemaining;

    public CraLoanPaymentHistory period(Integer period) {
        this.period = period;
        return this;
    }

    @ApiModelProperty(required=true, value="The index to identify the loan's payment period, starting from 1. For example:   1 means the period between the loan's opening date and the 1st payment due date.   2 means the period between the loan's 1st payment due date and 2nd payment due date.")
    public Integer getPeriod() {
        return this.period;
    }

    public void setPeriod(Integer period) {
        this.period = period;
    }

    public CraLoanPaymentHistory dueDate(LocalDate dueDate) {
        this.dueDate = dueDate;
        return this;
    }

    @ApiModelProperty(required=true, value="The payment due date or end date of the payment period. The date should be in ISO 8601 format (YYYY-MM-DD).")
    public LocalDate getDueDate() {
        return this.dueDate;
    }

    public void setDueDate(LocalDate dueDate) {
        this.dueDate = dueDate;
    }

    public CraLoanPaymentHistory daysPastDue(Integer daysPastDue) {
        this.daysPastDue = daysPastDue;
        return this;
    }

    @ApiModelProperty(required=true, value="The number of days the loan was delinquent at the end of the pay period. If specified, should be greater of equal to 0.")
    public Integer getDaysPastDue() {
        return this.daysPastDue;
    }

    public void setDaysPastDue(Integer daysPastDue) {
        this.daysPastDue = daysPastDue;
    }

    public CraLoanPaymentHistory amountPastDue(Double amountPastDue) {
        this.amountPastDue = amountPastDue;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The amount past due or the charge-off amount of the loan at the end of the payment period.")
    public Double getAmountPastDue() {
        return this.amountPastDue;
    }

    public void setAmountPastDue(Double amountPastDue) {
        this.amountPastDue = amountPastDue;
    }

    public CraLoanPaymentHistory balanceRemaining(Double balanceRemaining) {
        this.balanceRemaining = balanceRemaining;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The balance remaining on the loan at the end of the payment period.")
    public Double getBalanceRemaining() {
        return this.balanceRemaining;
    }

    public void setBalanceRemaining(Double balanceRemaining) {
        this.balanceRemaining = balanceRemaining;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CraLoanPaymentHistory craLoanPaymentHistory = (CraLoanPaymentHistory)o;
        return Objects.equals(this.period, craLoanPaymentHistory.period) && Objects.equals(this.dueDate, craLoanPaymentHistory.dueDate) && Objects.equals(this.daysPastDue, craLoanPaymentHistory.daysPastDue) && Objects.equals(this.amountPastDue, craLoanPaymentHistory.amountPastDue) && Objects.equals(this.balanceRemaining, craLoanPaymentHistory.balanceRemaining);
    }

    public int hashCode() {
        return Objects.hash(this.period, this.dueDate, this.daysPastDue, this.amountPastDue, this.balanceRemaining);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CraLoanPaymentHistory {\n");
        sb.append("    period: ").append(this.toIndentedString(this.period)).append("\n");
        sb.append("    dueDate: ").append(this.toIndentedString(this.dueDate)).append("\n");
        sb.append("    daysPastDue: ").append(this.toIndentedString(this.daysPastDue)).append("\n");
        sb.append("    amountPastDue: ").append(this.toIndentedString(this.amountPastDue)).append("\n");
        sb.append("    balanceRemaining: ").append(this.toIndentedString(this.balanceRemaining)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

