/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.CraLoanOpenedStatus;
import com.plaid.client.model.CraLoanPaymentSchedule;
import com.plaid.client.model.CraLoanRegisterApplication;
import com.plaid.client.model.CraLoanType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Contains loan data to register.")
public class CraLoanRegister {
    public static final String SERIALIZED_NAME_USER_TOKEN = "user_token";
    @SerializedName(value="user_token")
    private String userToken;
    public static final String SERIALIZED_NAME_LOAN_ID = "loan_id";
    @SerializedName(value="loan_id")
    private String loanId;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private CraLoanType type;
    public static final String SERIALIZED_NAME_PAYMENT_SCHEDULE = "payment_schedule";
    @SerializedName(value="payment_schedule")
    private CraLoanPaymentSchedule paymentSchedule;
    public static final String SERIALIZED_NAME_OPENED_DATE = "opened_date";
    @SerializedName(value="opened_date")
    private LocalDate openedDate;
    public static final String SERIALIZED_NAME_OPENED_WITH_STATUS = "opened_with_status";
    @SerializedName(value="opened_with_status")
    private CraLoanOpenedStatus openedWithStatus;
    public static final String SERIALIZED_NAME_LOAN_AMOUNT = "loan_amount";
    @SerializedName(value="loan_amount")
    private Double loanAmount;
    public static final String SERIALIZED_NAME_APPLICATION = "application";
    @SerializedName(value="application")
    private CraLoanRegisterApplication application;

    public CraLoanRegister userToken(String userToken) {
        this.userToken = userToken;
        return this;
    }

    @ApiModelProperty(required=true, value="The user token for the user associated with the loan.")
    public String getUserToken() {
        return this.userToken;
    }

    public void setUserToken(String userToken) {
        this.userToken = userToken;
    }

    public CraLoanRegister loanId(String loanId) {
        this.loanId = loanId;
        return this;
    }

    @ApiModelProperty(required=true, value="A unique identifier for the loan.  Personally identifiable information, such as an email address or phone number, should not be used in the `loan_id`.")
    public String getLoanId() {
        return this.loanId;
    }

    public void setLoanId(String loanId) {
        this.loanId = loanId;
    }

    public CraLoanRegister type(CraLoanType type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public CraLoanType getType() {
        return this.type;
    }

    public void setType(CraLoanType type) {
        this.type = type;
    }

    public CraLoanRegister paymentSchedule(CraLoanPaymentSchedule paymentSchedule) {
        this.paymentSchedule = paymentSchedule;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public CraLoanPaymentSchedule getPaymentSchedule() {
        return this.paymentSchedule;
    }

    public void setPaymentSchedule(CraLoanPaymentSchedule paymentSchedule) {
        this.paymentSchedule = paymentSchedule;
    }

    public CraLoanRegister openedDate(LocalDate openedDate) {
        this.openedDate = openedDate;
        return this;
    }

    @ApiModelProperty(required=true, value="The date the loan account was opened. The date should be in ISO 8601 format (YYYY-MM-DD).")
    public LocalDate getOpenedDate() {
        return this.openedDate;
    }

    public void setOpenedDate(LocalDate openedDate) {
        this.openedDate = openedDate;
    }

    public CraLoanRegister openedWithStatus(CraLoanOpenedStatus openedWithStatus) {
        this.openedWithStatus = openedWithStatus;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public CraLoanOpenedStatus getOpenedWithStatus() {
        return this.openedWithStatus;
    }

    public void setOpenedWithStatus(CraLoanOpenedStatus openedWithStatus) {
        this.openedWithStatus = openedWithStatus;
    }

    public CraLoanRegister loanAmount(Double loanAmount) {
        this.loanAmount = loanAmount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The total amount of the approved loan.")
    public Double getLoanAmount() {
        return this.loanAmount;
    }

    public void setLoanAmount(Double loanAmount) {
        this.loanAmount = loanAmount;
    }

    public CraLoanRegister application(CraLoanRegisterApplication application) {
        this.application = application;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public CraLoanRegisterApplication getApplication() {
        return this.application;
    }

    public void setApplication(CraLoanRegisterApplication application) {
        this.application = application;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CraLoanRegister craLoanRegister = (CraLoanRegister)o;
        return Objects.equals(this.userToken, craLoanRegister.userToken) && Objects.equals(this.loanId, craLoanRegister.loanId) && Objects.equals((Object)this.type, (Object)craLoanRegister.type) && Objects.equals((Object)this.paymentSchedule, (Object)craLoanRegister.paymentSchedule) && Objects.equals(this.openedDate, craLoanRegister.openedDate) && Objects.equals(this.openedWithStatus, craLoanRegister.openedWithStatus) && Objects.equals(this.loanAmount, craLoanRegister.loanAmount) && Objects.equals(this.application, craLoanRegister.application);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.userToken, this.loanId, this.type, this.paymentSchedule, this.openedDate, this.openedWithStatus, this.loanAmount, this.application});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CraLoanRegister {\n");
        sb.append("    userToken: ").append(this.toIndentedString(this.userToken)).append("\n");
        sb.append("    loanId: ").append(this.toIndentedString(this.loanId)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    paymentSchedule: ").append(this.toIndentedString((Object)this.paymentSchedule)).append("\n");
        sb.append("    openedDate: ").append(this.toIndentedString(this.openedDate)).append("\n");
        sb.append("    openedWithStatus: ").append(this.toIndentedString(this.openedWithStatus)).append("\n");
        sb.append("    loanAmount: ").append(this.toIndentedString(this.loanAmount)).append("\n");
        sb.append("    application: ").append(this.toIndentedString(this.application)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

