/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Contains loan application data to register.")
public class CraLoanRegisterApplication {
    public static final String SERIALIZED_NAME_APPLICATION_ID = "application_id";
    @SerializedName(value="application_id")
    private String applicationId;
    public static final String SERIALIZED_NAME_APPLICATION_DATE = "application_date";
    @SerializedName(value="application_date")
    private LocalDate applicationDate;

    public CraLoanRegisterApplication applicationId(String applicationId) {
        this.applicationId = applicationId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A unique identifier for the loan application.  Personally identifiable information, such as an email address or phone number, should not be used in the `application_id`.")
    public String getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public CraLoanRegisterApplication applicationDate(LocalDate applicationDate) {
        this.applicationDate = applicationDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The date the user applied for the loan. The date should be in ISO 8601 format (YYYY-MM-DD).")
    public LocalDate getApplicationDate() {
        return this.applicationDate;
    }

    public void setApplicationDate(LocalDate applicationDate) {
        this.applicationDate = applicationDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CraLoanRegisterApplication craLoanRegisterApplication = (CraLoanRegisterApplication)o;
        return Objects.equals(this.applicationId, craLoanRegisterApplication.applicationId) && Objects.equals(this.applicationDate, craLoanRegisterApplication.applicationDate);
    }

    public int hashCode() {
        return Objects.hash(this.applicationId, this.applicationDate);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CraLoanRegisterApplication {\n");
        sb.append("    applicationId: ").append(this.toIndentedString(this.applicationId)).append("\n");
        sb.append("    applicationDate: ").append(this.toIndentedString(this.applicationDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

