/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.CraLoanPaymentHistory;
import com.plaid.client.model.CraLoanStatusHistoryUpdate;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Contains loan data to update.")
public class CraLoanUpdate {
    public static final String SERIALIZED_NAME_LOAN_ID = "loan_id";
    @SerializedName(value="loan_id")
    private String loanId;
    public static final String SERIALIZED_NAME_STATUS_HISTORY = "status_history";
    @SerializedName(value="status_history")
    private List<CraLoanStatusHistoryUpdate> statusHistory = null;
    public static final String SERIALIZED_NAME_PAYMENT_HISTORY = "payment_history";
    @SerializedName(value="payment_history")
    private List<CraLoanPaymentHistory> paymentHistory = null;

    public CraLoanUpdate loanId(String loanId) {
        this.loanId = loanId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A unique identifier for the loan.  Personally identifiable information, such as an email address or phone number, should not be used in the `loan_id`.")
    public String getLoanId() {
        return this.loanId;
    }

    public void setLoanId(String loanId) {
        this.loanId = loanId;
    }

    public CraLoanUpdate statusHistory(List<CraLoanStatusHistoryUpdate> statusHistory) {
        this.statusHistory = statusHistory;
        return this;
    }

    public CraLoanUpdate addStatusHistoryItem(CraLoanStatusHistoryUpdate statusHistoryItem) {
        if (this.statusHistory == null) {
            this.statusHistory = new ArrayList<CraLoanStatusHistoryUpdate>();
        }
        this.statusHistory.add(statusHistoryItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A list of status update history of the loan.")
    public List<CraLoanStatusHistoryUpdate> getStatusHistory() {
        return this.statusHistory;
    }

    public void setStatusHistory(List<CraLoanStatusHistoryUpdate> statusHistory) {
        this.statusHistory = statusHistory;
    }

    public CraLoanUpdate paymentHistory(List<CraLoanPaymentHistory> paymentHistory) {
        this.paymentHistory = paymentHistory;
        return this;
    }

    public CraLoanUpdate addPaymentHistoryItem(CraLoanPaymentHistory paymentHistoryItem) {
        if (this.paymentHistory == null) {
            this.paymentHistory = new ArrayList<CraLoanPaymentHistory>();
        }
        this.paymentHistory.add(paymentHistoryItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The updates to the payment history for the loan.")
    public List<CraLoanPaymentHistory> getPaymentHistory() {
        return this.paymentHistory;
    }

    public void setPaymentHistory(List<CraLoanPaymentHistory> paymentHistory) {
        this.paymentHistory = paymentHistory;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CraLoanUpdate craLoanUpdate = (CraLoanUpdate)o;
        return Objects.equals(this.loanId, craLoanUpdate.loanId) && Objects.equals(this.statusHistory, craLoanUpdate.statusHistory) && Objects.equals(this.paymentHistory, craLoanUpdate.paymentHistory);
    }

    public int hashCode() {
        return Objects.hash(this.loanId, this.statusHistory, this.paymentHistory);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CraLoanUpdate {\n");
        sb.append("    loanId: ").append(this.toIndentedString(this.loanId)).append("\n");
        sb.append("    statusHistory: ").append(this.toIndentedString(this.statusHistory)).append("\n");
        sb.append("    paymentHistory: ").append(this.toIndentedString(this.paymentHistory)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

