/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.CraLoanApplication;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="CraLoansApplicationsRegisterRequest defines the request schema for `/cra/loans/applications/register`.")
public class CraLoansApplicationsRegisterRequest {
    public static final String SERIALIZED_NAME_CLIENT_ID = "client_id";
    @SerializedName(value="client_id")
    private String clientId;
    public static final String SERIALIZED_NAME_SECRET = "secret";
    @SerializedName(value="secret")
    private String secret;
    public static final String SERIALIZED_NAME_APPLICATIONS = "applications";
    @SerializedName(value="applications")
    private List<CraLoanApplication> applications = new ArrayList<CraLoanApplication>();

    public CraLoansApplicationsRegisterRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public CraLoansApplicationsRegisterRequest secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public CraLoansApplicationsRegisterRequest applications(List<CraLoanApplication> applications) {
        this.applications = applications;
        return this;
    }

    public CraLoansApplicationsRegisterRequest addApplicationsItem(CraLoanApplication applicationsItem) {
        this.applications.add(applicationsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="A list of loan applications to register.")
    public List<CraLoanApplication> getApplications() {
        return this.applications;
    }

    public void setApplications(List<CraLoanApplication> applications) {
        this.applications = applications;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CraLoansApplicationsRegisterRequest craLoansApplicationsRegisterRequest = (CraLoansApplicationsRegisterRequest)o;
        return Objects.equals(this.clientId, craLoansApplicationsRegisterRequest.clientId) && Objects.equals(this.secret, craLoansApplicationsRegisterRequest.secret) && Objects.equals(this.applications, craLoansApplicationsRegisterRequest.applications);
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.secret, this.applications);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CraLoansApplicationsRegisterRequest {\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    applications: ").append(this.toIndentedString(this.applications)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

