/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.CraLoanUnregister;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="CraLoansUnregisterRequest defines the request schema for `/cra/loans/unregister`")
public class CraLoansUnregisterRequest {
    public static final String SERIALIZED_NAME_CLIENT_ID = "client_id";
    @SerializedName(value="client_id")
    private String clientId;
    public static final String SERIALIZED_NAME_SECRET = "secret";
    @SerializedName(value="secret")
    private String secret;
    public static final String SERIALIZED_NAME_LOANS = "loans";
    @SerializedName(value="loans")
    private List<CraLoanUnregister> loans = new ArrayList<CraLoanUnregister>();

    public CraLoansUnregisterRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public CraLoansUnregisterRequest secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public CraLoansUnregisterRequest loans(List<CraLoanUnregister> loans) {
        this.loans = loans;
        return this;
    }

    public CraLoansUnregisterRequest addLoansItem(CraLoanUnregister loansItem) {
        this.loans.add(loansItem);
        return this;
    }

    @ApiModelProperty(required=true, value="A list of loans to unregister.")
    public List<CraLoanUnregister> getLoans() {
        return this.loans;
    }

    public void setLoans(List<CraLoanUnregister> loans) {
        this.loans = loans;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CraLoansUnregisterRequest craLoansUnregisterRequest = (CraLoansUnregisterRequest)o;
        return Objects.equals(this.clientId, craLoansUnregisterRequest.clientId) && Objects.equals(this.secret, craLoansUnregisterRequest.secret) && Objects.equals(this.loans, craLoansUnregisterRequest.loans);
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.secret, this.loans);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CraLoansUnregisterRequest {\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    loans: ").append(this.toIndentedString(this.loans)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

