/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.CraNetworkAttributesItem;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Contains data for the CRA Network Attributes Report.")
public class CraNetworkAttributesReport {
    public static final String SERIALIZED_NAME_REPORT_ID = "report_id";
    @SerializedName(value="report_id")
    private String reportId;
    public static final String SERIALIZED_NAME_GENERATED_TIME = "generated_time";
    @SerializedName(value="generated_time")
    private OffsetDateTime generatedTime;
    public static final String SERIALIZED_NAME_NETWORK_ATTRIBUTES = "network_attributes";
    @SerializedName(value="network_attributes")
    private Object networkAttributes;
    public static final String SERIALIZED_NAME_ITEMS = "items";
    @SerializedName(value="items")
    private List<CraNetworkAttributesItem> items = new ArrayList<CraNetworkAttributesItem>();

    public CraNetworkAttributesReport reportId(String reportId) {
        this.reportId = reportId;
        return this;
    }

    @ApiModelProperty(required=true, value="The unique identifier associated with the Network Attributes report object.")
    public String getReportId() {
        return this.reportId;
    }

    public void setReportId(String reportId) {
        this.reportId = reportId;
    }

    public CraNetworkAttributesReport generatedTime(OffsetDateTime generatedTime) {
        this.generatedTime = generatedTime;
        return this;
    }

    @ApiModelProperty(required=true, value="The time when the Network Attributes Report was generated.")
    public OffsetDateTime getGeneratedTime() {
        return this.generatedTime;
    }

    public void setGeneratedTime(OffsetDateTime generatedTime) {
        this.generatedTime = generatedTime;
    }

    public CraNetworkAttributesReport networkAttributes(Object networkAttributes) {
        this.networkAttributes = networkAttributes;
        return this;
    }

    @ApiModelProperty(required=true, value="A map of network attributes, where the key is a string, and the value is a float, int, or boolean.")
    public Object getNetworkAttributes() {
        return this.networkAttributes;
    }

    public void setNetworkAttributes(Object networkAttributes) {
        this.networkAttributes = networkAttributes;
    }

    public CraNetworkAttributesReport items(List<CraNetworkAttributesItem> items) {
        this.items = items;
        return this;
    }

    public CraNetworkAttributesReport addItemsItem(CraNetworkAttributesItem itemsItem) {
        this.items.add(itemsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="The Items the end user connected in Link.")
    public List<CraNetworkAttributesItem> getItems() {
        return this.items;
    }

    public void setItems(List<CraNetworkAttributesItem> items) {
        this.items = items;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CraNetworkAttributesReport craNetworkAttributesReport = (CraNetworkAttributesReport)o;
        return Objects.equals(this.reportId, craNetworkAttributesReport.reportId) && Objects.equals(this.generatedTime, craNetworkAttributesReport.generatedTime) && Objects.equals(this.networkAttributes, craNetworkAttributesReport.networkAttributes) && Objects.equals(this.items, craNetworkAttributesReport.items);
    }

    public int hashCode() {
        return Objects.hash(this.reportId, this.generatedTime, this.networkAttributes, this.items);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CraNetworkAttributesReport {\n");
        sb.append("    reportId: ").append(this.toIndentedString(this.reportId)).append("\n");
        sb.append("    generatedTime: ").append(this.toIndentedString(this.generatedTime)).append("\n");
        sb.append("    networkAttributes: ").append(this.toIndentedString(this.networkAttributes)).append("\n");
        sb.append("    items: ").append(this.toIndentedString(this.items)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

