/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.CraPartnerInsightsItem;
import com.plaid.client.model.CraPartnerInsightsPrism;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The Partner Insights report of the bank data for an end user.")
public class CraPartnerInsights {
    public static final String SERIALIZED_NAME_REPORT_ID = "report_id";
    @SerializedName(value="report_id")
    private String reportId;
    public static final String SERIALIZED_NAME_GENERATED_TIME = "generated_time";
    @SerializedName(value="generated_time")
    private OffsetDateTime generatedTime;
    public static final String SERIALIZED_NAME_PRISM = "prism";
    @SerializedName(value="prism")
    private CraPartnerInsightsPrism prism;
    public static final String SERIALIZED_NAME_ITEMS = "items";
    @SerializedName(value="items")
    private List<CraPartnerInsightsItem> items = null;

    public CraPartnerInsights reportId(String reportId) {
        this.reportId = reportId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A unique identifier associated with the Partner Insights object.")
    public String getReportId() {
        return this.reportId;
    }

    public void setReportId(String reportId) {
        this.reportId = reportId;
    }

    public CraPartnerInsights generatedTime(OffsetDateTime generatedTime) {
        this.generatedTime = generatedTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The time when the Partner Insights report was generated.")
    public OffsetDateTime getGeneratedTime() {
        return this.generatedTime;
    }

    public void setGeneratedTime(OffsetDateTime generatedTime) {
        this.generatedTime = generatedTime;
    }

    public CraPartnerInsights prism(CraPartnerInsightsPrism prism) {
        this.prism = prism;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public CraPartnerInsightsPrism getPrism() {
        return this.prism;
    }

    public void setPrism(CraPartnerInsightsPrism prism) {
        this.prism = prism;
    }

    public CraPartnerInsights items(List<CraPartnerInsightsItem> items) {
        this.items = items;
        return this;
    }

    public CraPartnerInsights addItemsItem(CraPartnerInsightsItem itemsItem) {
        if (this.items == null) {
            this.items = new ArrayList<CraPartnerInsightsItem>();
        }
        this.items.add(itemsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The list of Items used in the report along with the associated metadata about the Item.")
    public List<CraPartnerInsightsItem> getItems() {
        return this.items;
    }

    public void setItems(List<CraPartnerInsightsItem> items) {
        this.items = items;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CraPartnerInsights craPartnerInsights = (CraPartnerInsights)o;
        return Objects.equals(this.reportId, craPartnerInsights.reportId) && Objects.equals(this.generatedTime, craPartnerInsights.generatedTime) && Objects.equals(this.prism, craPartnerInsights.prism) && Objects.equals(this.items, craPartnerInsights.items);
    }

    public int hashCode() {
        return Objects.hash(this.reportId, this.generatedTime, this.prism, this.items);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CraPartnerInsights {\n");
        sb.append("    reportId: ").append(this.toIndentedString(this.reportId)).append("\n");
        sb.append("    generatedTime: ").append(this.toIndentedString(this.generatedTime)).append("\n");
        sb.append("    prism: ").append(this.toIndentedString(this.prism)).append("\n");
        sb.append("    items: ").append(this.toIndentedString(this.items)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

