/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The object containing prediction interval data.")
public class CraPredictionInterval {
    public static final String SERIALIZED_NAME_LOWER_BOUND = "lower_bound";
    @SerializedName(value="lower_bound")
    private Double lowerBound;
    public static final String SERIALIZED_NAME_UPPER_BOUND = "upper_bound";
    @SerializedName(value="upper_bound")
    private Double upperBound;
    public static final String SERIALIZED_NAME_PROBABILITY = "probability";
    @SerializedName(value="probability")
    private Double probability;

    public CraPredictionInterval lowerBound(Double lowerBound) {
        this.lowerBound = lowerBound;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The lower bound of the predicted attribute for the given probability.")
    public Double getLowerBound() {
        return this.lowerBound;
    }

    public void setLowerBound(Double lowerBound) {
        this.lowerBound = lowerBound;
    }

    public CraPredictionInterval upperBound(Double upperBound) {
        this.upperBound = upperBound;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The upper bound of the predicted attribute for the given probability.")
    public Double getUpperBound() {
        return this.upperBound;
    }

    public void setUpperBound(Double upperBound) {
        this.upperBound = upperBound;
    }

    public CraPredictionInterval probability(Double probability) {
        this.probability = probability;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The probability of the actual value of the attribute falling within the upper and lower bound. This is a percentage represented as a value between 0 and 1.")
    public Double getProbability() {
        return this.probability;
    }

    public void setProbability(Double probability) {
        this.probability = probability;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CraPredictionInterval craPredictionInterval = (CraPredictionInterval)o;
        return Objects.equals(this.lowerBound, craPredictionInterval.lowerBound) && Objects.equals(this.upperBound, craPredictionInterval.upperBound) && Objects.equals(this.probability, craPredictionInterval.probability);
    }

    public int hashCode() {
        return Objects.hash(this.lowerBound, this.upperBound, this.probability);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CraPredictionInterval {\n");
        sb.append("    lowerBound: ").append(this.toIndentedString(this.lowerBound)).append("\n");
        sb.append("    upperBound: ").append(this.toIndentedString(this.upperBound)).append("\n");
        sb.append("    probability: ").append(this.toIndentedString(this.probability)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

