/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.Credit1099Filer;
import com.plaid.client.model.Credit1099Payer;
import com.plaid.client.model.Credit1099Recipient;
import com.plaid.client.model.CreditDocumentMetadata;
import com.plaid.client.model.Form1099Type;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="An object representing an end user's 1099 tax form")
public class Credit1099 {
    public static final String SERIALIZED_NAME_DOCUMENT_ID = "document_id";
    @SerializedName(value="document_id")
    private String documentId;
    public static final String SERIALIZED_NAME_DOCUMENT_METADATA = "document_metadata";
    @SerializedName(value="document_metadata")
    private CreditDocumentMetadata documentMetadata;
    public static final String SERIALIZED_NAME_FORM1099_TYPE = "form_1099_type";
    @SerializedName(value="form_1099_type")
    private Form1099Type form1099Type;
    public static final String SERIALIZED_NAME_RECIPIENT = "recipient";
    @SerializedName(value="recipient")
    private Credit1099Recipient recipient;
    public static final String SERIALIZED_NAME_PAYER = "payer";
    @SerializedName(value="payer")
    private Credit1099Payer payer;
    public static final String SERIALIZED_NAME_FILER = "filer";
    @SerializedName(value="filer")
    private Credit1099Filer filer;
    public static final String SERIALIZED_NAME_TAX_YEAR = "tax_year";
    @SerializedName(value="tax_year")
    private String taxYear;
    public static final String SERIALIZED_NAME_RENTS = "rents";
    @SerializedName(value="rents")
    private Double rents;
    public static final String SERIALIZED_NAME_ROYALTIES = "royalties";
    @SerializedName(value="royalties")
    private Double royalties;
    public static final String SERIALIZED_NAME_OTHER_INCOME = "other_income";
    @SerializedName(value="other_income")
    private Double otherIncome;
    public static final String SERIALIZED_NAME_FEDERAL_INCOME_TAX_WITHHELD = "federal_income_tax_withheld";
    @SerializedName(value="federal_income_tax_withheld")
    private Double federalIncomeTaxWithheld;
    public static final String SERIALIZED_NAME_FISHING_BOAT_PROCEEDS = "fishing_boat_proceeds";
    @SerializedName(value="fishing_boat_proceeds")
    private Double fishingBoatProceeds;
    public static final String SERIALIZED_NAME_MEDICAL_AND_HEALTHCARE_PAYMENTS = "medical_and_healthcare_payments";
    @SerializedName(value="medical_and_healthcare_payments")
    private Double medicalAndHealthcarePayments;
    public static final String SERIALIZED_NAME_NONEMPLOYEE_COMPENSATION = "nonemployee_compensation";
    @SerializedName(value="nonemployee_compensation")
    private Double nonemployeeCompensation;
    public static final String SERIALIZED_NAME_SUBSTITUTE_PAYMENTS_IN_LIEU_OF_DIVIDENDS_OR_INTEREST = "substitute_payments_in_lieu_of_dividends_or_interest";
    @SerializedName(value="substitute_payments_in_lieu_of_dividends_or_interest")
    private Double substitutePaymentsInLieuOfDividendsOrInterest;
    public static final String SERIALIZED_NAME_PAYER_MADE_DIRECT_SALES_OF5000_OR_MORE_OF_CONSUMER_PRODUCTS_TO_BUYER = "payer_made_direct_sales_of_5000_or_more_of_consumer_products_to_buyer";
    @SerializedName(value="payer_made_direct_sales_of_5000_or_more_of_consumer_products_to_buyer")
    private String payerMadeDirectSalesOf5000OrMoreOfConsumerProductsToBuyer;
    public static final String SERIALIZED_NAME_CROP_INSURANCE_PROCEEDS = "crop_insurance_proceeds";
    @SerializedName(value="crop_insurance_proceeds")
    private Double cropInsuranceProceeds;
    public static final String SERIALIZED_NAME_EXCESS_GOLDEN_PARACHUTE_PAYMENTS = "excess_golden_parachute_payments";
    @SerializedName(value="excess_golden_parachute_payments")
    private Double excessGoldenParachutePayments;
    public static final String SERIALIZED_NAME_GROSS_PROCEEDS_PAID_TO_AN_ATTORNEY = "gross_proceeds_paid_to_an_attorney";
    @SerializedName(value="gross_proceeds_paid_to_an_attorney")
    private Double grossProceedsPaidToAnAttorney;
    public static final String SERIALIZED_NAME_SECTION409A_DEFERRALS = "section_409a_deferrals";
    @SerializedName(value="section_409a_deferrals")
    private Double section409aDeferrals;
    public static final String SERIALIZED_NAME_SECTION409A_INCOME = "section_409a_income";
    @SerializedName(value="section_409a_income")
    private Double section409aIncome;
    public static final String SERIALIZED_NAME_STATE_TAX_WITHHELD = "state_tax_withheld";
    @SerializedName(value="state_tax_withheld")
    private Double stateTaxWithheld;
    public static final String SERIALIZED_NAME_STATE_TAX_WITHHELD_LOWER = "state_tax_withheld_lower";
    @SerializedName(value="state_tax_withheld_lower")
    private Double stateTaxWithheldLower;
    public static final String SERIALIZED_NAME_PAYER_STATE_NUMBER = "payer_state_number";
    @SerializedName(value="payer_state_number")
    private String payerStateNumber;
    public static final String SERIALIZED_NAME_PAYER_STATE_NUMBER_LOWER = "payer_state_number_lower";
    @SerializedName(value="payer_state_number_lower")
    private String payerStateNumberLower;
    public static final String SERIALIZED_NAME_STATE_INCOME = "state_income";
    @SerializedName(value="state_income")
    private Double stateIncome;
    public static final String SERIALIZED_NAME_STATE_INCOME_LOWER = "state_income_lower";
    @SerializedName(value="state_income_lower")
    private Double stateIncomeLower;
    public static final String SERIALIZED_NAME_TRANSACTIONS_REPORTED = "transactions_reported";
    @SerializedName(value="transactions_reported")
    private String transactionsReported;
    public static final String SERIALIZED_NAME_PSE_NAME = "pse_name";
    @SerializedName(value="pse_name")
    private String pseName;
    public static final String SERIALIZED_NAME_PSE_TELEPHONE_NUMBER = "pse_telephone_number";
    @SerializedName(value="pse_telephone_number")
    private String pseTelephoneNumber;
    public static final String SERIALIZED_NAME_GROSS_AMOUNT = "gross_amount";
    @SerializedName(value="gross_amount")
    private Double grossAmount;
    public static final String SERIALIZED_NAME_CARD_NOT_PRESENT_TRANSACTION = "card_not_present_transaction";
    @SerializedName(value="card_not_present_transaction")
    private Double cardNotPresentTransaction;
    public static final String SERIALIZED_NAME_MERCHANT_CATEGORY_CODE = "merchant_category_code";
    @SerializedName(value="merchant_category_code")
    private String merchantCategoryCode;
    public static final String SERIALIZED_NAME_NUMBER_OF_PAYMENT_TRANSACTIONS = "number_of_payment_transactions";
    @SerializedName(value="number_of_payment_transactions")
    private String numberOfPaymentTransactions;
    public static final String SERIALIZED_NAME_JANUARY_AMOUNT = "january_amount";
    @SerializedName(value="january_amount")
    private Double januaryAmount;
    public static final String SERIALIZED_NAME_FEBRUARY_AMOUNT = "february_amount";
    @SerializedName(value="february_amount")
    private Double februaryAmount;
    public static final String SERIALIZED_NAME_MARCH_AMOUNT = "march_amount";
    @SerializedName(value="march_amount")
    private Double marchAmount;
    public static final String SERIALIZED_NAME_APRIL_AMOUNT = "april_amount";
    @SerializedName(value="april_amount")
    private Double aprilAmount;
    public static final String SERIALIZED_NAME_MAY_AMOUNT = "may_amount";
    @SerializedName(value="may_amount")
    private Double mayAmount;
    public static final String SERIALIZED_NAME_JUNE_AMOUNT = "june_amount";
    @SerializedName(value="june_amount")
    private Double juneAmount;
    public static final String SERIALIZED_NAME_JULY_AMOUNT = "july_amount";
    @SerializedName(value="july_amount")
    private Double julyAmount;
    public static final String SERIALIZED_NAME_AUGUST_AMOUNT = "august_amount";
    @SerializedName(value="august_amount")
    private Double augustAmount;
    public static final String SERIALIZED_NAME_SEPTEMBER_AMOUNT = "september_amount";
    @SerializedName(value="september_amount")
    private Double septemberAmount;
    public static final String SERIALIZED_NAME_OCTOBER_AMOUNT = "october_amount";
    @SerializedName(value="october_amount")
    private Double octoberAmount;
    public static final String SERIALIZED_NAME_NOVEMBER_AMOUNT = "november_amount";
    @SerializedName(value="november_amount")
    private Double novemberAmount;
    public static final String SERIALIZED_NAME_DECEMBER_AMOUNT = "december_amount";
    @SerializedName(value="december_amount")
    private Double decemberAmount;
    public static final String SERIALIZED_NAME_PRIMARY_STATE = "primary_state";
    @SerializedName(value="primary_state")
    private String primaryState;
    public static final String SERIALIZED_NAME_SECONDARY_STATE = "secondary_state";
    @SerializedName(value="secondary_state")
    private String secondaryState;
    public static final String SERIALIZED_NAME_PRIMARY_STATE_ID = "primary_state_id";
    @SerializedName(value="primary_state_id")
    private String primaryStateId;
    public static final String SERIALIZED_NAME_SECONDARY_STATE_ID = "secondary_state_id";
    @SerializedName(value="secondary_state_id")
    private String secondaryStateId;
    public static final String SERIALIZED_NAME_PRIMARY_STATE_INCOME_TAX = "primary_state_income_tax";
    @SerializedName(value="primary_state_income_tax")
    private Double primaryStateIncomeTax;
    public static final String SERIALIZED_NAME_SECONDARY_STATE_INCOME_TAX = "secondary_state_income_tax";
    @SerializedName(value="secondary_state_income_tax")
    private Double secondaryStateIncomeTax;

    public Credit1099 documentId(String documentId) {
        this.documentId = documentId;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="An identifier of the document referenced by the document metadata.")
    public String getDocumentId() {
        return this.documentId;
    }

    public void setDocumentId(String documentId) {
        this.documentId = documentId;
    }

    public Credit1099 documentMetadata(CreditDocumentMetadata documentMetadata) {
        this.documentMetadata = documentMetadata;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public CreditDocumentMetadata getDocumentMetadata() {
        return this.documentMetadata;
    }

    public void setDocumentMetadata(CreditDocumentMetadata documentMetadata) {
        this.documentMetadata = documentMetadata;
    }

    public Credit1099 form1099Type(Form1099Type form1099Type) {
        this.form1099Type = form1099Type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Form1099Type getForm1099Type() {
        return this.form1099Type;
    }

    public void setForm1099Type(Form1099Type form1099Type) {
        this.form1099Type = form1099Type;
    }

    public Credit1099 recipient(Credit1099Recipient recipient) {
        this.recipient = recipient;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Credit1099Recipient getRecipient() {
        return this.recipient;
    }

    public void setRecipient(Credit1099Recipient recipient) {
        this.recipient = recipient;
    }

    public Credit1099 payer(Credit1099Payer payer) {
        this.payer = payer;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Credit1099Payer getPayer() {
        return this.payer;
    }

    public void setPayer(Credit1099Payer payer) {
        this.payer = payer;
    }

    public Credit1099 filer(Credit1099Filer filer) {
        this.filer = filer;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Credit1099Filer getFiler() {
        return this.filer;
    }

    public void setFiler(Credit1099Filer filer) {
        this.filer = filer;
    }

    public Credit1099 taxYear(String taxYear) {
        this.taxYear = taxYear;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Tax year of the tax form.")
    public String getTaxYear() {
        return this.taxYear;
    }

    public void setTaxYear(String taxYear) {
        this.taxYear = taxYear;
    }

    public Credit1099 rents(Double rents) {
        this.rents = rents;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Amount in rent by payer.")
    public Double getRents() {
        return this.rents;
    }

    public void setRents(Double rents) {
        this.rents = rents;
    }

    public Credit1099 royalties(Double royalties) {
        this.royalties = royalties;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Amount in royalties by payer.")
    public Double getRoyalties() {
        return this.royalties;
    }

    public void setRoyalties(Double royalties) {
        this.royalties = royalties;
    }

    public Credit1099 otherIncome(Double otherIncome) {
        this.otherIncome = otherIncome;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Amount in other income by payer.")
    public Double getOtherIncome() {
        return this.otherIncome;
    }

    public void setOtherIncome(Double otherIncome) {
        this.otherIncome = otherIncome;
    }

    public Credit1099 federalIncomeTaxWithheld(Double federalIncomeTaxWithheld) {
        this.federalIncomeTaxWithheld = federalIncomeTaxWithheld;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Amount of federal income tax withheld from payer.")
    public Double getFederalIncomeTaxWithheld() {
        return this.federalIncomeTaxWithheld;
    }

    public void setFederalIncomeTaxWithheld(Double federalIncomeTaxWithheld) {
        this.federalIncomeTaxWithheld = federalIncomeTaxWithheld;
    }

    public Credit1099 fishingBoatProceeds(Double fishingBoatProceeds) {
        this.fishingBoatProceeds = fishingBoatProceeds;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Amount of fishing boat proceeds from payer.")
    public Double getFishingBoatProceeds() {
        return this.fishingBoatProceeds;
    }

    public void setFishingBoatProceeds(Double fishingBoatProceeds) {
        this.fishingBoatProceeds = fishingBoatProceeds;
    }

    public Credit1099 medicalAndHealthcarePayments(Double medicalAndHealthcarePayments) {
        this.medicalAndHealthcarePayments = medicalAndHealthcarePayments;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Amount of medical and healthcare payments from payer.")
    public Double getMedicalAndHealthcarePayments() {
        return this.medicalAndHealthcarePayments;
    }

    public void setMedicalAndHealthcarePayments(Double medicalAndHealthcarePayments) {
        this.medicalAndHealthcarePayments = medicalAndHealthcarePayments;
    }

    public Credit1099 nonemployeeCompensation(Double nonemployeeCompensation) {
        this.nonemployeeCompensation = nonemployeeCompensation;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Amount of nonemployee compensation from payer.")
    public Double getNonemployeeCompensation() {
        return this.nonemployeeCompensation;
    }

    public void setNonemployeeCompensation(Double nonemployeeCompensation) {
        this.nonemployeeCompensation = nonemployeeCompensation;
    }

    public Credit1099 substitutePaymentsInLieuOfDividendsOrInterest(Double substitutePaymentsInLieuOfDividendsOrInterest) {
        this.substitutePaymentsInLieuOfDividendsOrInterest = substitutePaymentsInLieuOfDividendsOrInterest;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Amount of substitute payments made by payer.")
    public Double getSubstitutePaymentsInLieuOfDividendsOrInterest() {
        return this.substitutePaymentsInLieuOfDividendsOrInterest;
    }

    public void setSubstitutePaymentsInLieuOfDividendsOrInterest(Double substitutePaymentsInLieuOfDividendsOrInterest) {
        this.substitutePaymentsInLieuOfDividendsOrInterest = substitutePaymentsInLieuOfDividendsOrInterest;
    }

    public Credit1099 payerMadeDirectSalesOf5000OrMoreOfConsumerProductsToBuyer(String payerMadeDirectSalesOf5000OrMoreOfConsumerProductsToBuyer) {
        this.payerMadeDirectSalesOf5000OrMoreOfConsumerProductsToBuyer = payerMadeDirectSalesOf5000OrMoreOfConsumerProductsToBuyer;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether or not payer made direct sales over $5000 of consumer products.")
    public String getPayerMadeDirectSalesOf5000OrMoreOfConsumerProductsToBuyer() {
        return this.payerMadeDirectSalesOf5000OrMoreOfConsumerProductsToBuyer;
    }

    public void setPayerMadeDirectSalesOf5000OrMoreOfConsumerProductsToBuyer(String payerMadeDirectSalesOf5000OrMoreOfConsumerProductsToBuyer) {
        this.payerMadeDirectSalesOf5000OrMoreOfConsumerProductsToBuyer = payerMadeDirectSalesOf5000OrMoreOfConsumerProductsToBuyer;
    }

    public Credit1099 cropInsuranceProceeds(Double cropInsuranceProceeds) {
        this.cropInsuranceProceeds = cropInsuranceProceeds;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Amount of crop insurance proceeds.")
    public Double getCropInsuranceProceeds() {
        return this.cropInsuranceProceeds;
    }

    public void setCropInsuranceProceeds(Double cropInsuranceProceeds) {
        this.cropInsuranceProceeds = cropInsuranceProceeds;
    }

    public Credit1099 excessGoldenParachutePayments(Double excessGoldenParachutePayments) {
        this.excessGoldenParachutePayments = excessGoldenParachutePayments;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Amount of golden parachute payments made by payer.")
    public Double getExcessGoldenParachutePayments() {
        return this.excessGoldenParachutePayments;
    }

    public void setExcessGoldenParachutePayments(Double excessGoldenParachutePayments) {
        this.excessGoldenParachutePayments = excessGoldenParachutePayments;
    }

    public Credit1099 grossProceedsPaidToAnAttorney(Double grossProceedsPaidToAnAttorney) {
        this.grossProceedsPaidToAnAttorney = grossProceedsPaidToAnAttorney;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Amount of gross proceeds paid to an attorney by payer.")
    public Double getGrossProceedsPaidToAnAttorney() {
        return this.grossProceedsPaidToAnAttorney;
    }

    public void setGrossProceedsPaidToAnAttorney(Double grossProceedsPaidToAnAttorney) {
        this.grossProceedsPaidToAnAttorney = grossProceedsPaidToAnAttorney;
    }

    public Credit1099 section409aDeferrals(Double section409aDeferrals) {
        this.section409aDeferrals = section409aDeferrals;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Amount of 409A deferrals earned by payer.")
    public Double getSection409aDeferrals() {
        return this.section409aDeferrals;
    }

    public void setSection409aDeferrals(Double section409aDeferrals) {
        this.section409aDeferrals = section409aDeferrals;
    }

    public Credit1099 section409aIncome(Double section409aIncome) {
        this.section409aIncome = section409aIncome;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Amount of 409A income earned by payer.")
    public Double getSection409aIncome() {
        return this.section409aIncome;
    }

    public void setSection409aIncome(Double section409aIncome) {
        this.section409aIncome = section409aIncome;
    }

    public Credit1099 stateTaxWithheld(Double stateTaxWithheld) {
        this.stateTaxWithheld = stateTaxWithheld;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Amount of state tax withheld of payer for primary state.")
    public Double getStateTaxWithheld() {
        return this.stateTaxWithheld;
    }

    public void setStateTaxWithheld(Double stateTaxWithheld) {
        this.stateTaxWithheld = stateTaxWithheld;
    }

    public Credit1099 stateTaxWithheldLower(Double stateTaxWithheldLower) {
        this.stateTaxWithheldLower = stateTaxWithheldLower;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Amount of state tax withheld of payer for secondary state.")
    public Double getStateTaxWithheldLower() {
        return this.stateTaxWithheldLower;
    }

    public void setStateTaxWithheldLower(Double stateTaxWithheldLower) {
        this.stateTaxWithheldLower = stateTaxWithheldLower;
    }

    public Credit1099 payerStateNumber(String payerStateNumber) {
        this.payerStateNumber = payerStateNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Primary state ID.")
    public String getPayerStateNumber() {
        return this.payerStateNumber;
    }

    public void setPayerStateNumber(String payerStateNumber) {
        this.payerStateNumber = payerStateNumber;
    }

    public Credit1099 payerStateNumberLower(String payerStateNumberLower) {
        this.payerStateNumberLower = payerStateNumberLower;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Secondary state ID.")
    public String getPayerStateNumberLower() {
        return this.payerStateNumberLower;
    }

    public void setPayerStateNumberLower(String payerStateNumberLower) {
        this.payerStateNumberLower = payerStateNumberLower;
    }

    public Credit1099 stateIncome(Double stateIncome) {
        this.stateIncome = stateIncome;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="State income reported for primary state.")
    public Double getStateIncome() {
        return this.stateIncome;
    }

    public void setStateIncome(Double stateIncome) {
        this.stateIncome = stateIncome;
    }

    public Credit1099 stateIncomeLower(Double stateIncomeLower) {
        this.stateIncomeLower = stateIncomeLower;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="State income reported for secondary state.")
    public Double getStateIncomeLower() {
        return this.stateIncomeLower;
    }

    public void setStateIncomeLower(Double stateIncomeLower) {
        this.stateIncomeLower = stateIncomeLower;
    }

    public Credit1099 transactionsReported(String transactionsReported) {
        this.transactionsReported = transactionsReported;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="One of the values will be provided Payment card Third party network")
    public String getTransactionsReported() {
        return this.transactionsReported;
    }

    public void setTransactionsReported(String transactionsReported) {
        this.transactionsReported = transactionsReported;
    }

    public Credit1099 pseName(String pseName) {
        this.pseName = pseName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Name of the PSE (Payment Settlement Entity).")
    public String getPseName() {
        return this.pseName;
    }

    public void setPseName(String pseName) {
        this.pseName = pseName;
    }

    public Credit1099 pseTelephoneNumber(String pseTelephoneNumber) {
        this.pseTelephoneNumber = pseTelephoneNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Formatted (XXX) XXX-XXXX. Phone number of the PSE (Payment Settlement Entity).")
    public String getPseTelephoneNumber() {
        return this.pseTelephoneNumber;
    }

    public void setPseTelephoneNumber(String pseTelephoneNumber) {
        this.pseTelephoneNumber = pseTelephoneNumber;
    }

    public Credit1099 grossAmount(Double grossAmount) {
        this.grossAmount = grossAmount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Gross amount reported.")
    public Double getGrossAmount() {
        return this.grossAmount;
    }

    public void setGrossAmount(Double grossAmount) {
        this.grossAmount = grossAmount;
    }

    public Credit1099 cardNotPresentTransaction(Double cardNotPresentTransaction) {
        this.cardNotPresentTransaction = cardNotPresentTransaction;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Amount in card not present transactions.")
    public Double getCardNotPresentTransaction() {
        return this.cardNotPresentTransaction;
    }

    public void setCardNotPresentTransaction(Double cardNotPresentTransaction) {
        this.cardNotPresentTransaction = cardNotPresentTransaction;
    }

    public Credit1099 merchantCategoryCode(String merchantCategoryCode) {
        this.merchantCategoryCode = merchantCategoryCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Merchant category of filer.")
    public String getMerchantCategoryCode() {
        return this.merchantCategoryCode;
    }

    public void setMerchantCategoryCode(String merchantCategoryCode) {
        this.merchantCategoryCode = merchantCategoryCode;
    }

    public Credit1099 numberOfPaymentTransactions(String numberOfPaymentTransactions) {
        this.numberOfPaymentTransactions = numberOfPaymentTransactions;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Number of payment transactions made.")
    public String getNumberOfPaymentTransactions() {
        return this.numberOfPaymentTransactions;
    }

    public void setNumberOfPaymentTransactions(String numberOfPaymentTransactions) {
        this.numberOfPaymentTransactions = numberOfPaymentTransactions;
    }

    public Credit1099 januaryAmount(Double januaryAmount) {
        this.januaryAmount = januaryAmount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Amount reported for January.")
    public Double getJanuaryAmount() {
        return this.januaryAmount;
    }

    public void setJanuaryAmount(Double januaryAmount) {
        this.januaryAmount = januaryAmount;
    }

    public Credit1099 februaryAmount(Double februaryAmount) {
        this.februaryAmount = februaryAmount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Amount reported for February.")
    public Double getFebruaryAmount() {
        return this.februaryAmount;
    }

    public void setFebruaryAmount(Double februaryAmount) {
        this.februaryAmount = februaryAmount;
    }

    public Credit1099 marchAmount(Double marchAmount) {
        this.marchAmount = marchAmount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Amount reported for March.")
    public Double getMarchAmount() {
        return this.marchAmount;
    }

    public void setMarchAmount(Double marchAmount) {
        this.marchAmount = marchAmount;
    }

    public Credit1099 aprilAmount(Double aprilAmount) {
        this.aprilAmount = aprilAmount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Amount reported for April.")
    public Double getAprilAmount() {
        return this.aprilAmount;
    }

    public void setAprilAmount(Double aprilAmount) {
        this.aprilAmount = aprilAmount;
    }

    public Credit1099 mayAmount(Double mayAmount) {
        this.mayAmount = mayAmount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Amount reported for May.")
    public Double getMayAmount() {
        return this.mayAmount;
    }

    public void setMayAmount(Double mayAmount) {
        this.mayAmount = mayAmount;
    }

    public Credit1099 juneAmount(Double juneAmount) {
        this.juneAmount = juneAmount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Amount reported for June.")
    public Double getJuneAmount() {
        return this.juneAmount;
    }

    public void setJuneAmount(Double juneAmount) {
        this.juneAmount = juneAmount;
    }

    public Credit1099 julyAmount(Double julyAmount) {
        this.julyAmount = julyAmount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Amount reported for July.")
    public Double getJulyAmount() {
        return this.julyAmount;
    }

    public void setJulyAmount(Double julyAmount) {
        this.julyAmount = julyAmount;
    }

    public Credit1099 augustAmount(Double augustAmount) {
        this.augustAmount = augustAmount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Amount reported for August.")
    public Double getAugustAmount() {
        return this.augustAmount;
    }

    public void setAugustAmount(Double augustAmount) {
        this.augustAmount = augustAmount;
    }

    public Credit1099 septemberAmount(Double septemberAmount) {
        this.septemberAmount = septemberAmount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Amount reported for September.")
    public Double getSeptemberAmount() {
        return this.septemberAmount;
    }

    public void setSeptemberAmount(Double septemberAmount) {
        this.septemberAmount = septemberAmount;
    }

    public Credit1099 octoberAmount(Double octoberAmount) {
        this.octoberAmount = octoberAmount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Amount reported for October.")
    public Double getOctoberAmount() {
        return this.octoberAmount;
    }

    public void setOctoberAmount(Double octoberAmount) {
        this.octoberAmount = octoberAmount;
    }

    public Credit1099 novemberAmount(Double novemberAmount) {
        this.novemberAmount = novemberAmount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Amount reported for November.")
    public Double getNovemberAmount() {
        return this.novemberAmount;
    }

    public void setNovemberAmount(Double novemberAmount) {
        this.novemberAmount = novemberAmount;
    }

    public Credit1099 decemberAmount(Double decemberAmount) {
        this.decemberAmount = decemberAmount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Amount reported for December.")
    public Double getDecemberAmount() {
        return this.decemberAmount;
    }

    public void setDecemberAmount(Double decemberAmount) {
        this.decemberAmount = decemberAmount;
    }

    public Credit1099 primaryState(String primaryState) {
        this.primaryState = primaryState;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Primary state of business.")
    public String getPrimaryState() {
        return this.primaryState;
    }

    public void setPrimaryState(String primaryState) {
        this.primaryState = primaryState;
    }

    public Credit1099 secondaryState(String secondaryState) {
        this.secondaryState = secondaryState;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Secondary state of business.")
    public String getSecondaryState() {
        return this.secondaryState;
    }

    public void setSecondaryState(String secondaryState) {
        this.secondaryState = secondaryState;
    }

    public Credit1099 primaryStateId(String primaryStateId) {
        this.primaryStateId = primaryStateId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Primary state ID.")
    public String getPrimaryStateId() {
        return this.primaryStateId;
    }

    public void setPrimaryStateId(String primaryStateId) {
        this.primaryStateId = primaryStateId;
    }

    public Credit1099 secondaryStateId(String secondaryStateId) {
        this.secondaryStateId = secondaryStateId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Secondary state ID.")
    public String getSecondaryStateId() {
        return this.secondaryStateId;
    }

    public void setSecondaryStateId(String secondaryStateId) {
        this.secondaryStateId = secondaryStateId;
    }

    public Credit1099 primaryStateIncomeTax(Double primaryStateIncomeTax) {
        this.primaryStateIncomeTax = primaryStateIncomeTax;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="State income tax reported for primary state.")
    public Double getPrimaryStateIncomeTax() {
        return this.primaryStateIncomeTax;
    }

    public void setPrimaryStateIncomeTax(Double primaryStateIncomeTax) {
        this.primaryStateIncomeTax = primaryStateIncomeTax;
    }

    public Credit1099 secondaryStateIncomeTax(Double secondaryStateIncomeTax) {
        this.secondaryStateIncomeTax = secondaryStateIncomeTax;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="State income tax reported for secondary state.")
    public Double getSecondaryStateIncomeTax() {
        return this.secondaryStateIncomeTax;
    }

    public void setSecondaryStateIncomeTax(Double secondaryStateIncomeTax) {
        this.secondaryStateIncomeTax = secondaryStateIncomeTax;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Credit1099 credit1099 = (Credit1099)o;
        return Objects.equals(this.documentId, credit1099.documentId) && Objects.equals(this.documentMetadata, credit1099.documentMetadata) && Objects.equals((Object)this.form1099Type, (Object)credit1099.form1099Type) && Objects.equals(this.recipient, credit1099.recipient) && Objects.equals(this.payer, credit1099.payer) && Objects.equals(this.filer, credit1099.filer) && Objects.equals(this.taxYear, credit1099.taxYear) && Objects.equals(this.rents, credit1099.rents) && Objects.equals(this.royalties, credit1099.royalties) && Objects.equals(this.otherIncome, credit1099.otherIncome) && Objects.equals(this.federalIncomeTaxWithheld, credit1099.federalIncomeTaxWithheld) && Objects.equals(this.fishingBoatProceeds, credit1099.fishingBoatProceeds) && Objects.equals(this.medicalAndHealthcarePayments, credit1099.medicalAndHealthcarePayments) && Objects.equals(this.nonemployeeCompensation, credit1099.nonemployeeCompensation) && Objects.equals(this.substitutePaymentsInLieuOfDividendsOrInterest, credit1099.substitutePaymentsInLieuOfDividendsOrInterest) && Objects.equals(this.payerMadeDirectSalesOf5000OrMoreOfConsumerProductsToBuyer, credit1099.payerMadeDirectSalesOf5000OrMoreOfConsumerProductsToBuyer) && Objects.equals(this.cropInsuranceProceeds, credit1099.cropInsuranceProceeds) && Objects.equals(this.excessGoldenParachutePayments, credit1099.excessGoldenParachutePayments) && Objects.equals(this.grossProceedsPaidToAnAttorney, credit1099.grossProceedsPaidToAnAttorney) && Objects.equals(this.section409aDeferrals, credit1099.section409aDeferrals) && Objects.equals(this.section409aIncome, credit1099.section409aIncome) && Objects.equals(this.stateTaxWithheld, credit1099.stateTaxWithheld) && Objects.equals(this.stateTaxWithheldLower, credit1099.stateTaxWithheldLower) && Objects.equals(this.payerStateNumber, credit1099.payerStateNumber) && Objects.equals(this.payerStateNumberLower, credit1099.payerStateNumberLower) && Objects.equals(this.stateIncome, credit1099.stateIncome) && Objects.equals(this.stateIncomeLower, credit1099.stateIncomeLower) && Objects.equals(this.transactionsReported, credit1099.transactionsReported) && Objects.equals(this.pseName, credit1099.pseName) && Objects.equals(this.pseTelephoneNumber, credit1099.pseTelephoneNumber) && Objects.equals(this.grossAmount, credit1099.grossAmount) && Objects.equals(this.cardNotPresentTransaction, credit1099.cardNotPresentTransaction) && Objects.equals(this.merchantCategoryCode, credit1099.merchantCategoryCode) && Objects.equals(this.numberOfPaymentTransactions, credit1099.numberOfPaymentTransactions) && Objects.equals(this.januaryAmount, credit1099.januaryAmount) && Objects.equals(this.februaryAmount, credit1099.februaryAmount) && Objects.equals(this.marchAmount, credit1099.marchAmount) && Objects.equals(this.aprilAmount, credit1099.aprilAmount) && Objects.equals(this.mayAmount, credit1099.mayAmount) && Objects.equals(this.juneAmount, credit1099.juneAmount) && Objects.equals(this.julyAmount, credit1099.julyAmount) && Objects.equals(this.augustAmount, credit1099.augustAmount) && Objects.equals(this.septemberAmount, credit1099.septemberAmount) && Objects.equals(this.octoberAmount, credit1099.octoberAmount) && Objects.equals(this.novemberAmount, credit1099.novemberAmount) && Objects.equals(this.decemberAmount, credit1099.decemberAmount) && Objects.equals(this.primaryState, credit1099.primaryState) && Objects.equals(this.secondaryState, credit1099.secondaryState) && Objects.equals(this.primaryStateId, credit1099.primaryStateId) && Objects.equals(this.secondaryStateId, credit1099.secondaryStateId) && Objects.equals(this.primaryStateIncomeTax, credit1099.primaryStateIncomeTax) && Objects.equals(this.secondaryStateIncomeTax, credit1099.secondaryStateIncomeTax);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.documentId, this.documentMetadata, this.form1099Type, this.recipient, this.payer, this.filer, this.taxYear, this.rents, this.royalties, this.otherIncome, this.federalIncomeTaxWithheld, this.fishingBoatProceeds, this.medicalAndHealthcarePayments, this.nonemployeeCompensation, this.substitutePaymentsInLieuOfDividendsOrInterest, this.payerMadeDirectSalesOf5000OrMoreOfConsumerProductsToBuyer, this.cropInsuranceProceeds, this.excessGoldenParachutePayments, this.grossProceedsPaidToAnAttorney, this.section409aDeferrals, this.section409aIncome, this.stateTaxWithheld, this.stateTaxWithheldLower, this.payerStateNumber, this.payerStateNumberLower, this.stateIncome, this.stateIncomeLower, this.transactionsReported, this.pseName, this.pseTelephoneNumber, this.grossAmount, this.cardNotPresentTransaction, this.merchantCategoryCode, this.numberOfPaymentTransactions, this.januaryAmount, this.februaryAmount, this.marchAmount, this.aprilAmount, this.mayAmount, this.juneAmount, this.julyAmount, this.augustAmount, this.septemberAmount, this.octoberAmount, this.novemberAmount, this.decemberAmount, this.primaryState, this.secondaryState, this.primaryStateId, this.secondaryStateId, this.primaryStateIncomeTax, this.secondaryStateIncomeTax});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Credit1099 {\n");
        sb.append("    documentId: ").append(this.toIndentedString(this.documentId)).append("\n");
        sb.append("    documentMetadata: ").append(this.toIndentedString(this.documentMetadata)).append("\n");
        sb.append("    form1099Type: ").append(this.toIndentedString((Object)this.form1099Type)).append("\n");
        sb.append("    recipient: ").append(this.toIndentedString(this.recipient)).append("\n");
        sb.append("    payer: ").append(this.toIndentedString(this.payer)).append("\n");
        sb.append("    filer: ").append(this.toIndentedString(this.filer)).append("\n");
        sb.append("    taxYear: ").append(this.toIndentedString(this.taxYear)).append("\n");
        sb.append("    rents: ").append(this.toIndentedString(this.rents)).append("\n");
        sb.append("    royalties: ").append(this.toIndentedString(this.royalties)).append("\n");
        sb.append("    otherIncome: ").append(this.toIndentedString(this.otherIncome)).append("\n");
        sb.append("    federalIncomeTaxWithheld: ").append(this.toIndentedString(this.federalIncomeTaxWithheld)).append("\n");
        sb.append("    fishingBoatProceeds: ").append(this.toIndentedString(this.fishingBoatProceeds)).append("\n");
        sb.append("    medicalAndHealthcarePayments: ").append(this.toIndentedString(this.medicalAndHealthcarePayments)).append("\n");
        sb.append("    nonemployeeCompensation: ").append(this.toIndentedString(this.nonemployeeCompensation)).append("\n");
        sb.append("    substitutePaymentsInLieuOfDividendsOrInterest: ").append(this.toIndentedString(this.substitutePaymentsInLieuOfDividendsOrInterest)).append("\n");
        sb.append("    payerMadeDirectSalesOf5000OrMoreOfConsumerProductsToBuyer: ").append(this.toIndentedString(this.payerMadeDirectSalesOf5000OrMoreOfConsumerProductsToBuyer)).append("\n");
        sb.append("    cropInsuranceProceeds: ").append(this.toIndentedString(this.cropInsuranceProceeds)).append("\n");
        sb.append("    excessGoldenParachutePayments: ").append(this.toIndentedString(this.excessGoldenParachutePayments)).append("\n");
        sb.append("    grossProceedsPaidToAnAttorney: ").append(this.toIndentedString(this.grossProceedsPaidToAnAttorney)).append("\n");
        sb.append("    section409aDeferrals: ").append(this.toIndentedString(this.section409aDeferrals)).append("\n");
        sb.append("    section409aIncome: ").append(this.toIndentedString(this.section409aIncome)).append("\n");
        sb.append("    stateTaxWithheld: ").append(this.toIndentedString(this.stateTaxWithheld)).append("\n");
        sb.append("    stateTaxWithheldLower: ").append(this.toIndentedString(this.stateTaxWithheldLower)).append("\n");
        sb.append("    payerStateNumber: ").append(this.toIndentedString(this.payerStateNumber)).append("\n");
        sb.append("    payerStateNumberLower: ").append(this.toIndentedString(this.payerStateNumberLower)).append("\n");
        sb.append("    stateIncome: ").append(this.toIndentedString(this.stateIncome)).append("\n");
        sb.append("    stateIncomeLower: ").append(this.toIndentedString(this.stateIncomeLower)).append("\n");
        sb.append("    transactionsReported: ").append(this.toIndentedString(this.transactionsReported)).append("\n");
        sb.append("    pseName: ").append(this.toIndentedString(this.pseName)).append("\n");
        sb.append("    pseTelephoneNumber: ").append(this.toIndentedString(this.pseTelephoneNumber)).append("\n");
        sb.append("    grossAmount: ").append(this.toIndentedString(this.grossAmount)).append("\n");
        sb.append("    cardNotPresentTransaction: ").append(this.toIndentedString(this.cardNotPresentTransaction)).append("\n");
        sb.append("    merchantCategoryCode: ").append(this.toIndentedString(this.merchantCategoryCode)).append("\n");
        sb.append("    numberOfPaymentTransactions: ").append(this.toIndentedString(this.numberOfPaymentTransactions)).append("\n");
        sb.append("    januaryAmount: ").append(this.toIndentedString(this.januaryAmount)).append("\n");
        sb.append("    februaryAmount: ").append(this.toIndentedString(this.februaryAmount)).append("\n");
        sb.append("    marchAmount: ").append(this.toIndentedString(this.marchAmount)).append("\n");
        sb.append("    aprilAmount: ").append(this.toIndentedString(this.aprilAmount)).append("\n");
        sb.append("    mayAmount: ").append(this.toIndentedString(this.mayAmount)).append("\n");
        sb.append("    juneAmount: ").append(this.toIndentedString(this.juneAmount)).append("\n");
        sb.append("    julyAmount: ").append(this.toIndentedString(this.julyAmount)).append("\n");
        sb.append("    augustAmount: ").append(this.toIndentedString(this.augustAmount)).append("\n");
        sb.append("    septemberAmount: ").append(this.toIndentedString(this.septemberAmount)).append("\n");
        sb.append("    octoberAmount: ").append(this.toIndentedString(this.octoberAmount)).append("\n");
        sb.append("    novemberAmount: ").append(this.toIndentedString(this.novemberAmount)).append("\n");
        sb.append("    decemberAmount: ").append(this.toIndentedString(this.decemberAmount)).append("\n");
        sb.append("    primaryState: ").append(this.toIndentedString(this.primaryState)).append("\n");
        sb.append("    secondaryState: ").append(this.toIndentedString(this.secondaryState)).append("\n");
        sb.append("    primaryStateId: ").append(this.toIndentedString(this.primaryStateId)).append("\n");
        sb.append("    secondaryStateId: ").append(this.toIndentedString(this.secondaryStateId)).append("\n");
        sb.append("    primaryStateIncomeTax: ").append(this.toIndentedString(this.primaryStateIncomeTax)).append("\n");
        sb.append("    secondaryStateIncomeTax: ").append(this.toIndentedString(this.secondaryStateIncomeTax)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

