/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.CreditPayStubAddress;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="An object representing a recipient used in both 1099-K and 1099-MISC tax documents.")
public class Credit1099Recipient {
    public static final String SERIALIZED_NAME_ADDRESS = "address";
    @SerializedName(value="address")
    private CreditPayStubAddress address;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_TIN = "tin";
    @SerializedName(value="tin")
    private String tin;
    public static final String SERIALIZED_NAME_ACCOUNT_NUMBER = "account_number";
    @SerializedName(value="account_number")
    private String accountNumber;
    public static final String SERIALIZED_NAME_FACTA_FILING_REQUIREMENT = "facta_filing_requirement";
    @SerializedName(value="facta_filing_requirement")
    private String factaFilingRequirement;
    public static final String SERIALIZED_NAME_SECOND_TIN_EXISTS = "second_tin_exists";
    @SerializedName(value="second_tin_exists")
    private String secondTinExists;

    public Credit1099Recipient address(CreditPayStubAddress address) {
        this.address = address;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public CreditPayStubAddress getAddress() {
        return this.address;
    }

    public void setAddress(CreditPayStubAddress address) {
        this.address = address;
    }

    public Credit1099Recipient name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Name of recipient.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Credit1099Recipient tin(String tin) {
        this.tin = tin;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Tax identification number of recipient.")
    public String getTin() {
        return this.tin;
    }

    public void setTin(String tin) {
        this.tin = tin;
    }

    public Credit1099Recipient accountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Account number number of recipient.")
    public String getAccountNumber() {
        return this.accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public Credit1099Recipient factaFilingRequirement(String factaFilingRequirement) {
        this.factaFilingRequirement = factaFilingRequirement;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Checked if FACTA is a filing requirement.")
    public String getFactaFilingRequirement() {
        return this.factaFilingRequirement;
    }

    public void setFactaFilingRequirement(String factaFilingRequirement) {
        this.factaFilingRequirement = factaFilingRequirement;
    }

    public Credit1099Recipient secondTinExists(String secondTinExists) {
        this.secondTinExists = secondTinExists;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Checked if 2nd TIN exists.")
    public String getSecondTinExists() {
        return this.secondTinExists;
    }

    public void setSecondTinExists(String secondTinExists) {
        this.secondTinExists = secondTinExists;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Credit1099Recipient credit1099Recipient = (Credit1099Recipient)o;
        return Objects.equals(this.address, credit1099Recipient.address) && Objects.equals(this.name, credit1099Recipient.name) && Objects.equals(this.tin, credit1099Recipient.tin) && Objects.equals(this.accountNumber, credit1099Recipient.accountNumber) && Objects.equals(this.factaFilingRequirement, credit1099Recipient.factaFilingRequirement) && Objects.equals(this.secondTinExists, credit1099Recipient.secondTinExists);
    }

    public int hashCode() {
        return Objects.hash(this.address, this.name, this.tin, this.accountNumber, this.factaFilingRequirement, this.secondTinExists);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Credit1099Recipient {\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    tin: ").append(this.toIndentedString(this.tin)).append("\n");
        sb.append("    accountNumber: ").append(this.toIndentedString(this.accountNumber)).append("\n");
        sb.append("    factaFilingRequirement: ").append(this.toIndentedString(this.factaFilingRequirement)).append("\n");
        sb.append("    secondTinExists: ").append(this.toIndentedString(this.secondTinExists)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

