/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="CreditAuditCopyTokenCreateRequest defines the request schema for `/credit/audit_copy_token/create`")
public class CreditAuditCopyTokenCreateRequest {
    public static final String SERIALIZED_NAME_CLIENT_ID = "client_id";
    @SerializedName(value="client_id")
    private String clientId;
    public static final String SERIALIZED_NAME_SECRET = "secret";
    @SerializedName(value="secret")
    private String secret;
    public static final String SERIALIZED_NAME_REPORT_TOKENS = "report_tokens";
    @SerializedName(value="report_tokens")
    private List<String> reportTokens = new ArrayList<String>();

    public CreditAuditCopyTokenCreateRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public CreditAuditCopyTokenCreateRequest secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public CreditAuditCopyTokenCreateRequest reportTokens(List<String> reportTokens) {
        this.reportTokens = reportTokens;
        return this;
    }

    public CreditAuditCopyTokenCreateRequest addReportTokensItem(String reportTokensItem) {
        this.reportTokens.add(reportTokensItem);
        return this;
    }

    @ApiModelProperty(required=true, value="List of report tokens; can include at most one VOA/standard Asset Report tokens and one VOE Asset Report Token.")
    public List<String> getReportTokens() {
        return this.reportTokens;
    }

    public void setReportTokens(List<String> reportTokens) {
        this.reportTokens = reportTokens;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreditAuditCopyTokenCreateRequest creditAuditCopyTokenCreateRequest = (CreditAuditCopyTokenCreateRequest)o;
        return Objects.equals(this.clientId, creditAuditCopyTokenCreateRequest.clientId) && Objects.equals(this.secret, creditAuditCopyTokenCreateRequest.secret) && Objects.equals(this.reportTokens, creditAuditCopyTokenCreateRequest.reportTokens);
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.secret, this.reportTokens);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreditAuditCopyTokenCreateRequest {\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    reportTokens: ").append(this.toIndentedString(this.reportTokens)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

