/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.CreditBankEmployer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.Objects;

@ApiModel(description="Detailed information for the bank employment.")
public class CreditBankEmployment {
    public static final String SERIALIZED_NAME_BANK_EMPLOYMENT_ID = "bank_employment_id";
    @SerializedName(value="bank_employment_id")
    private String bankEmploymentId;
    public static final String SERIALIZED_NAME_ACCOUNT_ID = "account_id";
    @SerializedName(value="account_id")
    private String accountId;
    public static final String SERIALIZED_NAME_EMPLOYER = "employer";
    @SerializedName(value="employer")
    private CreditBankEmployer employer;
    public static final String SERIALIZED_NAME_LATEST_DEPOSIT_DATE = "latest_deposit_date";
    @SerializedName(value="latest_deposit_date")
    private LocalDate latestDepositDate;
    public static final String SERIALIZED_NAME_EARLIEST_DEPOSIT_DATE = "earliest_deposit_date";
    @SerializedName(value="earliest_deposit_date")
    private LocalDate earliestDepositDate;

    public CreditBankEmployment bankEmploymentId(String bankEmploymentId) {
        this.bankEmploymentId = bankEmploymentId;
        return this;
    }

    @ApiModelProperty(required=true, value="A unique identifier for the bank employment.")
    public String getBankEmploymentId() {
        return this.bankEmploymentId;
    }

    public void setBankEmploymentId(String bankEmploymentId) {
        this.bankEmploymentId = bankEmploymentId;
    }

    public CreditBankEmployment accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @ApiModelProperty(required=true, value="Plaid's unique identifier for the account.")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public CreditBankEmployment employer(CreditBankEmployer employer) {
        this.employer = employer;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public CreditBankEmployer getEmployer() {
        return this.employer;
    }

    public void setEmployer(CreditBankEmployer employer) {
        this.employer = employer;
    }

    public CreditBankEmployment latestDepositDate(LocalDate latestDepositDate) {
        this.latestDepositDate = latestDepositDate;
        return this;
    }

    @ApiModelProperty(required=true, value="The date of the most recent deposit from this employer.")
    public LocalDate getLatestDepositDate() {
        return this.latestDepositDate;
    }

    public void setLatestDepositDate(LocalDate latestDepositDate) {
        this.latestDepositDate = latestDepositDate;
    }

    public CreditBankEmployment earliestDepositDate(LocalDate earliestDepositDate) {
        this.earliestDepositDate = earliestDepositDate;
        return this;
    }

    @ApiModelProperty(required=true, value="The date of the earliest deposit from this employer from within the period of the days requested.")
    public LocalDate getEarliestDepositDate() {
        return this.earliestDepositDate;
    }

    public void setEarliestDepositDate(LocalDate earliestDepositDate) {
        this.earliestDepositDate = earliestDepositDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreditBankEmployment creditBankEmployment = (CreditBankEmployment)o;
        return Objects.equals(this.bankEmploymentId, creditBankEmployment.bankEmploymentId) && Objects.equals(this.accountId, creditBankEmployment.accountId) && Objects.equals(this.employer, creditBankEmployment.employer) && Objects.equals(this.latestDepositDate, creditBankEmployment.latestDepositDate) && Objects.equals(this.earliestDepositDate, creditBankEmployment.earliestDepositDate);
    }

    public int hashCode() {
        return Objects.hash(this.bankEmploymentId, this.accountId, this.employer, this.latestDepositDate, this.earliestDepositDate);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreditBankEmployment {\n");
        sb.append("    bankEmploymentId: ").append(this.toIndentedString(this.bankEmploymentId)).append("\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    employer: ").append(this.toIndentedString(this.employer)).append("\n");
        sb.append("    latestDepositDate: ").append(this.toIndentedString(this.latestDepositDate)).append("\n");
        sb.append("    earliestDepositDate: ").append(this.toIndentedString(this.earliestDepositDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

