/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.CreditBankEmployment;
import com.plaid.client.model.CreditBankIncomeAccount;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="The details and metadata for an end user's Item.")
public class CreditBankEmploymentItem {
    public static final String SERIALIZED_NAME_ITEM_ID = "item_id";
    @SerializedName(value="item_id")
    private String itemId;
    public static final String SERIALIZED_NAME_LAST_UPDATED_TIME = "last_updated_time";
    @SerializedName(value="last_updated_time")
    private OffsetDateTime lastUpdatedTime;
    public static final String SERIALIZED_NAME_INSTITUTION_ID = "institution_id";
    @SerializedName(value="institution_id")
    private String institutionId;
    public static final String SERIALIZED_NAME_INSTITUTION_NAME = "institution_name";
    @SerializedName(value="institution_name")
    private String institutionName;
    public static final String SERIALIZED_NAME_BANK_EMPLOYMENTS = "bank_employments";
    @SerializedName(value="bank_employments")
    private List<CreditBankEmployment> bankEmployments = new ArrayList<CreditBankEmployment>();
    public static final String SERIALIZED_NAME_BANK_EMPLOYMENT_ACCOUNTS = "bank_employment_accounts";
    @SerializedName(value="bank_employment_accounts")
    private List<CreditBankIncomeAccount> bankEmploymentAccounts = new ArrayList<CreditBankIncomeAccount>();

    public CreditBankEmploymentItem itemId(String itemId) {
        this.itemId = itemId;
        return this;
    }

    @ApiModelProperty(required=true, value="The unique identifier for the Item.")
    public String getItemId() {
        return this.itemId;
    }

    public void setItemId(String itemId) {
        this.itemId = itemId;
    }

    public CreditBankEmploymentItem lastUpdatedTime(OffsetDateTime lastUpdatedTime) {
        this.lastUpdatedTime = lastUpdatedTime;
        return this;
    }

    @ApiModelProperty(required=true, value="The time when this Item's data was last retrieved from the financial institution, in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format (e.g. \"2018-04-12T03:32:11Z\").")
    public OffsetDateTime getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public void setLastUpdatedTime(OffsetDateTime lastUpdatedTime) {
        this.lastUpdatedTime = lastUpdatedTime;
    }

    public CreditBankEmploymentItem institutionId(String institutionId) {
        this.institutionId = institutionId;
        return this;
    }

    @ApiModelProperty(required=true, value="The unique identifier of the institution associated with the Item.")
    public String getInstitutionId() {
        return this.institutionId;
    }

    public void setInstitutionId(String institutionId) {
        this.institutionId = institutionId;
    }

    public CreditBankEmploymentItem institutionName(String institutionName) {
        this.institutionName = institutionName;
        return this;
    }

    @ApiModelProperty(required=true, value="The name of the institution associated with the Item.")
    public String getInstitutionName() {
        return this.institutionName;
    }

    public void setInstitutionName(String institutionName) {
        this.institutionName = institutionName;
    }

    public CreditBankEmploymentItem bankEmployments(List<CreditBankEmployment> bankEmployments) {
        this.bankEmployments = bankEmployments;
        return this;
    }

    public CreditBankEmploymentItem addBankEmploymentsItem(CreditBankEmployment bankEmploymentsItem) {
        this.bankEmployments.add(bankEmploymentsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="The bank employment information for this Item. Each entry in the array is a different employer found.")
    public List<CreditBankEmployment> getBankEmployments() {
        return this.bankEmployments;
    }

    public void setBankEmployments(List<CreditBankEmployment> bankEmployments) {
        this.bankEmployments = bankEmployments;
    }

    public CreditBankEmploymentItem bankEmploymentAccounts(List<CreditBankIncomeAccount> bankEmploymentAccounts) {
        this.bankEmploymentAccounts = bankEmploymentAccounts;
        return this;
    }

    public CreditBankEmploymentItem addBankEmploymentAccountsItem(CreditBankIncomeAccount bankEmploymentAccountsItem) {
        this.bankEmploymentAccounts.add(bankEmploymentAccountsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="The Item's accounts that have Bank Employment data.")
    public List<CreditBankIncomeAccount> getBankEmploymentAccounts() {
        return this.bankEmploymentAccounts;
    }

    public void setBankEmploymentAccounts(List<CreditBankIncomeAccount> bankEmploymentAccounts) {
        this.bankEmploymentAccounts = bankEmploymentAccounts;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreditBankEmploymentItem creditBankEmploymentItem = (CreditBankEmploymentItem)o;
        return Objects.equals(this.itemId, creditBankEmploymentItem.itemId) && Objects.equals(this.lastUpdatedTime, creditBankEmploymentItem.lastUpdatedTime) && Objects.equals(this.institutionId, creditBankEmploymentItem.institutionId) && Objects.equals(this.institutionName, creditBankEmploymentItem.institutionName) && Objects.equals(this.bankEmployments, creditBankEmploymentItem.bankEmployments) && Objects.equals(this.bankEmploymentAccounts, creditBankEmploymentItem.bankEmploymentAccounts);
    }

    public int hashCode() {
        return Objects.hash(this.itemId, this.lastUpdatedTime, this.institutionId, this.institutionName, this.bankEmployments, this.bankEmploymentAccounts);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreditBankEmploymentItem {\n");
        sb.append("    itemId: ").append(this.toIndentedString(this.itemId)).append("\n");
        sb.append("    lastUpdatedTime: ").append(this.toIndentedString(this.lastUpdatedTime)).append("\n");
        sb.append("    institutionId: ").append(this.toIndentedString(this.institutionId)).append("\n");
        sb.append("    institutionName: ").append(this.toIndentedString(this.institutionName)).append("\n");
        sb.append("    bankEmployments: ").append(this.toIndentedString(this.bankEmployments)).append("\n");
        sb.append("    bankEmploymentAccounts: ").append(this.toIndentedString(this.bankEmploymentAccounts)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

