/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.CreditBankEmploymentItem;
import com.plaid.client.model.CreditBankEmploymentWarning;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="The report of the Bank Employment data for an end user.")
public class CreditBankEmploymentReport {
    public static final String SERIALIZED_NAME_BANK_EMPLOYMENT_REPORT_ID = "bank_employment_report_id";
    @SerializedName(value="bank_employment_report_id")
    private String bankEmploymentReportId;
    public static final String SERIALIZED_NAME_GENERATED_TIME = "generated_time";
    @SerializedName(value="generated_time")
    private OffsetDateTime generatedTime;
    public static final String SERIALIZED_NAME_DAYS_REQUESTED = "days_requested";
    @SerializedName(value="days_requested")
    private Integer daysRequested;
    public static final String SERIALIZED_NAME_ITEMS = "items";
    @SerializedName(value="items")
    private List<CreditBankEmploymentItem> items = new ArrayList<CreditBankEmploymentItem>();
    public static final String SERIALIZED_NAME_WARNINGS = "warnings";
    @SerializedName(value="warnings")
    private List<CreditBankEmploymentWarning> warnings = new ArrayList<CreditBankEmploymentWarning>();

    public CreditBankEmploymentReport bankEmploymentReportId(String bankEmploymentReportId) {
        this.bankEmploymentReportId = bankEmploymentReportId;
        return this;
    }

    @ApiModelProperty(required=true, value="The unique identifier associated with the Bank Employment Report.")
    public String getBankEmploymentReportId() {
        return this.bankEmploymentReportId;
    }

    public void setBankEmploymentReportId(String bankEmploymentReportId) {
        this.bankEmploymentReportId = bankEmploymentReportId;
    }

    public CreditBankEmploymentReport generatedTime(OffsetDateTime generatedTime) {
        this.generatedTime = generatedTime;
        return this;
    }

    @ApiModelProperty(required=true, value="The time when the Bank Employment Report was generated, in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format (e.g. \"2018-04-12T03:32:11Z\").")
    public OffsetDateTime getGeneratedTime() {
        return this.generatedTime;
    }

    public void setGeneratedTime(OffsetDateTime generatedTime) {
        this.generatedTime = generatedTime;
    }

    public CreditBankEmploymentReport daysRequested(Integer daysRequested) {
        this.daysRequested = daysRequested;
        return this;
    }

    @ApiModelProperty(required=true, value="The number of days requested by the customer for the Bank Employment Report.")
    public Integer getDaysRequested() {
        return this.daysRequested;
    }

    public void setDaysRequested(Integer daysRequested) {
        this.daysRequested = daysRequested;
    }

    public CreditBankEmploymentReport items(List<CreditBankEmploymentItem> items) {
        this.items = items;
        return this;
    }

    public CreditBankEmploymentReport addItemsItem(CreditBankEmploymentItem itemsItem) {
        this.items.add(itemsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="The list of Items in the report along with the associated metadata about the Item.")
    public List<CreditBankEmploymentItem> getItems() {
        return this.items;
    }

    public void setItems(List<CreditBankEmploymentItem> items) {
        this.items = items;
    }

    public CreditBankEmploymentReport warnings(List<CreditBankEmploymentWarning> warnings) {
        this.warnings = warnings;
        return this;
    }

    public CreditBankEmploymentReport addWarningsItem(CreditBankEmploymentWarning warningsItem) {
        this.warnings.add(warningsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="If data from the Bank Employment report was unable to be retrieved, the warnings will contain information about the error that caused the data to be incomplete.")
    public List<CreditBankEmploymentWarning> getWarnings() {
        return this.warnings;
    }

    public void setWarnings(List<CreditBankEmploymentWarning> warnings) {
        this.warnings = warnings;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreditBankEmploymentReport creditBankEmploymentReport = (CreditBankEmploymentReport)o;
        return Objects.equals(this.bankEmploymentReportId, creditBankEmploymentReport.bankEmploymentReportId) && Objects.equals(this.generatedTime, creditBankEmploymentReport.generatedTime) && Objects.equals(this.daysRequested, creditBankEmploymentReport.daysRequested) && Objects.equals(this.items, creditBankEmploymentReport.items) && Objects.equals(this.warnings, creditBankEmploymentReport.warnings);
    }

    public int hashCode() {
        return Objects.hash(this.bankEmploymentReportId, this.generatedTime, this.daysRequested, this.items, this.warnings);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreditBankEmploymentReport {\n");
        sb.append("    bankEmploymentReportId: ").append(this.toIndentedString(this.bankEmploymentReportId)).append("\n");
        sb.append("    generatedTime: ").append(this.toIndentedString(this.generatedTime)).append("\n");
        sb.append("    daysRequested: ").append(this.toIndentedString(this.daysRequested)).append("\n");
        sb.append("    items: ").append(this.toIndentedString(this.items)).append("\n");
        sb.append("    warnings: ").append(this.toIndentedString(this.warnings)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

