/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.CreditBankIncomeErrorType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="An error object and associated `item_id` used to identify a specific Item and error when a batch operation operating on multiple Items has encountered an error in one of the Items.")
public class CreditBankIncomeCause {
    public static final String SERIALIZED_NAME_ERROR_TYPE = "error_type";
    @SerializedName(value="error_type")
    private CreditBankIncomeErrorType errorType;
    public static final String SERIALIZED_NAME_ERROR_CODE = "error_code";
    @SerializedName(value="error_code")
    private String errorCode;
    public static final String SERIALIZED_NAME_ERROR_MESSAGE = "error_message";
    @SerializedName(value="error_message")
    private String errorMessage;
    public static final String SERIALIZED_NAME_DISPLAY_MESSAGE = "display_message";
    @SerializedName(value="display_message")
    private String displayMessage;
    public static final String SERIALIZED_NAME_ITEM_ID = "item_id";
    @SerializedName(value="item_id")
    private String itemId;

    public CreditBankIncomeCause errorType(CreditBankIncomeErrorType errorType) {
        this.errorType = errorType;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public CreditBankIncomeErrorType getErrorType() {
        return this.errorType;
    }

    public void setErrorType(CreditBankIncomeErrorType errorType) {
        this.errorType = errorType;
    }

    public CreditBankIncomeCause errorCode(String errorCode) {
        this.errorCode = errorCode;
        return this;
    }

    @ApiModelProperty(required=true, value="We use standard HTTP response codes for success and failure notifications, and our errors are further classified by `error_type`. In general, 200 HTTP codes correspond to success, 40X codes are for developer- or user-related failures, and 50X codes are for Plaid-related issues. Error fields will be `null` if no error has occurred.")
    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public CreditBankIncomeCause errorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        return this;
    }

    @ApiModelProperty(required=true, value="A developer-friendly representation of the error code. This may change over time and is not safe for programmatic use.")
    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public CreditBankIncomeCause displayMessage(String displayMessage) {
        this.displayMessage = displayMessage;
        return this;
    }

    @ApiModelProperty(required=true, value="A user-friendly representation of the error code. null if the error is not related to user action. This may change over time and is not safe for programmatic use.")
    public String getDisplayMessage() {
        return this.displayMessage;
    }

    public void setDisplayMessage(String displayMessage) {
        this.displayMessage = displayMessage;
    }

    public CreditBankIncomeCause itemId(String itemId) {
        this.itemId = itemId;
        return this;
    }

    @ApiModelProperty(required=true, value="The `item_id` of the Item associated with this warning.")
    public String getItemId() {
        return this.itemId;
    }

    public void setItemId(String itemId) {
        this.itemId = itemId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreditBankIncomeCause creditBankIncomeCause = (CreditBankIncomeCause)o;
        return Objects.equals((Object)this.errorType, (Object)creditBankIncomeCause.errorType) && Objects.equals(this.errorCode, creditBankIncomeCause.errorCode) && Objects.equals(this.errorMessage, creditBankIncomeCause.errorMessage) && Objects.equals(this.displayMessage, creditBankIncomeCause.displayMessage) && Objects.equals(this.itemId, creditBankIncomeCause.itemId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.errorType, this.errorCode, this.errorMessage, this.displayMessage, this.itemId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreditBankIncomeCause {\n");
        sb.append("    errorType: ").append(this.toIndentedString((Object)this.errorType)).append("\n");
        sb.append("    errorCode: ").append(this.toIndentedString(this.errorCode)).append("\n");
        sb.append("    errorMessage: ").append(this.toIndentedString(this.errorMessage)).append("\n");
        sb.append("    displayMessage: ").append(this.toIndentedString(this.displayMessage)).append("\n");
        sb.append("    itemId: ").append(this.toIndentedString(this.itemId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

