/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.CreditAmountWithCurrency;
import com.plaid.client.model.CreditBankIncomeTransaction;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The end user's monthly summary for the income source(s).")
public class CreditBankIncomeHistoricalSummary {
    public static final String SERIALIZED_NAME_TOTAL_AMOUNT = "total_amount";
    @SerializedName(value="total_amount")
    private Double totalAmount;
    public static final String SERIALIZED_NAME_ISO_CURRENCY_CODE = "iso_currency_code";
    @SerializedName(value="iso_currency_code")
    private String isoCurrencyCode;
    public static final String SERIALIZED_NAME_UNOFFICIAL_CURRENCY_CODE = "unofficial_currency_code";
    @SerializedName(value="unofficial_currency_code")
    private String unofficialCurrencyCode;
    public static final String SERIALIZED_NAME_TOTAL_AMOUNTS = "total_amounts";
    @SerializedName(value="total_amounts")
    private List<CreditAmountWithCurrency> totalAmounts = null;
    public static final String SERIALIZED_NAME_START_DATE = "start_date";
    @SerializedName(value="start_date")
    private LocalDate startDate;
    public static final String SERIALIZED_NAME_END_DATE = "end_date";
    @SerializedName(value="end_date")
    private LocalDate endDate;
    public static final String SERIALIZED_NAME_TRANSACTIONS = "transactions";
    @SerializedName(value="transactions")
    private List<CreditBankIncomeTransaction> transactions = null;

    public CreditBankIncomeHistoricalSummary totalAmount(Double totalAmount) {
        this.totalAmount = totalAmount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Total amount of earnings for the income source(s) of the user for the month in the summary. This may return an incorrect value if the summary includes income sources in multiple currencies. Please use [`total_amounts`](https://plaid.com/docs/api/products/income/#credit-bank_income-get-response-bank-income-items-bank-income-sources-historical-summary-total-amounts) instead.")
    public Double getTotalAmount() {
        return this.totalAmount;
    }

    public void setTotalAmount(Double totalAmount) {
        this.totalAmount = totalAmount;
    }

    public CreditBankIncomeHistoricalSummary isoCurrencyCode(String isoCurrencyCode) {
        this.isoCurrencyCode = isoCurrencyCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The ISO 4217 currency code of the amount or balance. Please use [`total_amounts`](https://plaid.com/docs/api/products/income/#credit-bank_income-get-response-bank-income-items-bank-income-sources-historical-summary-total-amounts) instead.")
    public String getIsoCurrencyCode() {
        return this.isoCurrencyCode;
    }

    public void setIsoCurrencyCode(String isoCurrencyCode) {
        this.isoCurrencyCode = isoCurrencyCode;
    }

    public CreditBankIncomeHistoricalSummary unofficialCurrencyCode(String unofficialCurrencyCode) {
        this.unofficialCurrencyCode = unofficialCurrencyCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The unofficial currency code associated with the amount or balance. Always `null` if `iso_currency_code` is non-null. Unofficial currency codes are used for currencies that do not have official ISO currency codes, such as cryptocurrencies and the currencies of certain countries. Please use [`total_amounts`](https://plaid.com/docs/api/products/income/#credit-bank_income-get-response-bank-income-items-bank-income-sources-historical-summary-total-amounts) instead.")
    public String getUnofficialCurrencyCode() {
        return this.unofficialCurrencyCode;
    }

    public void setUnofficialCurrencyCode(String unofficialCurrencyCode) {
        this.unofficialCurrencyCode = unofficialCurrencyCode;
    }

    public CreditBankIncomeHistoricalSummary totalAmounts(List<CreditAmountWithCurrency> totalAmounts) {
        this.totalAmounts = totalAmounts;
        return this;
    }

    public CreditBankIncomeHistoricalSummary addTotalAmountsItem(CreditAmountWithCurrency totalAmountsItem) {
        if (this.totalAmounts == null) {
            this.totalAmounts = new ArrayList<CreditAmountWithCurrency>();
        }
        this.totalAmounts.add(totalAmountsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Total amount of earnings for the income source(s) of the user for the month in the summary. This can contain multiple amounts, with each amount denominated in one unique currency.")
    public List<CreditAmountWithCurrency> getTotalAmounts() {
        return this.totalAmounts;
    }

    public void setTotalAmounts(List<CreditAmountWithCurrency> totalAmounts) {
        this.totalAmounts = totalAmounts;
    }

    public CreditBankIncomeHistoricalSummary startDate(LocalDate startDate) {
        this.startDate = startDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The start date of the period covered in this monthly summary. This date will be the first day of the month, unless the month being covered is a partial month because it is the first month included in the summary and the date range being requested does not begin with the first day of the month. The date will be returned in an ISO 8601 format (YYYY-MM-DD).")
    public LocalDate getStartDate() {
        return this.startDate;
    }

    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    public CreditBankIncomeHistoricalSummary endDate(LocalDate endDate) {
        this.endDate = endDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The end date of the period included in this monthly summary. This date will be the last day of the month, unless the month being covered is a partial month because it is the last month included in the summary and the date range being requested does not end with the last day of the month. The date will be returned in an ISO 8601 format (YYYY-MM-DD).")
    public LocalDate getEndDate() {
        return this.endDate;
    }

    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    public CreditBankIncomeHistoricalSummary transactions(List<CreditBankIncomeTransaction> transactions) {
        this.transactions = transactions;
        return this;
    }

    public CreditBankIncomeHistoricalSummary addTransactionsItem(CreditBankIncomeTransaction transactionsItem) {
        if (this.transactions == null) {
            this.transactions = new ArrayList<CreditBankIncomeTransaction>();
        }
        this.transactions.add(transactionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public List<CreditBankIncomeTransaction> getTransactions() {
        return this.transactions;
    }

    public void setTransactions(List<CreditBankIncomeTransaction> transactions) {
        this.transactions = transactions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreditBankIncomeHistoricalSummary creditBankIncomeHistoricalSummary = (CreditBankIncomeHistoricalSummary)o;
        return Objects.equals(this.totalAmount, creditBankIncomeHistoricalSummary.totalAmount) && Objects.equals(this.isoCurrencyCode, creditBankIncomeHistoricalSummary.isoCurrencyCode) && Objects.equals(this.unofficialCurrencyCode, creditBankIncomeHistoricalSummary.unofficialCurrencyCode) && Objects.equals(this.totalAmounts, creditBankIncomeHistoricalSummary.totalAmounts) && Objects.equals(this.startDate, creditBankIncomeHistoricalSummary.startDate) && Objects.equals(this.endDate, creditBankIncomeHistoricalSummary.endDate) && Objects.equals(this.transactions, creditBankIncomeHistoricalSummary.transactions);
    }

    public int hashCode() {
        return Objects.hash(this.totalAmount, this.isoCurrencyCode, this.unofficialCurrencyCode, this.totalAmounts, this.startDate, this.endDate, this.transactions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreditBankIncomeHistoricalSummary {\n");
        sb.append("    totalAmount: ").append(this.toIndentedString(this.totalAmount)).append("\n");
        sb.append("    isoCurrencyCode: ").append(this.toIndentedString(this.isoCurrencyCode)).append("\n");
        sb.append("    unofficialCurrencyCode: ").append(this.toIndentedString(this.unofficialCurrencyCode)).append("\n");
        sb.append("    totalAmounts: ").append(this.toIndentedString(this.totalAmounts)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    transactions: ").append(this.toIndentedString(this.transactions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

