/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.CreditBankIncomeAccount;
import com.plaid.client.model.CreditBankIncomeSource;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The details and metadata for an end user's Item.")
public class CreditBankIncomeItem {
    public static final String SERIALIZED_NAME_BANK_INCOME_ACCOUNTS = "bank_income_accounts";
    @SerializedName(value="bank_income_accounts")
    private List<CreditBankIncomeAccount> bankIncomeAccounts = null;
    public static final String SERIALIZED_NAME_BANK_INCOME_SOURCES = "bank_income_sources";
    @SerializedName(value="bank_income_sources")
    private List<CreditBankIncomeSource> bankIncomeSources = null;
    public static final String SERIALIZED_NAME_LAST_UPDATED_TIME = "last_updated_time";
    @SerializedName(value="last_updated_time")
    private OffsetDateTime lastUpdatedTime;
    public static final String SERIALIZED_NAME_INSTITUTION_ID = "institution_id";
    @SerializedName(value="institution_id")
    private String institutionId;
    public static final String SERIALIZED_NAME_INSTITUTION_NAME = "institution_name";
    @SerializedName(value="institution_name")
    private String institutionName;
    public static final String SERIALIZED_NAME_ITEM_ID = "item_id";
    @SerializedName(value="item_id")
    private String itemId;

    public CreditBankIncomeItem bankIncomeAccounts(List<CreditBankIncomeAccount> bankIncomeAccounts) {
        this.bankIncomeAccounts = bankIncomeAccounts;
        return this;
    }

    public CreditBankIncomeItem addBankIncomeAccountsItem(CreditBankIncomeAccount bankIncomeAccountsItem) {
        if (this.bankIncomeAccounts == null) {
            this.bankIncomeAccounts = new ArrayList<CreditBankIncomeAccount>();
        }
        this.bankIncomeAccounts.add(bankIncomeAccountsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The Item's accounts that have Bank Income data.")
    public List<CreditBankIncomeAccount> getBankIncomeAccounts() {
        return this.bankIncomeAccounts;
    }

    public void setBankIncomeAccounts(List<CreditBankIncomeAccount> bankIncomeAccounts) {
        this.bankIncomeAccounts = bankIncomeAccounts;
    }

    public CreditBankIncomeItem bankIncomeSources(List<CreditBankIncomeSource> bankIncomeSources) {
        this.bankIncomeSources = bankIncomeSources;
        return this;
    }

    public CreditBankIncomeItem addBankIncomeSourcesItem(CreditBankIncomeSource bankIncomeSourcesItem) {
        if (this.bankIncomeSources == null) {
            this.bankIncomeSources = new ArrayList<CreditBankIncomeSource>();
        }
        this.bankIncomeSources.add(bankIncomeSourcesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The income sources for this Item. Each entry in the array is a single income source.")
    public List<CreditBankIncomeSource> getBankIncomeSources() {
        return this.bankIncomeSources;
    }

    public void setBankIncomeSources(List<CreditBankIncomeSource> bankIncomeSources) {
        this.bankIncomeSources = bankIncomeSources;
    }

    public CreditBankIncomeItem lastUpdatedTime(OffsetDateTime lastUpdatedTime) {
        this.lastUpdatedTime = lastUpdatedTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The time when this Item's data was last retrieved from the financial institution.")
    public OffsetDateTime getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public void setLastUpdatedTime(OffsetDateTime lastUpdatedTime) {
        this.lastUpdatedTime = lastUpdatedTime;
    }

    public CreditBankIncomeItem institutionId(String institutionId) {
        this.institutionId = institutionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The unique identifier of the institution associated with the Item.")
    public String getInstitutionId() {
        return this.institutionId;
    }

    public void setInstitutionId(String institutionId) {
        this.institutionId = institutionId;
    }

    public CreditBankIncomeItem institutionName(String institutionName) {
        this.institutionName = institutionName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The name of the institution associated with the Item.")
    public String getInstitutionName() {
        return this.institutionName;
    }

    public void setInstitutionName(String institutionName) {
        this.institutionName = institutionName;
    }

    public CreditBankIncomeItem itemId(String itemId) {
        this.itemId = itemId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The unique identifier for the Item.")
    public String getItemId() {
        return this.itemId;
    }

    public void setItemId(String itemId) {
        this.itemId = itemId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreditBankIncomeItem creditBankIncomeItem = (CreditBankIncomeItem)o;
        return Objects.equals(this.bankIncomeAccounts, creditBankIncomeItem.bankIncomeAccounts) && Objects.equals(this.bankIncomeSources, creditBankIncomeItem.bankIncomeSources) && Objects.equals(this.lastUpdatedTime, creditBankIncomeItem.lastUpdatedTime) && Objects.equals(this.institutionId, creditBankIncomeItem.institutionId) && Objects.equals(this.institutionName, creditBankIncomeItem.institutionName) && Objects.equals(this.itemId, creditBankIncomeItem.itemId);
    }

    public int hashCode() {
        return Objects.hash(this.bankIncomeAccounts, this.bankIncomeSources, this.lastUpdatedTime, this.institutionId, this.institutionName, this.itemId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreditBankIncomeItem {\n");
        sb.append("    bankIncomeAccounts: ").append(this.toIndentedString(this.bankIncomeAccounts)).append("\n");
        sb.append("    bankIncomeSources: ").append(this.toIndentedString(this.bankIncomeSources)).append("\n");
        sb.append("    lastUpdatedTime: ").append(this.toIndentedString(this.lastUpdatedTime)).append("\n");
        sb.append("    institutionId: ").append(this.toIndentedString(this.institutionId)).append("\n");
        sb.append("    institutionName: ").append(this.toIndentedString(this.institutionName)).append("\n");
        sb.append("    itemId: ").append(this.toIndentedString(this.itemId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

