/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.CreditBankIncomeCategory;
import com.plaid.client.model.CreditBankIncomeHistoricalSummary;
import com.plaid.client.model.CreditBankIncomePayFrequency;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Detailed information for the income source.")
public class CreditBankIncomeSource {
    public static final String SERIALIZED_NAME_INCOME_SOURCE_ID = "income_source_id";
    @SerializedName(value="income_source_id")
    private String incomeSourceId;
    public static final String SERIALIZED_NAME_INCOME_DESCRIPTION = "income_description";
    @SerializedName(value="income_description")
    private String incomeDescription;
    public static final String SERIALIZED_NAME_INCOME_CATEGORY = "income_category";
    @SerializedName(value="income_category")
    private CreditBankIncomeCategory incomeCategory;
    public static final String SERIALIZED_NAME_ACCOUNT_ID = "account_id";
    @SerializedName(value="account_id")
    private String accountId;
    public static final String SERIALIZED_NAME_START_DATE = "start_date";
    @SerializedName(value="start_date")
    private LocalDate startDate;
    public static final String SERIALIZED_NAME_END_DATE = "end_date";
    @SerializedName(value="end_date")
    private LocalDate endDate;
    public static final String SERIALIZED_NAME_PAY_FREQUENCY = "pay_frequency";
    @SerializedName(value="pay_frequency")
    private CreditBankIncomePayFrequency payFrequency;
    public static final String SERIALIZED_NAME_TOTAL_AMOUNT = "total_amount";
    @SerializedName(value="total_amount")
    private Double totalAmount;
    public static final String SERIALIZED_NAME_TRANSACTION_COUNT = "transaction_count";
    @SerializedName(value="transaction_count")
    private Integer transactionCount;
    public static final String SERIALIZED_NAME_HISTORICAL_SUMMARY = "historical_summary";
    @SerializedName(value="historical_summary")
    private List<CreditBankIncomeHistoricalSummary> historicalSummary = null;

    public CreditBankIncomeSource incomeSourceId(String incomeSourceId) {
        this.incomeSourceId = incomeSourceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A unique identifier for an income source.")
    public String getIncomeSourceId() {
        return this.incomeSourceId;
    }

    public void setIncomeSourceId(String incomeSourceId) {
        this.incomeSourceId = incomeSourceId;
    }

    public CreditBankIncomeSource incomeDescription(String incomeDescription) {
        this.incomeDescription = incomeDescription;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The most common name or original description for the underlying income transactions.")
    public String getIncomeDescription() {
        return this.incomeDescription;
    }

    public void setIncomeDescription(String incomeDescription) {
        this.incomeDescription = incomeDescription;
    }

    public CreditBankIncomeSource incomeCategory(CreditBankIncomeCategory incomeCategory) {
        this.incomeCategory = incomeCategory;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public CreditBankIncomeCategory getIncomeCategory() {
        return this.incomeCategory;
    }

    public void setIncomeCategory(CreditBankIncomeCategory incomeCategory) {
        this.incomeCategory = incomeCategory;
    }

    public CreditBankIncomeSource accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Plaid's unique identifier for the account.")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public CreditBankIncomeSource startDate(LocalDate startDate) {
        this.startDate = startDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Minimum of all dates within the specific income sources in the user's bank account for days requested by the client. The date will be returned in an ISO 8601 format (YYYY-MM-DD).")
    public LocalDate getStartDate() {
        return this.startDate;
    }

    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    public CreditBankIncomeSource endDate(LocalDate endDate) {
        this.endDate = endDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Maximum of all dates within the specific income sources in the user\u2019s bank account for days requested by the client. The date will be returned in an ISO 8601 format (YYYY-MM-DD).")
    public LocalDate getEndDate() {
        return this.endDate;
    }

    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    public CreditBankIncomeSource payFrequency(CreditBankIncomePayFrequency payFrequency) {
        this.payFrequency = payFrequency;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public CreditBankIncomePayFrequency getPayFrequency() {
        return this.payFrequency;
    }

    public void setPayFrequency(CreditBankIncomePayFrequency payFrequency) {
        this.payFrequency = payFrequency;
    }

    public CreditBankIncomeSource totalAmount(Double totalAmount) {
        this.totalAmount = totalAmount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Total amount of earnings in the user\u2019s bank account for the specific income source for days requested by the client.")
    public Double getTotalAmount() {
        return this.totalAmount;
    }

    public void setTotalAmount(Double totalAmount) {
        this.totalAmount = totalAmount;
    }

    public CreditBankIncomeSource transactionCount(Integer transactionCount) {
        this.transactionCount = transactionCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Number of transactions for the income source within the start and end date.")
    public Integer getTransactionCount() {
        return this.transactionCount;
    }

    public void setTransactionCount(Integer transactionCount) {
        this.transactionCount = transactionCount;
    }

    public CreditBankIncomeSource historicalSummary(List<CreditBankIncomeHistoricalSummary> historicalSummary) {
        this.historicalSummary = historicalSummary;
        return this;
    }

    public CreditBankIncomeSource addHistoricalSummaryItem(CreditBankIncomeHistoricalSummary historicalSummaryItem) {
        if (this.historicalSummary == null) {
            this.historicalSummary = new ArrayList<CreditBankIncomeHistoricalSummary>();
        }
        this.historicalSummary.add(historicalSummaryItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public List<CreditBankIncomeHistoricalSummary> getHistoricalSummary() {
        return this.historicalSummary;
    }

    public void setHistoricalSummary(List<CreditBankIncomeHistoricalSummary> historicalSummary) {
        this.historicalSummary = historicalSummary;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreditBankIncomeSource creditBankIncomeSource = (CreditBankIncomeSource)o;
        return Objects.equals(this.incomeSourceId, creditBankIncomeSource.incomeSourceId) && Objects.equals(this.incomeDescription, creditBankIncomeSource.incomeDescription) && Objects.equals((Object)this.incomeCategory, (Object)creditBankIncomeSource.incomeCategory) && Objects.equals(this.accountId, creditBankIncomeSource.accountId) && Objects.equals(this.startDate, creditBankIncomeSource.startDate) && Objects.equals(this.endDate, creditBankIncomeSource.endDate) && Objects.equals((Object)this.payFrequency, (Object)creditBankIncomeSource.payFrequency) && Objects.equals(this.totalAmount, creditBankIncomeSource.totalAmount) && Objects.equals(this.transactionCount, creditBankIncomeSource.transactionCount) && Objects.equals(this.historicalSummary, creditBankIncomeSource.historicalSummary);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.incomeSourceId, this.incomeDescription, this.incomeCategory, this.accountId, this.startDate, this.endDate, this.payFrequency, this.totalAmount, this.transactionCount, this.historicalSummary});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreditBankIncomeSource {\n");
        sb.append("    incomeSourceId: ").append(this.toIndentedString(this.incomeSourceId)).append("\n");
        sb.append("    incomeDescription: ").append(this.toIndentedString(this.incomeDescription)).append("\n");
        sb.append("    incomeCategory: ").append(this.toIndentedString((Object)this.incomeCategory)).append("\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    payFrequency: ").append(this.toIndentedString((Object)this.payFrequency)).append("\n");
        sb.append("    totalAmount: ").append(this.toIndentedString(this.totalAmount)).append("\n");
        sb.append("    transactionCount: ").append(this.toIndentedString(this.transactionCount)).append("\n");
        sb.append("    historicalSummary: ").append(this.toIndentedString(this.historicalSummary)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

