/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.CreditAmountWithCurrency;
import com.plaid.client.model.CreditBankIncomeHistoricalSummary;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Summary for bank income across all income sources and items (max history of 730 days).")
public class CreditBankIncomeSummary {
    public static final String SERIALIZED_NAME_TOTAL_AMOUNT = "total_amount";
    @SerializedName(value="total_amount")
    private Double totalAmount;
    public static final String SERIALIZED_NAME_ISO_CURRENCY_CODE = "iso_currency_code";
    @SerializedName(value="iso_currency_code")
    private String isoCurrencyCode;
    public static final String SERIALIZED_NAME_UNOFFICIAL_CURRENCY_CODE = "unofficial_currency_code";
    @SerializedName(value="unofficial_currency_code")
    private String unofficialCurrencyCode;
    public static final String SERIALIZED_NAME_TOTAL_AMOUNTS = "total_amounts";
    @SerializedName(value="total_amounts")
    private List<CreditAmountWithCurrency> totalAmounts = null;
    public static final String SERIALIZED_NAME_START_DATE = "start_date";
    @SerializedName(value="start_date")
    private LocalDate startDate;
    public static final String SERIALIZED_NAME_END_DATE = "end_date";
    @SerializedName(value="end_date")
    private LocalDate endDate;
    public static final String SERIALIZED_NAME_INCOME_SOURCES_COUNT = "income_sources_count";
    @SerializedName(value="income_sources_count")
    private Integer incomeSourcesCount;
    public static final String SERIALIZED_NAME_INCOME_CATEGORIES_COUNT = "income_categories_count";
    @SerializedName(value="income_categories_count")
    private Integer incomeCategoriesCount;
    public static final String SERIALIZED_NAME_INCOME_TRANSACTIONS_COUNT = "income_transactions_count";
    @SerializedName(value="income_transactions_count")
    private Integer incomeTransactionsCount;
    public static final String SERIALIZED_NAME_HISTORICAL_SUMMARY = "historical_summary";
    @SerializedName(value="historical_summary")
    private List<CreditBankIncomeHistoricalSummary> historicalSummary = null;

    public CreditBankIncomeSummary totalAmount(Double totalAmount) {
        this.totalAmount = totalAmount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Total amount of earnings across all the income sources in the end user's Items for the days requested by the client. This may return an incorrect value if the summary includes income sources in multiple currencies. Please use [`total_amounts`](https://plaid.com/docs/api/products/income/#credit-bank_income-get-response-bank-income-bank-income-summary-total-amounts) instead.")
    public Double getTotalAmount() {
        return this.totalAmount;
    }

    public void setTotalAmount(Double totalAmount) {
        this.totalAmount = totalAmount;
    }

    public CreditBankIncomeSummary isoCurrencyCode(String isoCurrencyCode) {
        this.isoCurrencyCode = isoCurrencyCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The ISO 4217 currency code of the amount or balance. Please use [`total_amounts`](https://plaid.com/docs/api/products/income/#credit-bank_income-get-response-bank-income-bank-income-summary-total-amounts) instead.")
    public String getIsoCurrencyCode() {
        return this.isoCurrencyCode;
    }

    public void setIsoCurrencyCode(String isoCurrencyCode) {
        this.isoCurrencyCode = isoCurrencyCode;
    }

    public CreditBankIncomeSummary unofficialCurrencyCode(String unofficialCurrencyCode) {
        this.unofficialCurrencyCode = unofficialCurrencyCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The unofficial currency code associated with the amount or balance. Always `null` if `iso_currency_code` is non-null. Unofficial currency codes are used for currencies that do not have official ISO currency codes, such as cryptocurrencies and the currencies of certain countries. Please use [`total_amounts`](https://plaid.com/docs/api/products/income/#credit-bank_income-get-response-bank-income-bank-income-summary-total-amounts) instead.")
    public String getUnofficialCurrencyCode() {
        return this.unofficialCurrencyCode;
    }

    public void setUnofficialCurrencyCode(String unofficialCurrencyCode) {
        this.unofficialCurrencyCode = unofficialCurrencyCode;
    }

    public CreditBankIncomeSummary totalAmounts(List<CreditAmountWithCurrency> totalAmounts) {
        this.totalAmounts = totalAmounts;
        return this;
    }

    public CreditBankIncomeSummary addTotalAmountsItem(CreditAmountWithCurrency totalAmountsItem) {
        if (this.totalAmounts == null) {
            this.totalAmounts = new ArrayList<CreditAmountWithCurrency>();
        }
        this.totalAmounts.add(totalAmountsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Total amount of earnings across all the income sources in the end user's Items for the days requested by the client. This can contain multiple amounts, with each amount denominated in one unique currency.")
    public List<CreditAmountWithCurrency> getTotalAmounts() {
        return this.totalAmounts;
    }

    public void setTotalAmounts(List<CreditAmountWithCurrency> totalAmounts) {
        this.totalAmounts = totalAmounts;
    }

    public CreditBankIncomeSummary startDate(LocalDate startDate) {
        this.startDate = startDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The earliest date within the days requested in which all income sources identified by Plaid appear in a user's account. The date will be returned in an ISO 8601 format (YYYY-MM-DD).")
    public LocalDate getStartDate() {
        return this.startDate;
    }

    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    public CreditBankIncomeSummary endDate(LocalDate endDate) {
        this.endDate = endDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The latest date in which all income sources identified by Plaid appear in the user's account. The date will be returned in an ISO 8601 format (YYYY-MM-DD).")
    public LocalDate getEndDate() {
        return this.endDate;
    }

    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    public CreditBankIncomeSummary incomeSourcesCount(Integer incomeSourcesCount) {
        this.incomeSourcesCount = incomeSourcesCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Number of income sources per end user.")
    public Integer getIncomeSourcesCount() {
        return this.incomeSourcesCount;
    }

    public void setIncomeSourcesCount(Integer incomeSourcesCount) {
        this.incomeSourcesCount = incomeSourcesCount;
    }

    public CreditBankIncomeSummary incomeCategoriesCount(Integer incomeCategoriesCount) {
        this.incomeCategoriesCount = incomeCategoriesCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Number of income categories per end user.")
    public Integer getIncomeCategoriesCount() {
        return this.incomeCategoriesCount;
    }

    public void setIncomeCategoriesCount(Integer incomeCategoriesCount) {
        this.incomeCategoriesCount = incomeCategoriesCount;
    }

    public CreditBankIncomeSummary incomeTransactionsCount(Integer incomeTransactionsCount) {
        this.incomeTransactionsCount = incomeTransactionsCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Number of income transactions per end user.")
    public Integer getIncomeTransactionsCount() {
        return this.incomeTransactionsCount;
    }

    public void setIncomeTransactionsCount(Integer incomeTransactionsCount) {
        this.incomeTransactionsCount = incomeTransactionsCount;
    }

    public CreditBankIncomeSummary historicalSummary(List<CreditBankIncomeHistoricalSummary> historicalSummary) {
        this.historicalSummary = historicalSummary;
        return this;
    }

    public CreditBankIncomeSummary addHistoricalSummaryItem(CreditBankIncomeHistoricalSummary historicalSummaryItem) {
        if (this.historicalSummary == null) {
            this.historicalSummary = new ArrayList<CreditBankIncomeHistoricalSummary>();
        }
        this.historicalSummary.add(historicalSummaryItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public List<CreditBankIncomeHistoricalSummary> getHistoricalSummary() {
        return this.historicalSummary;
    }

    public void setHistoricalSummary(List<CreditBankIncomeHistoricalSummary> historicalSummary) {
        this.historicalSummary = historicalSummary;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreditBankIncomeSummary creditBankIncomeSummary = (CreditBankIncomeSummary)o;
        return Objects.equals(this.totalAmount, creditBankIncomeSummary.totalAmount) && Objects.equals(this.isoCurrencyCode, creditBankIncomeSummary.isoCurrencyCode) && Objects.equals(this.unofficialCurrencyCode, creditBankIncomeSummary.unofficialCurrencyCode) && Objects.equals(this.totalAmounts, creditBankIncomeSummary.totalAmounts) && Objects.equals(this.startDate, creditBankIncomeSummary.startDate) && Objects.equals(this.endDate, creditBankIncomeSummary.endDate) && Objects.equals(this.incomeSourcesCount, creditBankIncomeSummary.incomeSourcesCount) && Objects.equals(this.incomeCategoriesCount, creditBankIncomeSummary.incomeCategoriesCount) && Objects.equals(this.incomeTransactionsCount, creditBankIncomeSummary.incomeTransactionsCount) && Objects.equals(this.historicalSummary, creditBankIncomeSummary.historicalSummary);
    }

    public int hashCode() {
        return Objects.hash(this.totalAmount, this.isoCurrencyCode, this.unofficialCurrencyCode, this.totalAmounts, this.startDate, this.endDate, this.incomeSourcesCount, this.incomeCategoriesCount, this.incomeTransactionsCount, this.historicalSummary);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreditBankIncomeSummary {\n");
        sb.append("    totalAmount: ").append(this.toIndentedString(this.totalAmount)).append("\n");
        sb.append("    isoCurrencyCode: ").append(this.toIndentedString(this.isoCurrencyCode)).append("\n");
        sb.append("    unofficialCurrencyCode: ").append(this.toIndentedString(this.unofficialCurrencyCode)).append("\n");
        sb.append("    totalAmounts: ").append(this.toIndentedString(this.totalAmounts)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    incomeSourcesCount: ").append(this.toIndentedString(this.incomeSourcesCount)).append("\n");
        sb.append("    incomeCategoriesCount: ").append(this.toIndentedString(this.incomeCategoriesCount)).append("\n");
        sb.append("    incomeTransactionsCount: ").append(this.toIndentedString(this.incomeTransactionsCount)).append("\n");
        sb.append("    historicalSummary: ").append(this.toIndentedString(this.historicalSummary)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

