/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The transactions data for the end user's income source(s).")
public class CreditBankIncomeTransaction {
    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(value="amount")
    private Double amount;
    public static final String SERIALIZED_NAME_DATE = "date";
    @SerializedName(value="date")
    private LocalDate date;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_ORIGINAL_DESCRIPTION = "original_description";
    @SerializedName(value="original_description")
    private String originalDescription;
    public static final String SERIALIZED_NAME_PENDING = "pending";
    @SerializedName(value="pending")
    private Boolean pending;
    public static final String SERIALIZED_NAME_TRANSACTION_ID = "transaction_id";
    @SerializedName(value="transaction_id")
    private String transactionId;
    public static final String SERIALIZED_NAME_CHECK_NUMBER = "check_number";
    @SerializedName(value="check_number")
    private String checkNumber;
    public static final String SERIALIZED_NAME_ISO_CURRENCY_CODE = "iso_currency_code";
    @SerializedName(value="iso_currency_code")
    private String isoCurrencyCode;
    public static final String SERIALIZED_NAME_UNOFFICIAL_CURRENCY_CODE = "unofficial_currency_code";
    @SerializedName(value="unofficial_currency_code")
    private String unofficialCurrencyCode;

    public CreditBankIncomeTransaction amount(Double amount) {
        this.amount = amount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The settled value of the transaction, denominated in the transactions's currency as stated in `iso_currency_code` or `unofficial_currency_code`. Positive values when money moves out of the account; negative values when money moves in. For example, credit card purchases are positive; credit card payment, direct deposits, and refunds are negative.")
    public Double getAmount() {
        return this.amount;
    }

    public void setAmount(Double amount) {
        this.amount = amount;
    }

    public CreditBankIncomeTransaction date(LocalDate date) {
        this.date = date;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="For pending transactions, the date that the transaction occurred; for posted transactions, the date that the transaction posted. Both dates are returned in an ISO 8601 format (YYYY-MM-DD).")
    public LocalDate getDate() {
        return this.date;
    }

    public void setDate(LocalDate date) {
        this.date = date;
    }

    public CreditBankIncomeTransaction name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The merchant name or transaction description.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CreditBankIncomeTransaction originalDescription(String originalDescription) {
        this.originalDescription = originalDescription;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The string returned by the financial institution to describe the transaction.")
    public String getOriginalDescription() {
        return this.originalDescription;
    }

    public void setOriginalDescription(String originalDescription) {
        this.originalDescription = originalDescription;
    }

    public CreditBankIncomeTransaction pending(Boolean pending) {
        this.pending = pending;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="When true, identifies the transaction as pending or unsettled. Pending transaction details (name, type, amount, category ID) may change before they are settled.")
    public Boolean getPending() {
        return this.pending;
    }

    public void setPending(Boolean pending) {
        this.pending = pending;
    }

    public CreditBankIncomeTransaction transactionId(String transactionId) {
        this.transactionId = transactionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The unique ID of the transaction. Like all Plaid identifiers, the `transaction_id` is case sensitive.")
    public String getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public CreditBankIncomeTransaction checkNumber(String checkNumber) {
        this.checkNumber = checkNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The check number of the transaction. This field is only populated for check transactions.")
    public String getCheckNumber() {
        return this.checkNumber;
    }

    public void setCheckNumber(String checkNumber) {
        this.checkNumber = checkNumber;
    }

    public CreditBankIncomeTransaction isoCurrencyCode(String isoCurrencyCode) {
        this.isoCurrencyCode = isoCurrencyCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The ISO 4217 currency code of the amount or balance.")
    public String getIsoCurrencyCode() {
        return this.isoCurrencyCode;
    }

    public void setIsoCurrencyCode(String isoCurrencyCode) {
        this.isoCurrencyCode = isoCurrencyCode;
    }

    public CreditBankIncomeTransaction unofficialCurrencyCode(String unofficialCurrencyCode) {
        this.unofficialCurrencyCode = unofficialCurrencyCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The unofficial currency code associated with the amount or balance. Always `null` if `iso_currency_code` is non-null. Unofficial currency codes are used for currencies that do not have official ISO currency codes, such as cryptocurrencies and the currencies of certain countries.")
    public String getUnofficialCurrencyCode() {
        return this.unofficialCurrencyCode;
    }

    public void setUnofficialCurrencyCode(String unofficialCurrencyCode) {
        this.unofficialCurrencyCode = unofficialCurrencyCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreditBankIncomeTransaction creditBankIncomeTransaction = (CreditBankIncomeTransaction)o;
        return Objects.equals(this.amount, creditBankIncomeTransaction.amount) && Objects.equals(this.date, creditBankIncomeTransaction.date) && Objects.equals(this.name, creditBankIncomeTransaction.name) && Objects.equals(this.originalDescription, creditBankIncomeTransaction.originalDescription) && Objects.equals(this.pending, creditBankIncomeTransaction.pending) && Objects.equals(this.transactionId, creditBankIncomeTransaction.transactionId) && Objects.equals(this.checkNumber, creditBankIncomeTransaction.checkNumber) && Objects.equals(this.isoCurrencyCode, creditBankIncomeTransaction.isoCurrencyCode) && Objects.equals(this.unofficialCurrencyCode, creditBankIncomeTransaction.unofficialCurrencyCode);
    }

    public int hashCode() {
        return Objects.hash(this.amount, this.date, this.name, this.originalDescription, this.pending, this.transactionId, this.checkNumber, this.isoCurrencyCode, this.unofficialCurrencyCode);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreditBankIncomeTransaction {\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    date: ").append(this.toIndentedString(this.date)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    originalDescription: ").append(this.toIndentedString(this.originalDescription)).append("\n");
        sb.append("    pending: ").append(this.toIndentedString(this.pending)).append("\n");
        sb.append("    transactionId: ").append(this.toIndentedString(this.transactionId)).append("\n");
        sb.append("    checkNumber: ").append(this.toIndentedString(this.checkNumber)).append("\n");
        sb.append("    isoCurrencyCode: ").append(this.toIndentedString(this.isoCurrencyCode)).append("\n");
        sb.append("    unofficialCurrencyCode: ").append(this.toIndentedString(this.unofficialCurrencyCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

