/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="CreditBankIncomeWebhookUpdateRequest defines the request schema for `/credit/bank_income/webhook/update`.")
public class CreditBankIncomeWebhookUpdateRequest {
    public static final String SERIALIZED_NAME_CLIENT_ID = "client_id";
    @SerializedName(value="client_id")
    private String clientId;
    public static final String SERIALIZED_NAME_SECRET = "secret";
    @SerializedName(value="secret")
    private String secret;
    public static final String SERIALIZED_NAME_USER_TOKEN = "user_token";
    @SerializedName(value="user_token")
    private String userToken;
    public static final String SERIALIZED_NAME_ENABLE_WEBHOOKS = "enable_webhooks";
    @SerializedName(value="enable_webhooks")
    private Boolean enableWebhooks;

    public CreditBankIncomeWebhookUpdateRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public CreditBankIncomeWebhookUpdateRequest secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public CreditBankIncomeWebhookUpdateRequest userToken(String userToken) {
        this.userToken = userToken;
        return this;
    }

    @ApiModelProperty(required=true, value="The user token associated with the User data is being requested for.")
    public String getUserToken() {
        return this.userToken;
    }

    public void setUserToken(String userToken) {
        this.userToken = userToken;
    }

    public CreditBankIncomeWebhookUpdateRequest enableWebhooks(Boolean enableWebhooks) {
        this.enableWebhooks = enableWebhooks;
        return this;
    }

    @ApiModelProperty(required=true, value="Whether the user should be enabled for proactive webhook notifications when their income changes")
    public Boolean getEnableWebhooks() {
        return this.enableWebhooks;
    }

    public void setEnableWebhooks(Boolean enableWebhooks) {
        this.enableWebhooks = enableWebhooks;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreditBankIncomeWebhookUpdateRequest creditBankIncomeWebhookUpdateRequest = (CreditBankIncomeWebhookUpdateRequest)o;
        return Objects.equals(this.clientId, creditBankIncomeWebhookUpdateRequest.clientId) && Objects.equals(this.secret, creditBankIncomeWebhookUpdateRequest.secret) && Objects.equals(this.userToken, creditBankIncomeWebhookUpdateRequest.userToken) && Objects.equals(this.enableWebhooks, creditBankIncomeWebhookUpdateRequest.enableWebhooks);
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.secret, this.userToken, this.enableWebhooks);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreditBankIncomeWebhookUpdateRequest {\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    userToken: ").append(this.toIndentedString(this.userToken)).append("\n");
        sb.append("    enableWebhooks: ").append(this.toIndentedString(this.enableWebhooks)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

