/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="An object containing data on the overall period of the statement.")
public class CreditBankStatementUploadBankAccountPeriod {
    public static final String SERIALIZED_NAME_START_DATE = "start_date";
    @SerializedName(value="start_date")
    private LocalDate startDate;
    public static final String SERIALIZED_NAME_END_DATE = "end_date";
    @SerializedName(value="end_date")
    private LocalDate endDate;
    public static final String SERIALIZED_NAME_STARTING_BALANCE = "starting_balance";
    @SerializedName(value="starting_balance")
    private Double startingBalance;
    public static final String SERIALIZED_NAME_ENDING_BALANCE = "ending_balance";
    @SerializedName(value="ending_balance")
    private Double endingBalance;

    public CreditBankStatementUploadBankAccountPeriod startDate(LocalDate startDate) {
        this.startDate = startDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The start date of the statement period in ISO 8601 format (YYYY-MM-DD).")
    public LocalDate getStartDate() {
        return this.startDate;
    }

    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    public CreditBankStatementUploadBankAccountPeriod endDate(LocalDate endDate) {
        this.endDate = endDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The end date of the statement period in ISO 8601 format (YYYY-MM-DD).")
    public LocalDate getEndDate() {
        return this.endDate;
    }

    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    public CreditBankStatementUploadBankAccountPeriod startingBalance(Double startingBalance) {
        this.startingBalance = startingBalance;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The starting balance of the bank account for the period.")
    public Double getStartingBalance() {
        return this.startingBalance;
    }

    public void setStartingBalance(Double startingBalance) {
        this.startingBalance = startingBalance;
    }

    public CreditBankStatementUploadBankAccountPeriod endingBalance(Double endingBalance) {
        this.endingBalance = endingBalance;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The ending balance of the bank account for the period.")
    public Double getEndingBalance() {
        return this.endingBalance;
    }

    public void setEndingBalance(Double endingBalance) {
        this.endingBalance = endingBalance;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreditBankStatementUploadBankAccountPeriod creditBankStatementUploadBankAccountPeriod = (CreditBankStatementUploadBankAccountPeriod)o;
        return Objects.equals(this.startDate, creditBankStatementUploadBankAccountPeriod.startDate) && Objects.equals(this.endDate, creditBankStatementUploadBankAccountPeriod.endDate) && Objects.equals(this.startingBalance, creditBankStatementUploadBankAccountPeriod.startingBalance) && Objects.equals(this.endingBalance, creditBankStatementUploadBankAccountPeriod.endingBalance);
    }

    public int hashCode() {
        return Objects.hash(this.startDate, this.endDate, this.startingBalance, this.endingBalance);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreditBankStatementUploadBankAccountPeriod {\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    startingBalance: ").append(this.toIndentedString(this.startingBalance)).append("\n");
        sb.append("    endingBalance: ").append(this.toIndentedString(this.endingBalance)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

