/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.CreditBankStatementUploadObject;
import com.plaid.client.model.PayrollItemStatus;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="An object containing information about the bank statement upload Item.")
public class CreditBankStatementUploadItem {
    public static final String SERIALIZED_NAME_ITEM_ID = "item_id";
    @SerializedName(value="item_id")
    private String itemId;
    public static final String SERIALIZED_NAME_BANK_STATEMENTS = "bank_statements";
    @SerializedName(value="bank_statements")
    private List<CreditBankStatementUploadObject> bankStatements = new ArrayList<CreditBankStatementUploadObject>();
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private PayrollItemStatus status;
    public static final String SERIALIZED_NAME_UPDATED_AT = "updated_at";
    @SerializedName(value="updated_at")
    private OffsetDateTime updatedAt;

    public CreditBankStatementUploadItem itemId(String itemId) {
        this.itemId = itemId;
        return this;
    }

    @ApiModelProperty(required=true, value="The `item_id` of the Item associated with this webhook, warning, or error")
    public String getItemId() {
        return this.itemId;
    }

    public void setItemId(String itemId) {
        this.itemId = itemId;
    }

    public CreditBankStatementUploadItem bankStatements(List<CreditBankStatementUploadObject> bankStatements) {
        this.bankStatements = bankStatements;
        return this;
    }

    public CreditBankStatementUploadItem addBankStatementsItem(CreditBankStatementUploadObject bankStatementsItem) {
        this.bankStatements.add(bankStatementsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public List<CreditBankStatementUploadObject> getBankStatements() {
        return this.bankStatements;
    }

    public void setBankStatements(List<CreditBankStatementUploadObject> bankStatements) {
        this.bankStatements = bankStatements;
    }

    public CreditBankStatementUploadItem status(PayrollItemStatus status) {
        this.status = status;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="")
    public PayrollItemStatus getStatus() {
        return this.status;
    }

    public void setStatus(PayrollItemStatus status) {
        this.status = status;
    }

    public CreditBankStatementUploadItem updatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="Timestamp in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format (YYYY-MM-DDTHH:mm:ssZ) indicating the last time that the Item was updated.")
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreditBankStatementUploadItem creditBankStatementUploadItem = (CreditBankStatementUploadItem)o;
        return Objects.equals(this.itemId, creditBankStatementUploadItem.itemId) && Objects.equals(this.bankStatements, creditBankStatementUploadItem.bankStatements) && Objects.equals(this.status, creditBankStatementUploadItem.status) && Objects.equals(this.updatedAt, creditBankStatementUploadItem.updatedAt);
    }

    public int hashCode() {
        return Objects.hash(this.itemId, this.bankStatements, this.status, this.updatedAt);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreditBankStatementUploadItem {\n");
        sb.append("    itemId: ").append(this.toIndentedString(this.itemId)).append("\n");
        sb.append("    bankStatements: ").append(this.toIndentedString(this.bankStatements)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

