/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.CreditBankStatementUploadBankAccount;
import com.plaid.client.model.CreditBankStatementUploadTransaction;
import com.plaid.client.model.CreditDocumentMetadata;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="An object containing data that has been parsed from a user-uploaded bank statement.")
public class CreditBankStatementUploadObject {
    public static final String SERIALIZED_NAME_TRANSACTIONS = "transactions";
    @SerializedName(value="transactions")
    private List<CreditBankStatementUploadTransaction> transactions = new ArrayList<CreditBankStatementUploadTransaction>();
    public static final String SERIALIZED_NAME_DOCUMENT_METADATA = "document_metadata";
    @SerializedName(value="document_metadata")
    private CreditDocumentMetadata documentMetadata;
    public static final String SERIALIZED_NAME_DOCUMENT_ID = "document_id";
    @SerializedName(value="document_id")
    private String documentId;
    public static final String SERIALIZED_NAME_BANK_ACCOUNTS = "bank_accounts";
    @SerializedName(value="bank_accounts")
    private List<CreditBankStatementUploadBankAccount> bankAccounts = new ArrayList<CreditBankStatementUploadBankAccount>();

    public CreditBankStatementUploadObject transactions(List<CreditBankStatementUploadTransaction> transactions) {
        this.transactions = transactions;
        return this;
    }

    public CreditBankStatementUploadObject addTransactionsItem(CreditBankStatementUploadTransaction transactionsItem) {
        this.transactions.add(transactionsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="An array of transactions appearing on the bank statement.")
    public List<CreditBankStatementUploadTransaction> getTransactions() {
        return this.transactions;
    }

    public void setTransactions(List<CreditBankStatementUploadTransaction> transactions) {
        this.transactions = transactions;
    }

    public CreditBankStatementUploadObject documentMetadata(CreditDocumentMetadata documentMetadata) {
        this.documentMetadata = documentMetadata;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public CreditDocumentMetadata getDocumentMetadata() {
        return this.documentMetadata;
    }

    public void setDocumentMetadata(CreditDocumentMetadata documentMetadata) {
        this.documentMetadata = documentMetadata;
    }

    public CreditBankStatementUploadObject documentId(String documentId) {
        this.documentId = documentId;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="An identifier of the document referenced by the document metadata.")
    public String getDocumentId() {
        return this.documentId;
    }

    public void setDocumentId(String documentId) {
        this.documentId = documentId;
    }

    public CreditBankStatementUploadObject bankAccounts(List<CreditBankStatementUploadBankAccount> bankAccounts) {
        this.bankAccounts = bankAccounts;
        return this;
    }

    public CreditBankStatementUploadObject addBankAccountsItem(CreditBankStatementUploadBankAccount bankAccountsItem) {
        this.bankAccounts.add(bankAccountsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="An array of bank accounts associated with the uploaded bank statement.")
    public List<CreditBankStatementUploadBankAccount> getBankAccounts() {
        return this.bankAccounts;
    }

    public void setBankAccounts(List<CreditBankStatementUploadBankAccount> bankAccounts) {
        this.bankAccounts = bankAccounts;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreditBankStatementUploadObject creditBankStatementUploadObject = (CreditBankStatementUploadObject)o;
        return Objects.equals(this.transactions, creditBankStatementUploadObject.transactions) && Objects.equals(this.documentMetadata, creditBankStatementUploadObject.documentMetadata) && Objects.equals(this.documentId, creditBankStatementUploadObject.documentId) && Objects.equals(this.bankAccounts, creditBankStatementUploadObject.bankAccounts);
    }

    public int hashCode() {
        return Objects.hash(this.transactions, this.documentMetadata, this.documentId, this.bankAccounts);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreditBankStatementUploadObject {\n");
        sb.append("    transactions: ").append(this.toIndentedString(this.transactions)).append("\n");
        sb.append("    documentMetadata: ").append(this.toIndentedString(this.documentMetadata)).append("\n");
        sb.append("    documentId: ").append(this.toIndentedString(this.documentId)).append("\n");
        sb.append("    bankAccounts: ").append(this.toIndentedString(this.bankAccounts)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

