/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="An object containing data about a transaction appearing on a user-uploaded bank statement.")
public class CreditBankStatementUploadTransaction {
    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(value="amount")
    private Double amount;
    public static final String SERIALIZED_NAME_DATE = "date";
    @SerializedName(value="date")
    private LocalDate date;
    public static final String SERIALIZED_NAME_ORIGINAL_DESCRIPTION = "original_description";
    @SerializedName(value="original_description")
    private String originalDescription;
    public static final String SERIALIZED_NAME_ACCOUNT_ID = "account_id";
    @SerializedName(value="account_id")
    private String accountId;

    public CreditBankStatementUploadTransaction amount(Double amount) {
        this.amount = amount;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The value of the transaction. A negative amount indicates that money moved into the account (such as a paycheck being deposited).")
    public Double getAmount() {
        return this.amount;
    }

    public void setAmount(Double amount) {
        this.amount = amount;
    }

    public CreditBankStatementUploadTransaction date(LocalDate date) {
        this.date = date;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The date of when the transaction was made, in ISO 8601 format (YYYY-MM-DD).")
    public LocalDate getDate() {
        return this.date;
    }

    public void setDate(LocalDate date) {
        this.date = date;
    }

    public CreditBankStatementUploadTransaction originalDescription(String originalDescription) {
        this.originalDescription = originalDescription;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The raw description of the transaction as it appears on the bank statement.")
    public String getOriginalDescription() {
        return this.originalDescription;
    }

    public void setOriginalDescription(String originalDescription) {
        this.originalDescription = originalDescription;
    }

    public CreditBankStatementUploadTransaction accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The unique id of the bank account that this transaction occurs in")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreditBankStatementUploadTransaction creditBankStatementUploadTransaction = (CreditBankStatementUploadTransaction)o;
        return Objects.equals(this.amount, creditBankStatementUploadTransaction.amount) && Objects.equals(this.date, creditBankStatementUploadTransaction.date) && Objects.equals(this.originalDescription, creditBankStatementUploadTransaction.originalDescription) && Objects.equals(this.accountId, creditBankStatementUploadTransaction.accountId);
    }

    public int hashCode() {
        return Objects.hash(this.amount, this.date, this.originalDescription, this.accountId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreditBankStatementUploadTransaction {\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    date: ").append(this.toIndentedString(this.date)).append("\n");
        sb.append("    originalDescription: ").append(this.toIndentedString(this.originalDescription)).append("\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

