/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.APR;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="An object representing a credit card account.")
public class CreditCardLiability {
    public static final String SERIALIZED_NAME_ACCOUNT_ID = "account_id";
    @SerializedName(value="account_id")
    private String accountId;
    public static final String SERIALIZED_NAME_APRS = "aprs";
    @SerializedName(value="aprs")
    private List<APR> aprs = new ArrayList<APR>();
    public static final String SERIALIZED_NAME_IS_OVERDUE = "is_overdue";
    @SerializedName(value="is_overdue")
    private Boolean isOverdue;
    public static final String SERIALIZED_NAME_LAST_PAYMENT_AMOUNT = "last_payment_amount";
    @SerializedName(value="last_payment_amount")
    private Double lastPaymentAmount;
    public static final String SERIALIZED_NAME_LAST_PAYMENT_DATE = "last_payment_date";
    @SerializedName(value="last_payment_date")
    private LocalDate lastPaymentDate;
    public static final String SERIALIZED_NAME_LAST_STATEMENT_ISSUE_DATE = "last_statement_issue_date";
    @SerializedName(value="last_statement_issue_date")
    private LocalDate lastStatementIssueDate;
    public static final String SERIALIZED_NAME_LAST_STATEMENT_BALANCE = "last_statement_balance";
    @SerializedName(value="last_statement_balance")
    private Double lastStatementBalance;
    public static final String SERIALIZED_NAME_MINIMUM_PAYMENT_AMOUNT = "minimum_payment_amount";
    @SerializedName(value="minimum_payment_amount")
    private Double minimumPaymentAmount;
    public static final String SERIALIZED_NAME_NEXT_PAYMENT_DUE_DATE = "next_payment_due_date";
    @SerializedName(value="next_payment_due_date")
    private LocalDate nextPaymentDueDate;

    public CreditCardLiability accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The ID of the account that this liability belongs to.")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public CreditCardLiability aprs(List<APR> aprs) {
        this.aprs = aprs;
        return this;
    }

    public CreditCardLiability addAprsItem(APR aprsItem) {
        this.aprs.add(aprsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="The various interest rates that apply to the account. APR information is not provided by all card issuers; if APR data is not available, this array will be empty.")
    public List<APR> getAprs() {
        return this.aprs;
    }

    public void setAprs(List<APR> aprs) {
        this.aprs = aprs;
    }

    public CreditCardLiability isOverdue(Boolean isOverdue) {
        this.isOverdue = isOverdue;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="true if a payment is currently overdue. Availability for this field is limited.")
    public Boolean getIsOverdue() {
        return this.isOverdue;
    }

    public void setIsOverdue(Boolean isOverdue) {
        this.isOverdue = isOverdue;
    }

    public CreditCardLiability lastPaymentAmount(Double lastPaymentAmount) {
        this.lastPaymentAmount = lastPaymentAmount;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The amount of the last payment.")
    public Double getLastPaymentAmount() {
        return this.lastPaymentAmount;
    }

    public void setLastPaymentAmount(Double lastPaymentAmount) {
        this.lastPaymentAmount = lastPaymentAmount;
    }

    public CreditCardLiability lastPaymentDate(LocalDate lastPaymentDate) {
        this.lastPaymentDate = lastPaymentDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The date of the last payment. Dates are returned in an [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format (YYYY-MM-DD). Availability for this field is limited.")
    public LocalDate getLastPaymentDate() {
        return this.lastPaymentDate;
    }

    public void setLastPaymentDate(LocalDate lastPaymentDate) {
        this.lastPaymentDate = lastPaymentDate;
    }

    public CreditCardLiability lastStatementIssueDate(LocalDate lastStatementIssueDate) {
        this.lastStatementIssueDate = lastStatementIssueDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The date of the last statement. Dates are returned in an [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format (YYYY-MM-DD).")
    public LocalDate getLastStatementIssueDate() {
        return this.lastStatementIssueDate;
    }

    public void setLastStatementIssueDate(LocalDate lastStatementIssueDate) {
        this.lastStatementIssueDate = lastStatementIssueDate;
    }

    public CreditCardLiability lastStatementBalance(Double lastStatementBalance) {
        this.lastStatementBalance = lastStatementBalance;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The total amount owed as of the last statement issued")
    public Double getLastStatementBalance() {
        return this.lastStatementBalance;
    }

    public void setLastStatementBalance(Double lastStatementBalance) {
        this.lastStatementBalance = lastStatementBalance;
    }

    public CreditCardLiability minimumPaymentAmount(Double minimumPaymentAmount) {
        this.minimumPaymentAmount = minimumPaymentAmount;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The minimum payment due for the next billing cycle.")
    public Double getMinimumPaymentAmount() {
        return this.minimumPaymentAmount;
    }

    public void setMinimumPaymentAmount(Double minimumPaymentAmount) {
        this.minimumPaymentAmount = minimumPaymentAmount;
    }

    public CreditCardLiability nextPaymentDueDate(LocalDate nextPaymentDueDate) {
        this.nextPaymentDueDate = nextPaymentDueDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The due date for the next payment. The due date is `null` if a payment is not expected. Dates are returned in an [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format (YYYY-MM-DD).")
    public LocalDate getNextPaymentDueDate() {
        return this.nextPaymentDueDate;
    }

    public void setNextPaymentDueDate(LocalDate nextPaymentDueDate) {
        this.nextPaymentDueDate = nextPaymentDueDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreditCardLiability creditCardLiability = (CreditCardLiability)o;
        return Objects.equals(this.accountId, creditCardLiability.accountId) && Objects.equals(this.aprs, creditCardLiability.aprs) && Objects.equals(this.isOverdue, creditCardLiability.isOverdue) && Objects.equals(this.lastPaymentAmount, creditCardLiability.lastPaymentAmount) && Objects.equals(this.lastPaymentDate, creditCardLiability.lastPaymentDate) && Objects.equals(this.lastStatementIssueDate, creditCardLiability.lastStatementIssueDate) && Objects.equals(this.lastStatementBalance, creditCardLiability.lastStatementBalance) && Objects.equals(this.minimumPaymentAmount, creditCardLiability.minimumPaymentAmount) && Objects.equals(this.nextPaymentDueDate, creditCardLiability.nextPaymentDueDate);
    }

    public int hashCode() {
        return Objects.hash(this.accountId, this.aprs, this.isOverdue, this.lastPaymentAmount, this.lastPaymentDate, this.lastStatementIssueDate, this.lastStatementBalance, this.minimumPaymentAmount, this.nextPaymentDueDate);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreditCardLiability {\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    aprs: ").append(this.toIndentedString(this.aprs)).append("\n");
        sb.append("    isOverdue: ").append(this.toIndentedString(this.isOverdue)).append("\n");
        sb.append("    lastPaymentAmount: ").append(this.toIndentedString(this.lastPaymentAmount)).append("\n");
        sb.append("    lastPaymentDate: ").append(this.toIndentedString(this.lastPaymentDate)).append("\n");
        sb.append("    lastStatementIssueDate: ").append(this.toIndentedString(this.lastStatementIssueDate)).append("\n");
        sb.append("    lastStatementBalance: ").append(this.toIndentedString(this.lastStatementBalance)).append("\n");
        sb.append("    minimumPaymentAmount: ").append(this.toIndentedString(this.minimumPaymentAmount)).append("\n");
        sb.append("    nextPaymentDueDate: ").append(this.toIndentedString(this.nextPaymentDueDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

