/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Information describing the intent of the transaction. Most relevant for credit use cases, but not limited to such use cases.  See the [`taxonomy csv file`](https://plaid.com/documents/credit-category-taxonomy.csv) for a full list of credit categories.")
public class CreditCategory {
    public static final String SERIALIZED_NAME_PRIMARY = "primary";
    @SerializedName(value="primary")
    private String primary;
    public static final String SERIALIZED_NAME_DETAILED = "detailed";
    @SerializedName(value="detailed")
    private String detailed;

    public CreditCategory primary(String primary) {
        this.primary = primary;
        return this;
    }

    @ApiModelProperty(required=true, value="A high level category that communicates the broad category of the transaction.")
    public String getPrimary() {
        return this.primary;
    }

    public void setPrimary(String primary) {
        this.primary = primary;
    }

    public CreditCategory detailed(String detailed) {
        this.detailed = detailed;
        return this;
    }

    @ApiModelProperty(required=true, value="A granular category conveying the transaction's intent. This field can also be used as a unique identifier for the category.")
    public String getDetailed() {
        return this.detailed;
    }

    public void setDetailed(String detailed) {
        this.detailed = detailed;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreditCategory creditCategory = (CreditCategory)o;
        return Objects.equals(this.primary, creditCategory.primary) && Objects.equals(this.detailed, creditCategory.detailed);
    }

    public int hashCode() {
        return Objects.hash(this.primary, this.detailed);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreditCategory {\n");
        sb.append("    primary: ").append(this.toIndentedString(this.primary)).append("\n");
        sb.append("    detailed: ").append(this.toIndentedString(this.detailed)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

