/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Object representing metadata pertaining to the document.")
public class CreditDocumentMetadata {
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_DOCUMENT_TYPE = "document_type";
    @SerializedName(value="document_type")
    private String documentType;
    public static final String SERIALIZED_NAME_DOWNLOAD_URL = "download_url";
    @SerializedName(value="download_url")
    private String downloadUrl;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private String status;
    public static final String SERIALIZED_NAME_PAGE_COUNT = "page_count";
    @SerializedName(value="page_count")
    private Integer pageCount;
    public static final String SERIALIZED_NAME_ERROR_MESSAGE = "error_message";
    @SerializedName(value="error_message")
    private String errorMessage;

    public CreditDocumentMetadata name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="The name of the document.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CreditDocumentMetadata documentType(String documentType) {
        this.documentType = documentType;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The type of document.  `PAYSTUB`: A paystub.  `BANK_STATEMENT`: A bank statement.  `US_TAX_W2`: A W-2 wage and tax statement provided by a US employer reflecting wages earned by the employee.  `US_MILITARY_ERAS`: An electronic Retirement Account Statement (eRAS) issued by the US military.  `US_MILITARY_LES`: A Leave and Earnings Statement (LES) issued by the US military.  `US_MILITARY_CLES`: A Civilian Leave and Earnings Statement (CLES) issued by the US military.  `GIG`: Used to indicate that the income is related to gig work. Does not necessarily correspond to a specific document type.  `PLAID_GENERATED_PAYSTUB_PDF`: Used to indicate that the PDF for the paystub was generated by Plaid.  `NONE`: Used to indicate that there is no underlying document for the data.  `UNKNOWN`: Document type could not be determined.")
    public String getDocumentType() {
        return this.documentType;
    }

    public void setDocumentType(String documentType) {
        this.documentType = documentType;
    }

    public CreditDocumentMetadata downloadUrl(String downloadUrl) {
        this.downloadUrl = downloadUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="Signed URL to retrieve the underlying file. For Payroll Income, the file type will always be PDF, and the file may not be available, in which case the field will be `null`. If you would like Plaid to generate a PDF if the original is not available, contact your Account Manager. [Example generated pay stub](https://www.plaid.com/documents/plaid-generated-mock-paystub.pdf).  For Document Income, this field will not be `null`, and the file type will be the original file type uploaded by the user. For more details on available file types, see the [Document Income](https://www.plaid.com/docs/income/payroll-income) documentation.  This download URL can only be used once and expires after two minutes. To generate a new download URL, call `/credit/payroll_income/get` again.")
    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    public void setDownloadUrl(String downloadUrl) {
        this.downloadUrl = downloadUrl;
    }

    public CreditDocumentMetadata status(String status) {
        this.status = status;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The processing status of the document.  `PROCESSING_COMPLETE`: The document was successfully processed.  `DOCUMENT_ERROR`: The document could not be processed. Possible causes include: The document was an unacceptable document type such as an offer letter or bank statement, the document image was cropped or blurry, or the document was corrupted.  `UNKNOWN` or `null`: An internal error occurred. If this happens repeatedly, contact support or your Plaid account manager.")
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public CreditDocumentMetadata pageCount(Integer pageCount) {
        this.pageCount = pageCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of pages of the uploaded document (if available).")
    public Integer getPageCount() {
        return this.pageCount;
    }

    public void setPageCount(Integer pageCount) {
        this.pageCount = pageCount;
    }

    public CreditDocumentMetadata errorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The reason why a failure occurred during document processing (if available).")
    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreditDocumentMetadata creditDocumentMetadata = (CreditDocumentMetadata)o;
        return Objects.equals(this.name, creditDocumentMetadata.name) && Objects.equals(this.documentType, creditDocumentMetadata.documentType) && Objects.equals(this.downloadUrl, creditDocumentMetadata.downloadUrl) && Objects.equals(this.status, creditDocumentMetadata.status) && Objects.equals(this.pageCount, creditDocumentMetadata.pageCount) && Objects.equals(this.errorMessage, creditDocumentMetadata.errorMessage);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.documentType, this.downloadUrl, this.status, this.pageCount, this.errorMessage);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreditDocumentMetadata {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    documentType: ").append(this.toIndentedString(this.documentType)).append("\n");
        sb.append("    downloadUrl: ").append(this.toIndentedString(this.downloadUrl)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    pageCount: ").append(this.toIndentedString(this.pageCount)).append("\n");
        sb.append("    errorMessage: ").append(this.toIndentedString(this.errorMessage)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

