/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.CreditEmploymentVerification;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The object containing employment items.")
public class CreditEmploymentItem {
    public static final String SERIALIZED_NAME_ITEM_ID = "item_id";
    @SerializedName(value="item_id")
    private String itemId;
    public static final String SERIALIZED_NAME_EMPLOYMENTS = "employments";
    @SerializedName(value="employments")
    private List<CreditEmploymentVerification> employments = new ArrayList<CreditEmploymentVerification>();
    public static final String SERIALIZED_NAME_EMPLOYMENT_REPORT_TOKEN = "employment_report_token";
    @SerializedName(value="employment_report_token")
    private String employmentReportToken;

    public CreditEmploymentItem itemId(String itemId) {
        this.itemId = itemId;
        return this;
    }

    @ApiModelProperty(required=true, value="The `item_id` of the Item associated with this webhook, warning, or error")
    public String getItemId() {
        return this.itemId;
    }

    public void setItemId(String itemId) {
        this.itemId = itemId;
    }

    public CreditEmploymentItem employments(List<CreditEmploymentVerification> employments) {
        this.employments = employments;
        return this;
    }

    public CreditEmploymentItem addEmploymentsItem(CreditEmploymentVerification employmentsItem) {
        this.employments.add(employmentsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public List<CreditEmploymentVerification> getEmployments() {
        return this.employments;
    }

    public void setEmployments(List<CreditEmploymentVerification> employments) {
        this.employments = employments;
    }

    public CreditEmploymentItem employmentReportToken(String employmentReportToken) {
        this.employmentReportToken = employmentReportToken;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Token to represent the underlying Employment data")
    public String getEmploymentReportToken() {
        return this.employmentReportToken;
    }

    public void setEmploymentReportToken(String employmentReportToken) {
        this.employmentReportToken = employmentReportToken;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreditEmploymentItem creditEmploymentItem = (CreditEmploymentItem)o;
        return Objects.equals(this.itemId, creditEmploymentItem.itemId) && Objects.equals(this.employments, creditEmploymentItem.employments) && Objects.equals(this.employmentReportToken, creditEmploymentItem.employmentReportToken);
    }

    public int hashCode() {
        return Objects.hash(this.itemId, this.employments, this.employmentReportToken);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreditEmploymentItem {\n");
        sb.append("    itemId: ").append(this.toIndentedString(this.itemId)).append("\n");
        sb.append("    employments: ").append(this.toIndentedString(this.employments)).append("\n");
        sb.append("    employmentReportToken: ").append(this.toIndentedString(this.employmentReportToken)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

