/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.CreditEmployerVerification;
import com.plaid.client.model.CreditPlatformIds;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The object containing proof of employment data for an individual.")
public class CreditEmploymentVerification {
    public static final String SERIALIZED_NAME_ACCOUNT_ID = "account_id";
    @SerializedName(value="account_id")
    private String accountId;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private String status;
    public static final String SERIALIZED_NAME_START_DATE = "start_date";
    @SerializedName(value="start_date")
    private LocalDate startDate;
    public static final String SERIALIZED_NAME_END_DATE = "end_date";
    @SerializedName(value="end_date")
    private LocalDate endDate;
    public static final String SERIALIZED_NAME_EMPLOYER = "employer";
    @SerializedName(value="employer")
    private CreditEmployerVerification employer;
    public static final String SERIALIZED_NAME_TITLE = "title";
    @SerializedName(value="title")
    private String title;
    public static final String SERIALIZED_NAME_PLATFORM_IDS = "platform_ids";
    @SerializedName(value="platform_ids")
    private CreditPlatformIds platformIds;
    public static final String SERIALIZED_NAME_EMPLOYEE_TYPE = "employee_type";
    @SerializedName(value="employee_type")
    private String employeeType;
    public static final String SERIALIZED_NAME_LAST_PAYSTUB_DATE = "last_paystub_date";
    @SerializedName(value="last_paystub_date")
    private LocalDate lastPaystubDate;

    public CreditEmploymentVerification accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="ID of the payroll provider account.")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public CreditEmploymentVerification status(String status) {
        this.status = status;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="Current employment status.")
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public CreditEmploymentVerification startDate(LocalDate startDate) {
        this.startDate = startDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="Start of employment in ISO 8601 format (YYYY-MM-DD).")
    public LocalDate getStartDate() {
        return this.startDate;
    }

    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    public CreditEmploymentVerification endDate(LocalDate endDate) {
        this.endDate = endDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="End of employment, if applicable. Provided in ISO 8601 format (YYY-MM-DD).")
    public LocalDate getEndDate() {
        return this.endDate;
    }

    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    public CreditEmploymentVerification employer(CreditEmployerVerification employer) {
        this.employer = employer;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public CreditEmployerVerification getEmployer() {
        return this.employer;
    }

    public void setEmployer(CreditEmployerVerification employer) {
        this.employer = employer;
    }

    public CreditEmploymentVerification title(String title) {
        this.title = title;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="Current title of employee.")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public CreditEmploymentVerification platformIds(CreditPlatformIds platformIds) {
        this.platformIds = platformIds;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public CreditPlatformIds getPlatformIds() {
        return this.platformIds;
    }

    public void setPlatformIds(CreditPlatformIds platformIds) {
        this.platformIds = platformIds;
    }

    public CreditEmploymentVerification employeeType(String employeeType) {
        this.employeeType = employeeType;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The type of employment for the individual. `\"FULL_TIME\"`: A full-time employee. `\"PART_TIME\"`: A part-time employee. `\"CONTRACTOR\"`: An employee typically hired externally through a contracting group. `\"TEMPORARY\"`: A temporary employee. `\"OTHER\"`: The employee type is not one of the above defined types.")
    public String getEmployeeType() {
        return this.employeeType;
    }

    public void setEmployeeType(String employeeType) {
        this.employeeType = employeeType;
    }

    public CreditEmploymentVerification lastPaystubDate(LocalDate lastPaystubDate) {
        this.lastPaystubDate = lastPaystubDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The date of the employee's most recent paystub in ISO 8601 format (YYYY-MM-DD).")
    public LocalDate getLastPaystubDate() {
        return this.lastPaystubDate;
    }

    public void setLastPaystubDate(LocalDate lastPaystubDate) {
        this.lastPaystubDate = lastPaystubDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreditEmploymentVerification creditEmploymentVerification = (CreditEmploymentVerification)o;
        return Objects.equals(this.accountId, creditEmploymentVerification.accountId) && Objects.equals(this.status, creditEmploymentVerification.status) && Objects.equals(this.startDate, creditEmploymentVerification.startDate) && Objects.equals(this.endDate, creditEmploymentVerification.endDate) && Objects.equals(this.employer, creditEmploymentVerification.employer) && Objects.equals(this.title, creditEmploymentVerification.title) && Objects.equals(this.platformIds, creditEmploymentVerification.platformIds) && Objects.equals(this.employeeType, creditEmploymentVerification.employeeType) && Objects.equals(this.lastPaystubDate, creditEmploymentVerification.lastPaystubDate);
    }

    public int hashCode() {
        return Objects.hash(this.accountId, this.status, this.startDate, this.endDate, this.employer, this.title, this.platformIds, this.employeeType, this.lastPaystubDate);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreditEmploymentVerification {\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    employer: ").append(this.toIndentedString(this.employer)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    platformIds: ").append(this.toIndentedString(this.platformIds)).append("\n");
        sb.append("    employeeType: ").append(this.toIndentedString(this.employeeType)).append("\n");
        sb.append("    lastPaystubDate: ").append(this.toIndentedString(this.lastPaystubDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

