/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.IncomeVerificationDocParsingConfig;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="CreditPayrollIncomeParsingConfigUpdateRequest defines the request schema for `/credit/payroll_income/documents/update`.")
public class CreditPayrollIncomeParsingConfigUpdateRequest {
    public static final String SERIALIZED_NAME_CLIENT_ID = "client_id";
    @SerializedName(value="client_id")
    private String clientId;
    public static final String SERIALIZED_NAME_SECRET = "secret";
    @SerializedName(value="secret")
    private String secret;
    public static final String SERIALIZED_NAME_USER_TOKEN = "user_token";
    @SerializedName(value="user_token")
    private String userToken;
    public static final String SERIALIZED_NAME_ITEM_ID = "item_id";
    @SerializedName(value="item_id")
    private String itemId;
    public static final String SERIALIZED_NAME_PARSING_CONFIG = "parsing_config";
    @SerializedName(value="parsing_config")
    private List<IncomeVerificationDocParsingConfig> parsingConfig = new ArrayList<IncomeVerificationDocParsingConfig>();

    public CreditPayrollIncomeParsingConfigUpdateRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public CreditPayrollIncomeParsingConfigUpdateRequest secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public CreditPayrollIncomeParsingConfigUpdateRequest userToken(String userToken) {
        this.userToken = userToken;
        return this;
    }

    @ApiModelProperty(required=true, value="The user token associated with the User data is being requested for.")
    public String getUserToken() {
        return this.userToken;
    }

    public void setUserToken(String userToken) {
        this.userToken = userToken;
    }

    public CreditPayrollIncomeParsingConfigUpdateRequest itemId(String itemId) {
        this.itemId = itemId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The `item_id` of the Item associated with this webhook, warning, or error")
    public String getItemId() {
        return this.itemId;
    }

    public void setItemId(String itemId) {
        this.itemId = itemId;
    }

    public CreditPayrollIncomeParsingConfigUpdateRequest parsingConfig(List<IncomeVerificationDocParsingConfig> parsingConfig) {
        this.parsingConfig = parsingConfig;
        return this;
    }

    public CreditPayrollIncomeParsingConfigUpdateRequest addParsingConfigItem(IncomeVerificationDocParsingConfig parsingConfigItem) {
        this.parsingConfig.add(parsingConfigItem);
        return this;
    }

    @ApiModelProperty(required=true, value="The types of analysis to enable for the document income verification session")
    public List<IncomeVerificationDocParsingConfig> getParsingConfig() {
        return this.parsingConfig;
    }

    public void setParsingConfig(List<IncomeVerificationDocParsingConfig> parsingConfig) {
        this.parsingConfig = parsingConfig;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreditPayrollIncomeParsingConfigUpdateRequest creditPayrollIncomeParsingConfigUpdateRequest = (CreditPayrollIncomeParsingConfigUpdateRequest)o;
        return Objects.equals(this.clientId, creditPayrollIncomeParsingConfigUpdateRequest.clientId) && Objects.equals(this.secret, creditPayrollIncomeParsingConfigUpdateRequest.secret) && Objects.equals(this.userToken, creditPayrollIncomeParsingConfigUpdateRequest.userToken) && Objects.equals(this.itemId, creditPayrollIncomeParsingConfigUpdateRequest.itemId) && Objects.equals(this.parsingConfig, creditPayrollIncomeParsingConfigUpdateRequest.parsingConfig);
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.secret, this.userToken, this.itemId, this.parsingConfig);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreditPayrollIncomeParsingConfigUpdateRequest {\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    userToken: ").append(this.toIndentedString(this.userToken)).append("\n");
        sb.append("    itemId: ").append(this.toIndentedString(this.itemId)).append("\n");
        sb.append("    parsingConfig: ").append(this.toIndentedString(this.parsingConfig)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

