/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.IncomeVerificationPrecheckEmployer;
import com.plaid.client.model.IncomeVerificationPrecheckMilitaryInfo;
import com.plaid.client.model.IncomeVerificationPrecheckPayrollInstitution;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Defines the request schema for `/credit/payroll_income/precheck`.")
public class CreditPayrollIncomePrecheckRequest {
    public static final String SERIALIZED_NAME_CLIENT_ID = "client_id";
    @SerializedName(value="client_id")
    private String clientId;
    public static final String SERIALIZED_NAME_SECRET = "secret";
    @SerializedName(value="secret")
    private String secret;
    public static final String SERIALIZED_NAME_USER_TOKEN = "user_token";
    @SerializedName(value="user_token")
    private String userToken;
    public static final String SERIALIZED_NAME_ACCESS_TOKENS = "access_tokens";
    @SerializedName(value="access_tokens")
    private List<String> accessTokens = null;
    public static final String SERIALIZED_NAME_EMPLOYER = "employer";
    @SerializedName(value="employer")
    private IncomeVerificationPrecheckEmployer employer;
    public static final String SERIALIZED_NAME_US_MILITARY_INFO = "us_military_info";
    @SerializedName(value="us_military_info")
    private IncomeVerificationPrecheckMilitaryInfo usMilitaryInfo;
    public static final String SERIALIZED_NAME_PAYROLL_INSTITUTION = "payroll_institution";
    @SerializedName(value="payroll_institution")
    private IncomeVerificationPrecheckPayrollInstitution payrollInstitution;

    public CreditPayrollIncomePrecheckRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public CreditPayrollIncomePrecheckRequest secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public CreditPayrollIncomePrecheckRequest userToken(String userToken) {
        this.userToken = userToken;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The user token associated with the User data is being requested for.")
    public String getUserToken() {
        return this.userToken;
    }

    public void setUserToken(String userToken) {
        this.userToken = userToken;
    }

    public CreditPayrollIncomePrecheckRequest accessTokens(List<String> accessTokens) {
        this.accessTokens = accessTokens;
        return this;
    }

    public CreditPayrollIncomePrecheckRequest addAccessTokensItem(String accessTokensItem) {
        if (this.accessTokens == null) {
            this.accessTokens = new ArrayList<String>();
        }
        this.accessTokens.add(accessTokensItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An array of access tokens corresponding to Items belonging to the user whose eligibility is being checked. Note that if the Items specified here are not already initialized with `transactions`, providing them in this field will cause these Items to be initialized with (and billed for) the Transactions product.")
    public List<String> getAccessTokens() {
        return this.accessTokens;
    }

    public void setAccessTokens(List<String> accessTokens) {
        this.accessTokens = accessTokens;
    }

    public CreditPayrollIncomePrecheckRequest employer(IncomeVerificationPrecheckEmployer employer) {
        this.employer = employer;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public IncomeVerificationPrecheckEmployer getEmployer() {
        return this.employer;
    }

    public void setEmployer(IncomeVerificationPrecheckEmployer employer) {
        this.employer = employer;
    }

    public CreditPayrollIncomePrecheckRequest usMilitaryInfo(IncomeVerificationPrecheckMilitaryInfo usMilitaryInfo) {
        this.usMilitaryInfo = usMilitaryInfo;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public IncomeVerificationPrecheckMilitaryInfo getUsMilitaryInfo() {
        return this.usMilitaryInfo;
    }

    public void setUsMilitaryInfo(IncomeVerificationPrecheckMilitaryInfo usMilitaryInfo) {
        this.usMilitaryInfo = usMilitaryInfo;
    }

    public CreditPayrollIncomePrecheckRequest payrollInstitution(IncomeVerificationPrecheckPayrollInstitution payrollInstitution) {
        this.payrollInstitution = payrollInstitution;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public IncomeVerificationPrecheckPayrollInstitution getPayrollInstitution() {
        return this.payrollInstitution;
    }

    public void setPayrollInstitution(IncomeVerificationPrecheckPayrollInstitution payrollInstitution) {
        this.payrollInstitution = payrollInstitution;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreditPayrollIncomePrecheckRequest creditPayrollIncomePrecheckRequest = (CreditPayrollIncomePrecheckRequest)o;
        return Objects.equals(this.clientId, creditPayrollIncomePrecheckRequest.clientId) && Objects.equals(this.secret, creditPayrollIncomePrecheckRequest.secret) && Objects.equals(this.userToken, creditPayrollIncomePrecheckRequest.userToken) && Objects.equals(this.accessTokens, creditPayrollIncomePrecheckRequest.accessTokens) && Objects.equals(this.employer, creditPayrollIncomePrecheckRequest.employer) && Objects.equals(this.usMilitaryInfo, creditPayrollIncomePrecheckRequest.usMilitaryInfo) && Objects.equals(this.payrollInstitution, creditPayrollIncomePrecheckRequest.payrollInstitution);
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.secret, this.userToken, this.accessTokens, this.employer, this.usMilitaryInfo, this.payrollInstitution);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreditPayrollIncomePrecheckRequest {\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    userToken: ").append(this.toIndentedString(this.userToken)).append("\n");
        sb.append("    accessTokens: ").append(this.toIndentedString(this.accessTokens)).append("\n");
        sb.append("    employer: ").append(this.toIndentedString(this.employer)).append("\n");
        sb.append("    usMilitaryInfo: ").append(this.toIndentedString(this.usMilitaryInfo)).append("\n");
        sb.append("    payrollInstitution: ").append(this.toIndentedString(this.payrollInstitution)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

