/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="CreditPayrollIncomeRefreshResponse defines the response schema for `/credit/payroll_income/refresh`")
public class CreditPayrollIncomeRefreshResponse {
    public static final String SERIALIZED_NAME_REQUEST_ID = "request_id";
    @SerializedName(value="request_id")
    private String requestId;
    public static final String SERIALIZED_NAME_VERIFICATION_REFRESH_STATUS = "verification_refresh_status";
    @SerializedName(value="verification_refresh_status")
    private String verificationRefreshStatus;

    public CreditPayrollIncomeRefreshResponse requestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    @ApiModelProperty(required=true, value="A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.")
    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public CreditPayrollIncomeRefreshResponse verificationRefreshStatus(String verificationRefreshStatus) {
        this.verificationRefreshStatus = verificationRefreshStatus;
        return this;
    }

    @ApiModelProperty(required=true, value="The verification refresh status. One of the following:  `\"USER_PRESENCE_REQUIRED\"` User presence is required to refresh an income verification. `\"SUCCESSFUL\"` The income verification refresh was successful. `\"NOT_FOUND\"` No new data was found after the income verification refresh.")
    public String getVerificationRefreshStatus() {
        return this.verificationRefreshStatus;
    }

    public void setVerificationRefreshStatus(String verificationRefreshStatus) {
        this.verificationRefreshStatus = verificationRefreshStatus;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreditPayrollIncomeRefreshResponse creditPayrollIncomeRefreshResponse = (CreditPayrollIncomeRefreshResponse)o;
        return Objects.equals(this.requestId, creditPayrollIncomeRefreshResponse.requestId) && Objects.equals(this.verificationRefreshStatus, creditPayrollIncomeRefreshResponse.verificationRefreshStatus);
    }

    public int hashCode() {
        return Objects.hash(this.requestId, this.verificationRefreshStatus);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreditPayrollIncomeRefreshResponse {\n");
        sb.append("    requestId: ").append(this.toIndentedString(this.requestId)).append("\n");
        sb.append("    verificationRefreshStatus: ").append(this.toIndentedString(this.verificationRefreshStatus)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

