/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="CreditRelayCreateRequest defines the request schema for `/credit/relay/create`")
public class CreditRelayCreateRequest {
    public static final String SERIALIZED_NAME_CLIENT_ID = "client_id";
    @SerializedName(value="client_id")
    private String clientId;
    public static final String SERIALIZED_NAME_SECRET = "secret";
    @SerializedName(value="secret")
    private String secret;
    public static final String SERIALIZED_NAME_REPORT_TOKENS = "report_tokens";
    @SerializedName(value="report_tokens")
    private List<String> reportTokens = new ArrayList<String>();
    public static final String SERIALIZED_NAME_SECONDARY_CLIENT_ID = "secondary_client_id";
    @SerializedName(value="secondary_client_id")
    private String secondaryClientId;
    public static final String SERIALIZED_NAME_WEBHOOK = "webhook";
    @SerializedName(value="webhook")
    private String webhook;

    public CreditRelayCreateRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public CreditRelayCreateRequest secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public CreditRelayCreateRequest reportTokens(List<String> reportTokens) {
        this.reportTokens = reportTokens;
        return this;
    }

    public CreditRelayCreateRequest addReportTokensItem(String reportTokensItem) {
        this.reportTokens.add(reportTokensItem);
        return this;
    }

    @ApiModelProperty(required=true, value="List of report token strings, with at most one token of each report type. Currently only Asset Report token is supported.")
    public List<String> getReportTokens() {
        return this.reportTokens;
    }

    public void setReportTokens(List<String> reportTokens) {
        this.reportTokens = reportTokens;
    }

    public CreditRelayCreateRequest secondaryClientId(String secondaryClientId) {
        this.secondaryClientId = secondaryClientId;
        return this;
    }

    @ApiModelProperty(required=true, value="The `secondary_client_id` is the client id of the third party with whom you would like to share the relay token.")
    public String getSecondaryClientId() {
        return this.secondaryClientId;
    }

    public void setSecondaryClientId(String secondaryClientId) {
        this.secondaryClientId = secondaryClientId;
    }

    public CreditRelayCreateRequest webhook(String webhook) {
        this.webhook = webhook;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="URL to which Plaid will send webhooks when the Secondary Client successfully retrieves an Asset Report by calling `/credit/relay/get`.")
    public String getWebhook() {
        return this.webhook;
    }

    public void setWebhook(String webhook) {
        this.webhook = webhook;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreditRelayCreateRequest creditRelayCreateRequest = (CreditRelayCreateRequest)o;
        return Objects.equals(this.clientId, creditRelayCreateRequest.clientId) && Objects.equals(this.secret, creditRelayCreateRequest.secret) && Objects.equals(this.reportTokens, creditRelayCreateRequest.reportTokens) && Objects.equals(this.secondaryClientId, creditRelayCreateRequest.secondaryClientId) && Objects.equals(this.webhook, creditRelayCreateRequest.webhook);
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.secret, this.reportTokens, this.secondaryClientId, this.webhook);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreditRelayCreateRequest {\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    reportTokens: ").append(this.toIndentedString(this.reportTokens)).append("\n");
        sb.append("    secondaryClientId: ").append(this.toIndentedString(this.secondaryClientId)).append("\n");
        sb.append("    webhook: ").append(this.toIndentedString(this.webhook)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

