/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.ReportType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="CreditRelayGetRequest defines the request schema for `/credit/relay/get`")
public class CreditRelayGetRequest {
    public static final String SERIALIZED_NAME_CLIENT_ID = "client_id";
    @SerializedName(value="client_id")
    private String clientId;
    public static final String SERIALIZED_NAME_SECRET = "secret";
    @SerializedName(value="secret")
    private String secret;
    public static final String SERIALIZED_NAME_RELAY_TOKEN = "relay_token";
    @SerializedName(value="relay_token")
    private String relayToken;
    public static final String SERIALIZED_NAME_REPORT_TYPE = "report_type";
    @SerializedName(value="report_type")
    private ReportType reportType;
    public static final String SERIALIZED_NAME_INCLUDE_INSIGHTS = "include_insights";
    @SerializedName(value="include_insights")
    private Boolean includeInsights = false;

    public CreditRelayGetRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public CreditRelayGetRequest secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public CreditRelayGetRequest relayToken(String relayToken) {
        this.relayToken = relayToken;
        return this;
    }

    @ApiModelProperty(required=true, value="The `relay_token` granting access to the report you would like to get.")
    public String getRelayToken() {
        return this.relayToken;
    }

    public void setRelayToken(String relayToken) {
        this.relayToken = relayToken;
    }

    public CreditRelayGetRequest reportType(ReportType reportType) {
        this.reportType = reportType;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public ReportType getReportType() {
        return this.reportType;
    }

    public void setReportType(ReportType reportType) {
        this.reportType = reportType;
    }

    public CreditRelayGetRequest includeInsights(Boolean includeInsights) {
        this.includeInsights = includeInsights;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="`true` if you would like to retrieve the Asset Report with Insights, `false` otherwise. This field defaults to `false` if omitted.")
    public Boolean getIncludeInsights() {
        return this.includeInsights;
    }

    public void setIncludeInsights(Boolean includeInsights) {
        this.includeInsights = includeInsights;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreditRelayGetRequest creditRelayGetRequest = (CreditRelayGetRequest)o;
        return Objects.equals(this.clientId, creditRelayGetRequest.clientId) && Objects.equals(this.secret, creditRelayGetRequest.secret) && Objects.equals(this.relayToken, creditRelayGetRequest.relayToken) && Objects.equals((Object)this.reportType, (Object)creditRelayGetRequest.reportType) && Objects.equals(this.includeInsights, creditRelayGetRequest.includeInsights);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.clientId, this.secret, this.relayToken, this.reportType, this.includeInsights});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreditRelayGetRequest {\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    relayToken: ").append(this.toIndentedString(this.relayToken)).append("\n");
        sb.append("    reportType: ").append(this.toIndentedString((Object)this.reportType)).append("\n");
        sb.append("    includeInsights: ").append(this.toIndentedString(this.includeInsights)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

